/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class SerializationUtil {
    private SerializationUtil() {
    }

    @NotNull
    public static byte[] serializeClassData(@NotNull ClassData classData) {
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            SerializationUtil.serializeNameResolver(result, classData.getNameResolver());
            classData.getClassProto().writeTo(result);
            return result.toByteArray();
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
    }

    @NotNull
    public static byte[] serializePackageData(@NotNull PackageData packageData) {
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            SerializationUtil.serializeNameResolver(result, packageData.getNameResolver());
            packageData.getPackageProto().writeTo(result);
            return result.toByteArray();
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
    }

    private static void serializeNameResolver(@NotNull OutputStream out, @NotNull NameResolver nameResolver) {
        SerializationUtil.serializeStringTable(out, nameResolver.getStringTable(), nameResolver.getQualifiedNameTable());
    }

    public static void serializeStringTable(@NotNull OutputStream out, @NotNull ProtoBuf.StringTable stringTable, @NotNull ProtoBuf.QualifiedNameTable qualifiedNameTable) {
        try {
            stringTable.writeDelimitedTo(out);
            qualifiedNameTable.writeDelimitedTo(out);
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
    }
}

