/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

public abstract class DeclarationDescriptorImpl
extends AnnotatedImpl
implements DeclarationDescriptor {
    @NotNull
    private final Name name;

    public DeclarationDescriptorImpl(@NotNull Annotations annotations2, @NotNull Name name) {
        super(annotations2);
        this.name = name;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        this.accept(visitor, null);
    }

    public String toString() {
        return DeclarationDescriptorImpl.toString(this);
    }

    @NotNull
    static String toString(@NotNull DeclarationDescriptor descriptor2) {
        try {
            return DescriptorRenderer.DEBUG_TEXT.render(descriptor2) + "[" + descriptor2.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(descriptor2)) + "]";
        }
        catch (Throwable e) {
            return descriptor2.getClass().getSimpleName() + " " + descriptor2.getName();
        }
    }
}

