/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.com.google.protobuf;

import java.util.Collections;
import java.util.List;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.MessageLite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UninitializedMessageException
extends RuntimeException {
    private static final long serialVersionUID = -7466929953374883507L;
    private final List<String> missingFields;

    public UninitializedMessageException(MessageLite message) {
        super("Message was missing required fields.  (Lite runtime could not determine which fields were missing).");
        this.missingFields = null;
    }

    public UninitializedMessageException(List<String> missingFields) {
        super(UninitializedMessageException.buildDescription(missingFields));
        this.missingFields = missingFields;
    }

    public List<String> getMissingFields() {
        return Collections.unmodifiableList(this.missingFields);
    }

    public InvalidProtocolBufferException asInvalidProtocolBufferException() {
        return new InvalidProtocolBufferException(this.getMessage());
    }

    private static String buildDescription(List<String> missingFields) {
        StringBuilder description = new StringBuilder("Message missing required fields: ");
        boolean first = true;
        for (String field2 : missingFields) {
            if (first) {
                first = false;
            } else {
                description.append(", ");
            }
            description.append(field2);
        }
        return description.toString();
    }
}

