/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.annotations;

import java.util.Collections;
import java.util.Map;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstant;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;

public class AnnotationDescriptorImpl
implements AnnotationDescriptor {
    private final JetType annotationType;
    private final Map<ValueParameterDescriptor, CompileTimeConstant<?>> valueArguments;

    public AnnotationDescriptorImpl(@NotNull JetType annotationType, @NotNull Map<ValueParameterDescriptor, CompileTimeConstant<?>> valueArguments) {
        if (annotationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationType", "kotlin/reflect/jvm/internal/impl/descriptors/annotations/AnnotationDescriptorImpl", "<init>"));
        }
        if (valueArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "kotlin/reflect/jvm/internal/impl/descriptors/annotations/AnnotationDescriptorImpl", "<init>"));
        }
        this.annotationType = annotationType;
        this.valueArguments = Collections.unmodifiableMap(valueArguments);
    }

    @Override
    @NotNull
    public JetType getType() {
        JetType jetType = this.annotationType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/annotations/AnnotationDescriptorImpl", "getType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, CompileTimeConstant<?>> getAllValueArguments() {
        Map<ValueParameterDescriptor, CompileTimeConstant<?>> map = this.valueArguments;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/annotations/AnnotationDescriptorImpl", "getAllValueArguments"));
        }
        return map;
    }

    public String toString() {
        return DescriptorRenderer.FQ_NAMES_IN_TYPES.renderAnnotation(this);
    }
}

