/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerValueTypeConstructor
implements TypeConstructor {
    private final long value;
    private final Collection<JetType> supertypes = new ArrayList<JetType>(4);

    public IntegerValueTypeConstructor(long value) {
        this.value = value;
        this.checkBoundsAndAddSuperType(value, Integer.MIN_VALUE, Integer.MAX_VALUE, KotlinBuiltIns.getInstance().getIntType());
        this.checkBoundsAndAddSuperType(value, -128L, 127L, KotlinBuiltIns.getInstance().getByteType());
        this.checkBoundsAndAddSuperType(value, -32768L, 32767L, KotlinBuiltIns.getInstance().getShortType());
        this.supertypes.add(KotlinBuiltIns.getInstance().getLongType());
    }

    private void checkBoundsAndAddSuperType(long value, long minValue, long maxValue, JetType kotlinType) {
        if (value >= minValue && value <= maxValue) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        Collection<JetType> collection = this.supertypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/IntegerValueTypeConstructor", "getSupertypes"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        List<TypeParameterDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/IntegerValueTypeConstructor", "getParameters"));
        }
        return list;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = Annotations.EMPTY;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/IntegerValueTypeConstructor", "getAnnotations"));
        }
        return annotations2;
    }

    public Long getValue() {
        return this.value;
    }

    public String toString() {
        return "IntegerValueType(" + this.value + ")";
    }
}

