/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.types.JetType;

public interface ExternalSignatureResolver {
    public static final ExternalSignatureResolver DO_NOTHING = new ExternalSignatureResolver(){

        @Override
        @NotNull
        public PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod method, @NotNull ClassDescriptor owner, @NotNull JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
            return new PropagatedMethodSignature(returnType, receiverType, valueParameters, typeParameters, Collections.<String>emptyList(), false, Collections.<FunctionDescriptor>emptyList());
        }

        @Override
        @NotNull
        public AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMember methodOrConstructor, boolean hasSuperMethods, @Nullable JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, boolean hasStableParameterNames) {
            return new AlternativeMethodSignature(returnType, receiverType, valueParameters, typeParameters, Collections.<String>emptyList(), hasStableParameterNames);
        }

        @Override
        @NotNull
        public AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField field2, @NotNull JetType returnType, boolean isVar) {
            return new AlternativeFieldSignature(returnType, null);
        }

        @Override
        public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor2, @NotNull List<String> signatureErrors) {
            throw new UnsupportedOperationException("Should not be called");
        }
    };

    @NotNull
    public PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod var1, @NotNull ClassDescriptor var2, @NotNull JetType var3, @Nullable JetType var4, @NotNull List<ValueParameterDescriptor> var5, @NotNull List<TypeParameterDescriptor> var6);

    @NotNull
    public AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMember var1, boolean var2, @Nullable JetType var3, @Nullable JetType var4, @NotNull List<ValueParameterDescriptor> var5, @NotNull List<TypeParameterDescriptor> var6, boolean var7);

    @NotNull
    public AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField var1, @NotNull JetType var2, boolean var3);

    public void reportSignatureErrors(@NotNull CallableMemberDescriptor var1, @NotNull List<String> var2);

    public static class PropagatedMethodSignature
    extends AlternativeMethodSignature {
        private final List<FunctionDescriptor> superMethods;

        public PropagatedMethodSignature(@Nullable JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<String> signatureErrors, boolean hasStableParameterNames, @NotNull List<FunctionDescriptor> superMethods) {
            super(returnType, receiverType, valueParameters, typeParameters, signatureErrors, hasStableParameterNames);
            this.superMethods = superMethods;
        }

        @NotNull
        public List<FunctionDescriptor> getSuperMethods() {
            return this.superMethods;
        }
    }

    public static class AlternativeFieldSignature
    extends MemberSignature {
        private final JetType returnType;

        public AlternativeFieldSignature(@NotNull JetType returnType, @Nullable String signatureError) {
            super(signatureError == null ? Collections.emptyList() : Collections.singletonList(signatureError));
            this.returnType = returnType;
        }

        @NotNull
        public JetType getReturnType() {
            return this.returnType;
        }
    }

    public static class AlternativeMethodSignature
    extends MemberSignature {
        private final JetType returnType;
        private final JetType receiverType;
        private final List<ValueParameterDescriptor> valueParameters;
        private final List<TypeParameterDescriptor> typeParameters;
        private final boolean hasStableParameterNames;

        public AlternativeMethodSignature(@Nullable JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<String> signatureErrors, boolean hasStableParameterNames) {
            super(signatureErrors);
            this.returnType = returnType;
            this.receiverType = receiverType;
            this.valueParameters = valueParameters;
            this.typeParameters = typeParameters;
            this.hasStableParameterNames = hasStableParameterNames;
        }

        @Nullable
        public JetType getReturnType() {
            return this.returnType;
        }

        @Nullable
        public JetType getReceiverType() {
            return this.receiverType;
        }

        @NotNull
        public List<ValueParameterDescriptor> getValueParameters() {
            return this.valueParameters;
        }

        @NotNull
        public List<TypeParameterDescriptor> getTypeParameters() {
            return this.typeParameters;
        }

        public boolean hasStableParameterNames() {
            return this.hasStableParameterNames;
        }
    }

    public static abstract class MemberSignature {
        private final List<String> signatureErrors;

        protected MemberSignature(@NotNull List<String> signatureErrors) {
            this.signatureErrors = signatureErrors;
        }

        @NotNull
        public List<String> getErrors() {
            return this.signatureErrors;
        }
    }
}

