/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.platform;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

public class JavaToKotlinClassMap
implements PlatformToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE = new JavaToKotlinClassMap();
    private final Map<FqName, ClassDescriptor> javaToKotlin = new HashMap<FqName, ClassDescriptor>();
    private final Map<FqNameUnsafe, ClassId> kotlinToJava = new HashMap<FqNameUnsafe, ClassId>();
    private final Map<ClassDescriptor, ClassDescriptor> mutableToReadOnly = new HashMap<ClassDescriptor, ClassDescriptor>();
    private final Map<ClassDescriptor, ClassDescriptor> readOnlyToMutable = new HashMap<ClassDescriptor, ClassDescriptor>();

    private JavaToKotlinClassMap() {
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        this.add(Object.class, builtIns.getAny());
        this.add(String.class, builtIns.getString());
        this.add(CharSequence.class, builtIns.getCharSequence());
        this.add(Throwable.class, builtIns.getThrowable());
        this.add(Cloneable.class, builtIns.getCloneable());
        this.add(Number.class, builtIns.getNumber());
        this.add(Comparable.class, builtIns.getComparable());
        this.add(Enum.class, builtIns.getEnum());
        this.add(Annotation.class, builtIns.getAnnotation());
        this.add(Iterable.class, builtIns.getIterable(), builtIns.getMutableIterable());
        this.add(Iterator.class, builtIns.getIterator(), builtIns.getMutableIterator());
        this.add(Collection.class, builtIns.getCollection(), builtIns.getMutableCollection());
        this.add(List.class, builtIns.getList(), builtIns.getMutableList());
        this.add(Set.class, builtIns.getSet(), builtIns.getMutableSet());
        this.add(Map.class, builtIns.getMap(), builtIns.getMutableMap());
        this.add(Map.Entry.class, builtIns.getMapEntry(), builtIns.getMutableMapEntry());
        this.add(ListIterator.class, builtIns.getListIterator(), builtIns.getMutableListIterator());
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            this.add(ClassId.topLevel(jvmType.getWrapperFqName()), builtIns.getPrimitiveClassDescriptor(jvmType.getPrimitiveType()));
        }
        for (ClassDescriptor descriptor2 : CompanionObjectMapping.allClassesWithIntrinsicCompanions()) {
            ClassDescriptor companion = descriptor2.getCompanionObjectDescriptor();
            assert (companion != null) : "No companion object found for " + descriptor2;
            this.add(ClassId.topLevel(new FqName("kotlin.jvm.internal." + descriptor2.getName().asString() + "CompanionObject")), companion);
        }
        for (int i = 0; i < 23; ++i) {
            this.add(ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + i)), builtIns.getFunction(i));
            for (String kFun : Arrays.asList("kotlin.reflect.KFunction", "kotlin.reflect.KMemberFunction", "kotlin.reflect.KExtensionFunction")) {
                this.addKotlinToJava(ClassId.topLevel(new FqName(kFun)), new FqNameUnsafe(kFun + i));
            }
        }
        this.addJavaToKotlin(JavaToKotlinClassMap.classId(Deprecated.class), builtIns.getDeprecatedAnnotation());
        this.addKotlinToJava(JavaToKotlinClassMap.classId(Void.class), builtIns.getNothing());
    }

    @Nullable
    public ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2) {
        return this.javaToKotlin.get(fqName2);
    }

    @Nullable
    public ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        return this.kotlinToJava.get(kotlinFqName);
    }

    private void add(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor) {
        ClassId javaClassId = JavaToKotlinClassMap.classId(javaClass);
        this.add(javaClassId, kotlinDescriptor);
        this.addKotlinToJava(javaClassId, kotlinMutableDescriptor);
        this.mutableToReadOnly.put(kotlinMutableDescriptor, kotlinDescriptor);
        this.readOnlyToMutable.put(kotlinDescriptor, kotlinMutableDescriptor);
    }

    private void add(@NotNull ClassId javaClassId, @NotNull ClassDescriptor kotlinDescriptor) {
        this.addJavaToKotlin(javaClassId, kotlinDescriptor);
        this.addKotlinToJava(javaClassId, kotlinDescriptor);
    }

    private void add(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor) {
        this.add(JavaToKotlinClassMap.classId(javaClass), kotlinDescriptor);
    }

    private void addJavaToKotlin(@NotNull ClassId javaClassId, @NotNull ClassDescriptor kotlinDescriptor) {
        this.javaToKotlin.put(javaClassId.asSingleFqName(), kotlinDescriptor);
    }

    private void addKotlinToJava(@NotNull ClassId javaClassId, @NotNull ClassDescriptor kotlinDescriptor) {
        this.addKotlinToJava(javaClassId, DescriptorUtils.getFqName(kotlinDescriptor));
    }

    private void addKotlinToJava(@NotNull ClassId javaClassId, @NotNull FqNameUnsafe kotlinFqName) {
        this.kotlinToJava.put(kotlinFqName, javaClassId);
    }

    @NotNull
    private static ClassId classId(@NotNull Class<?> clazz) {
        assert (!clazz.isPrimitive() && !clazz.isArray()) : "Invalid class: " + clazz;
        Class<?> outer = clazz.getDeclaringClass();
        return outer == null ? ClassId.topLevel(new FqName(clazz.getCanonicalName())) : JavaToKotlinClassMap.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
    }

    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2) {
        ClassDescriptor kotlinAnalog = this.mapJavaToKotlin(fqName2);
        if (kotlinAnalog == null) {
            return Collections.emptySet();
        }
        ClassDescriptor kotlinMutableAnalog = this.readOnlyToMutable.get(kotlinAnalog);
        if (kotlinMutableAnalog == null) {
            return Collections.singleton(kotlinAnalog);
        }
        return Arrays.asList(kotlinAnalog, kotlinMutableAnalog);
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        FqNameUnsafe className = DescriptorUtils.getFqName(classDescriptor);
        return className.isSafe() ? this.mapPlatformClass(className.toSafe()) : Collections.emptySet();
    }

    public boolean isMutableCollection(@NotNull ClassDescriptor mutable) {
        return this.mutableToReadOnly.containsKey(mutable);
    }

    public boolean isReadOnlyCollection(@NotNull ClassDescriptor readOnly) {
        return this.readOnlyToMutable.containsKey(readOnly);
    }

    @NotNull
    public ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        ClassDescriptor readOnly = this.mutableToReadOnly.get(mutable);
        if (readOnly == null) {
            throw new IllegalArgumentException("Given class " + mutable + " is not a mutable collection");
        }
        return readOnly;
    }

    @NotNull
    public ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        ClassDescriptor mutable = this.readOnlyToMutable.get(readOnly);
        if (mutable == null) {
            throw new IllegalArgumentException("Given class " + readOnly + " is not a read-only collection");
        }
        return mutable;
    }

    @NotNull
    public List<ClassDescriptor> allKotlinClasses() {
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>();
        result.addAll(this.javaToKotlin.values());
        result.addAll(this.readOnlyToMutable.values());
        for (PrimitiveType type2 : PrimitiveType.values()) {
            result.add(builtIns.getPrimitiveArrayClassDescriptor(type2));
        }
        result.add(builtIns.getUnit());
        result.add(builtIns.getNothing());
        return result;
    }
}

