/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.types.JetType;

public class EnumValue
extends CompileTimeConstant<ClassDescriptor> {
    public EnumValue(@NotNull ClassDescriptor value, boolean usesVariableAsConstant) {
        super(value, true, false, usesVariableAsConstant);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        return this.getType();
    }

    @NotNull
    private JetType getType() {
        JetType type2 = DescriptorUtilPackage.getClassObjectType((ClassDescriptor)this.value);
        assert (type2 != null) : "Enum entry must have a class object type: " + this.value;
        return type2;
    }

    @Override
    @NotNull
    public ClassDescriptor getValue() {
        ClassDescriptor value = (ClassDescriptor)super.getValue();
        assert (value != null) : "Guaranteed by constructor";
        return value;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitEnumValue(this, data2);
    }

    public String toString() {
        return this.getType() + "." + ((ClassDescriptor)this.value).getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ((ClassDescriptor)this.value).equals(((EnumValue)o).value);
    }

    public int hashCode() {
        return ((ClassDescriptor)this.value).hashCode();
    }
}

