/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeUtils;

public class IntegerValueTypeConstant
extends IntegerValueConstant<Number> {
    private final IntegerValueTypeConstructor typeConstructor;

    public IntegerValueTypeConstant(@NotNull Number value, boolean canBeUsedInAnnotations, boolean usesVariableAsConstant) {
        super(value, canBeUsedInAnnotations, true, usesVariableAsConstant);
        this.typeConstructor = new IntegerValueTypeConstructor(value.longValue());
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        return new JetTypeImpl(Annotations.EMPTY, this.typeConstructor, false, Collections.emptyList(), ErrorUtils.createErrorScope("Scope for number value type (" + this.typeConstructor.toString() + ")", true));
    }

    @Override
    @Deprecated
    @Nullable
    public Number getValue() {
        throw new UnsupportedOperationException("Use IntegerValueTypeConstant.getValue(expectedType) instead");
    }

    @NotNull
    public JetType getType(@NotNull JetType expectedType) {
        return TypeUtils.getPrimitiveNumberType(this.typeConstructor, expectedType);
    }

    @NotNull
    public Number getValue(@NotNull JetType expectedType) {
        Long numberValue = this.typeConstructor.getValue();
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        JetType valueType = this.getType(expectedType);
        if (((Object)valueType).equals(builtIns.getIntType())) {
            return ((Number)numberValue).intValue();
        }
        if (((Object)valueType).equals(builtIns.getByteType())) {
            return ((Number)numberValue).byteValue();
        }
        if (((Object)valueType).equals(builtIns.getShortType())) {
            return ((Number)numberValue).shortValue();
        }
        return (long)numberValue;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitNumberTypeValue(this, data2);
    }

    public String toString() {
        return this.typeConstructor.toString();
    }
}

