/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization.descriptors;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.impl.AbstractLazyTypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationContext;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationPackage;
import org.jetbrains.kotlin.serialization.deserialization.TypeDeserializer;
import org.jetbrains.kotlin.types.JetType;

public class DeserializedTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor {
    private final ProtoBuf.TypeParameter proto;
    private final TypeDeserializer typeDeserializer;

    public DeserializedTypeParameterDescriptor(@NotNull DeserializationContext c, @NotNull ProtoBuf.TypeParameter proto, int index) {
        super(c.getStorageManager(), c.getContainingDeclaration(), c.getNameResolver().getName(proto.getName()), DeserializationPackage.variance(proto.getVariance()), proto.getReified(), index, SourceElement.NO_SOURCE);
        this.proto = proto;
        this.typeDeserializer = c.getTypeDeserializer();
    }

    @Override
    @NotNull
    protected Set<JetType> resolveUpperBounds() {
        if (this.proto.getUpperBoundCount() == 0) {
            return Collections.singleton(DescriptorUtilPackage.getBuiltIns(this).getDefaultBound());
        }
        LinkedHashSet<JetType> result = new LinkedHashSet<JetType>(this.proto.getUpperBoundCount());
        for (ProtoBuf.Type upperBound : this.proto.getUpperBoundList()) {
            result.add(this.typeDeserializer.type(upperBound));
        }
        return result;
    }
}

