/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleParameters;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorImpl;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.ErrorSimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.utils.Printer;

public class ErrorUtils {
    private static final ModuleDescriptor ERROR_MODULE = new ModuleDescriptorImpl(Name.special("<ERROR MODULE>"), LockBasedStorageManager.NO_LOCKS, ModuleParameters.Empty.INSTANCE$);
    private static final ErrorClassDescriptor ERROR_CLASS = new ErrorClassDescriptor(null);
    private static final JetType ERROR_PROPERTY_TYPE = ErrorUtils.createErrorType("<ERROR PROPERTY TYPE>");
    private static final VariableDescriptor ERROR_PROPERTY = ErrorUtils.createErrorProperty();
    private static final Set<VariableDescriptor> ERROR_PROPERTY_GROUP = Collections.singleton(ERROR_PROPERTY);

    public static boolean containsErrorType(@NotNull FunctionDescriptor function) {
        if (ErrorUtils.containsErrorType(function.getReturnType())) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameter = function.getExtensionReceiverParameter();
        if (receiverParameter != null && ErrorUtils.containsErrorType(receiverParameter.getType())) {
            return true;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function.getValueParameters()) {
            if (!ErrorUtils.containsErrorType(valueParameterDescriptor.getType())) continue;
            return true;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : function.getTypeParameters()) {
            for (JetType upperBound : typeParameterDescriptor.getUpperBounds()) {
                if (!ErrorUtils.containsErrorType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static ClassDescriptor createErrorClass(@NotNull String debugMessage) {
        return new ErrorClassDescriptor(debugMessage);
    }

    @NotNull
    public static JetScope createErrorScope(@NotNull String debugMessage) {
        return ErrorUtils.createErrorScope(debugMessage, false);
    }

    @NotNull
    public static JetScope createErrorScope(@NotNull String debugMessage, boolean throwExceptions) {
        if (throwExceptions) {
            return new ThrowingScope(debugMessage);
        }
        return new ErrorScope(debugMessage);
    }

    @NotNull
    private static PropertyDescriptorImpl createErrorProperty() {
        PropertyDescriptorImpl descriptor2 = PropertyDescriptorImpl.create(ERROR_CLASS, Annotations.EMPTY, Modality.OPEN, Visibilities.INTERNAL, true, Name.special("<ERROR PROPERTY>"), CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE);
        descriptor2.setType(ERROR_PROPERTY_TYPE, Collections.emptyList(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, (JetType)null);
        return descriptor2;
    }

    @NotNull
    private static SimpleFunctionDescriptor createErrorFunction(@NotNull ErrorScope ownerScope) {
        ErrorSimpleFunctionDescriptorImpl function = new ErrorSimpleFunctionDescriptorImpl(ERROR_CLASS, ownerScope);
        function.initialize((JetType)null, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Collections.emptyList(), Collections.emptyList(), ErrorUtils.createErrorType("<ERROR FUNCTION RETURN TYPE>"), Modality.OPEN, Visibilities.INTERNAL);
        return function;
    }

    @NotNull
    public static JetType createErrorType(@NotNull String debugMessage) {
        return ErrorUtils.createErrorTypeWithArguments(debugMessage, Collections.<TypeProjection>emptyList());
    }

    @NotNull
    public static JetType createErrorTypeWithCustomDebugName(@NotNull String debugName) {
        return new ErrorTypeImpl(ErrorUtils.createErrorTypeConstructorWithCustomDebugName(debugName), ErrorUtils.createErrorScope(debugName));
    }

    @NotNull
    public static JetType createErrorTypeWithArguments(@NotNull String debugMessage, @NotNull List<TypeProjection> arguments2) {
        return new ErrorTypeImpl(ErrorUtils.createErrorTypeConstructor(debugMessage), ErrorUtils.createErrorScope(debugMessage), arguments2);
    }

    @NotNull
    public static TypeConstructor createErrorTypeConstructor(@NotNull String debugMessage) {
        return ErrorUtils.createErrorTypeConstructorWithCustomDebugName("[ERROR : " + debugMessage + "]");
    }

    @NotNull
    private static TypeConstructor createErrorTypeConstructorWithCustomDebugName(@NotNull String debugName) {
        return TypeConstructorImpl.createForClass(ERROR_CLASS, Annotations.EMPTY, false, debugName, Collections.emptyList(), Collections.singleton(KotlinBuiltIns.getInstance().getAnyType()));
    }

    public static boolean containsErrorType(@Nullable JetType type2) {
        if (type2 == null) {
            return false;
        }
        if (type2.isError()) {
            return true;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !ErrorUtils.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isError(@NotNull DeclarationDescriptor candidate) {
        return ErrorUtils.isErrorClass(candidate) || ErrorUtils.isErrorClass(candidate.getContainingDeclaration()) || candidate == ERROR_MODULE;
    }

    private static boolean isErrorClass(@Nullable DeclarationDescriptor candidate) {
        return candidate instanceof ErrorClassDescriptor;
    }

    @NotNull
    public static TypeParameterDescriptor createErrorTypeParameter(int index, @NotNull String debugMessage) {
        return TypeParameterDescriptorImpl.createWithDefaultBound(ERROR_CLASS, Annotations.EMPTY, false, Variance.INVARIANT, Name.special("<ERROR: " + debugMessage + ">"), index);
    }

    @NotNull
    public static ModuleDescriptor getErrorModule() {
        return ERROR_MODULE;
    }

    public static boolean isUninferredParameter(@Nullable JetType type2) {
        return type2 != null && type2.getConstructor() instanceof UninferredParameterTypeConstructor;
    }

    public static boolean containsUninferredParameter(@Nullable JetType type2) {
        return TypeUtils.containsSpecialType(type2, new Function1<JetType, Boolean>(){

            public Boolean invoke(JetType argumentType) {
                return ErrorUtils.isUninferredParameter(argumentType);
            }
        });
    }

    @NotNull
    public static JetType createUninferredParameterType(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        return new ErrorTypeImpl((TypeConstructor)new UninferredParameterTypeConstructor(typeParameterDescriptor), ErrorUtils.createErrorScope("Scope for error type for not inferred parameter: " + typeParameterDescriptor.getName()));
    }

    public static boolean isFunctionPlaceholder(@Nullable JetType type2) {
        return type2 != null && type2.getConstructor() instanceof FunctionPlaceholderTypeConstructor;
    }

    @NotNull
    public static JetType createFunctionPlaceholderType(@NotNull List<JetType> argumentTypes, boolean hasDeclaredArguments) {
        return new ErrorTypeImpl((TypeConstructor)new FunctionPlaceholderTypeConstructor(argumentTypes, hasDeclaredArguments), ErrorUtils.createErrorScope("Scope for function placeholder type"));
    }

    private ErrorUtils() {
    }

    public static class FunctionPlaceholderTypeConstructor
    implements TypeConstructor {
        private final TypeConstructor errorTypeConstructor;
        private final List<JetType> argumentTypes;
        private final boolean hasDeclaredArguments;

        private FunctionPlaceholderTypeConstructor(@NotNull List<JetType> argumentTypes, boolean hasDeclaredArguments) {
            this.errorTypeConstructor = ErrorUtils.createErrorTypeConstructorWithCustomDebugName("PLACEHOLDER_FUNCTION_TYPE" + argumentTypes);
            this.argumentTypes = argumentTypes;
            this.hasDeclaredArguments = hasDeclaredArguments;
        }

        @NotNull
        public List<JetType> getArgumentTypes() {
            return this.argumentTypes;
        }

        public boolean hasDeclaredArguments() {
            return this.hasDeclaredArguments;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            return this.errorTypeConstructor.getParameters();
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            return this.errorTypeConstructor.getSupertypes();
        }

        @Override
        public boolean isFinal() {
            return this.errorTypeConstructor.isFinal();
        }

        @Override
        public boolean isDenotable() {
            return this.errorTypeConstructor.isDenotable();
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return this.errorTypeConstructor.getDeclarationDescriptor();
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            return this.errorTypeConstructor.getAnnotations();
        }

        public String toString() {
            return this.errorTypeConstructor.toString();
        }
    }

    public static class UninferredParameterTypeConstructor
    implements TypeConstructor {
        private final TypeParameterDescriptor typeParameterDescriptor;
        private final TypeConstructor errorTypeConstructor;

        private UninferredParameterTypeConstructor(@NotNull TypeParameterDescriptor descriptor2) {
            this.typeParameterDescriptor = descriptor2;
            this.errorTypeConstructor = ErrorUtils.createErrorTypeConstructorWithCustomDebugName("CANT_INFER_TYPE_PARAMETER: " + descriptor2.getName());
        }

        @NotNull
        public TypeParameterDescriptor getTypeParameterDescriptor() {
            return this.typeParameterDescriptor;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            return this.errorTypeConstructor.getParameters();
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            return this.errorTypeConstructor.getSupertypes();
        }

        @Override
        public boolean isFinal() {
            return this.errorTypeConstructor.isFinal();
        }

        @Override
        public boolean isDenotable() {
            return this.errorTypeConstructor.isDenotable();
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return this.errorTypeConstructor.getDeclarationDescriptor();
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            return this.errorTypeConstructor.getAnnotations();
        }
    }

    private static class ErrorTypeImpl
    implements JetType {
        private final TypeConstructor constructor;
        private final JetScope memberScope;
        private final List<TypeProjection> arguments;

        private ErrorTypeImpl(@NotNull TypeConstructor constructor2, @NotNull JetScope memberScope2, @NotNull List<TypeProjection> arguments2) {
            this.constructor = constructor2;
            this.memberScope = memberScope2;
            this.arguments = arguments2;
        }

        private ErrorTypeImpl(@NotNull TypeConstructor constructor2, @NotNull JetScope memberScope2) {
            this(constructor2, memberScope2, Collections.emptyList());
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            return this.arguments;
        }

        @Override
        public boolean isMarkedNullable() {
            return false;
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            return this.memberScope;
        }

        @Override
        public boolean isError() {
            return true;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            return Annotations.EMPTY;
        }

        @Override
        @Nullable
        public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
            return null;
        }

        public String toString() {
            return this.constructor.toString() + (this.arguments.isEmpty() ? "" : KotlinPackage.joinToString(this.arguments, (String)", ", (String)"<", (String)">", (int)-1, (String)"...", null));
        }
    }

    private static class ErrorClassDescriptor
    extends ClassDescriptorImpl {
        public ErrorClassDescriptor(@Nullable String name) {
            super(ErrorUtils.getErrorModule(), Name.special(name == null ? "<ERROR CLASS>" : "<ERROR CLASS: " + name + ">"), Modality.OPEN, Collections.<JetType>emptyList(), SourceElement.NO_SOURCE);
            ConstructorDescriptorImpl errorConstructor = ConstructorDescriptorImpl.create(this, Annotations.EMPTY, true, SourceElement.NO_SOURCE);
            errorConstructor.initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), Visibilities.INTERNAL);
            JetScope memberScope2 = ErrorUtils.createErrorScope(this.getName().asString());
            errorConstructor.setReturnType(new ErrorTypeImpl((TypeConstructor)TypeConstructorImpl.createForClass(this, Annotations.EMPTY, false, this.getName().asString(), Collections.emptyList(), Collections.singleton(KotlinBuiltIns.getInstance().getAnyType())), memberScope2));
            this.initialize(memberScope2, Collections.singleton(errorConstructor), errorConstructor);
        }

        @Override
        @NotNull
        public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
            return this;
        }

        @Override
        public String toString() {
            return this.getName().asString();
        }

        @Override
        @NotNull
        public JetScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
            return ErrorUtils.createErrorScope("Error scope for class " + this.getName() + " with arguments: " + typeArguments);
        }
    }

    private static class ThrowingScope
    implements JetScope {
        private final String debugMessage;

        private ThrowingScope(@NotNull String message) {
            this.debugMessage = message;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getClassifier(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public PackageViewDescriptor getPackage(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public VariableDescriptor getLocalVariable(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            return ERROR_MODULE;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull Name labelName) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
            throw new IllegalStateException();
        }

        public String toString() {
            return "ThrowingScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }

    public static class ErrorScope
    implements JetScope {
        private final String debugMessage;

        private ErrorScope(@NotNull String debugMessage) {
            this.debugMessage = debugMessage;
        }

        @Override
        public ClassifierDescriptor getClassifier(@NotNull Name name) {
            return ErrorUtils.createErrorClass(name.asString());
        }

        @NotNull
        public Set<VariableDescriptor> getProperties(@NotNull Name name) {
            return ERROR_PROPERTY_GROUP;
        }

        @Override
        public VariableDescriptor getLocalVariable(@NotNull Name name) {
            return ERROR_PROPERTY;
        }

        @Override
        public PackageViewDescriptor getPackage(@NotNull Name name) {
            return null;
        }

        @Override
        @NotNull
        public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
            return Collections.emptyList();
        }

        @NotNull
        public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
            return Collections.singleton(ErrorUtils.createErrorFunction(this));
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            return ERROR_MODULE;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull Name labelName) {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
            return Collections.emptyList();
        }

        public String toString() {
            return "ErrorScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }
}

