/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public abstract class AbstractJetType
implements JetType {
    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        if (capabilityClass.isInstance(this)) {
            return (T)((TypeCapability)((Object)this));
        }
        return null;
    }

    public final int hashCode() {
        int result = this.getConstructor().hashCode();
        result = 31 * result + ((Object)this.getArguments()).hashCode();
        result = 31 * result + (this.isMarkedNullable() ? 1 : 0);
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JetType)) {
            return false;
        }
        JetType type2 = (JetType)obj;
        return this.isMarkedNullable() == type2.isMarkedNullable() && JetTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(this, type2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AnnotationDescriptor annotation : this.getAnnotations()) {
            sb.append("[");
            sb.append(DescriptorRenderer.DEBUG_TEXT.renderAnnotation(annotation));
            sb.append("] ");
        }
        sb.append(this.getConstructor());
        List<TypeProjection> arguments2 = this.getArguments();
        if (!arguments2.isEmpty()) {
            sb.append("<");
            Iterator<TypeProjection> i = arguments2.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(">");
        }
        if (this.isMarkedNullable()) {
            sb.append("?");
        }
        return sb.toString();
    }
}

