/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Mutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

public class DescriptorSubstitutor {
    private DescriptorSubstitutor() {
    }

    @NotNull
    public static TypeSubstitutor substituteTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters, final @NotNull TypeSubstitutor originalSubstitutor, @NotNull DeclarationDescriptor newContainingDeclaration, @NotNull @Mutable List<TypeParameterDescriptor> result) {
        TypeParameterDescriptorImpl substituted;
        final HashMap<TypeConstructor, TypeProjectionImpl> mutableSubstitution = new HashMap<TypeConstructor, TypeProjectionImpl>();
        TypeSubstitutor substitutor = TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                if (originalSubstitutor.inRange(key)) {
                    return originalSubstitutor.getSubstitution().get(key);
                }
                return (TypeProjection)mutableSubstitution.get(key);
            }

            @Override
            public boolean isEmpty() {
                return originalSubstitutor.isEmpty() && mutableSubstitution.isEmpty();
            }

            @Override
            public boolean approximateCapturedTypes() {
                return originalSubstitutor.getSubstitution().approximateCapturedTypes();
            }

            public String toString() {
                return "DescriptorSubstitutor.substituteTypeParameters(" + mutableSubstitution + " / " + originalSubstitutor.getSubstitution() + ")";
            }
        });
        HashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl> substitutedMap = new HashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl>();
        for (TypeParameterDescriptor descriptor2 : typeParameters) {
            substituted = TypeParameterDescriptorImpl.createForFurtherModification(newContainingDeclaration, descriptor2.getAnnotations(), descriptor2.isReified(), descriptor2.getVariance(), descriptor2.getName(), descriptor2.getIndex(), SourceElement.NO_SOURCE);
            substituted.setInitialized();
            mutableSubstitution.put(descriptor2.getTypeConstructor(), new TypeProjectionImpl(substituted.getDefaultType()));
            substitutedMap.put(descriptor2, substituted);
            result.add(substituted);
        }
        for (TypeParameterDescriptor descriptor2 : typeParameters) {
            substituted = (TypeParameterDescriptorImpl)substitutedMap.get(descriptor2);
            for (JetType upperBound : descriptor2.getUpperBounds()) {
                substituted.getUpperBounds().add(substitutor.substitute(upperBound, Variance.INVARIANT));
            }
        }
        return substitutor;
    }
}

