/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kotlin.reflect.jvm.internal.impl.renderer

import kotlin.reflect.jvm.internal.impl.descriptors.*

public fun qualifiedNameForSourceCode(descriptor: ClassifierDescriptor): String {
    val nameString = DescriptorRenderer.COMPACT.renderName(descriptor.getName())
    val qualifier = qualifierName(descriptor.getContainingDeclaration())
    return if (qualifier != null && qualifier != "") qualifier + "." + nameString else nameString
}

private fun qualifierName(descriptor: DeclarationDescriptor): String? = when (descriptor) {
    is ClassDescriptor -> qualifiedNameForSourceCode(descriptor)
    is PackageFragmentDescriptor -> DescriptorRenderer.COMPACT.renderFqName(descriptor.fqName)
    else -> null
}

