/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

public final class Variance
extends Enum<Variance> {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final /* enum */ Variance INVARIANT;
    public static final /* enum */ Variance IN_VARIANCE;
    public static final /* enum */ Variance OUT_VARIANCE;
    private static final /* synthetic */ Variance[] $VALUES;
    @NotNull
    private final String label;
    private final boolean allowsInPosition;
    private final boolean allowsOutPosition;
    private final int superpositionFactor;

    static {
        $kotlinClass = Reflection.createKotlinClass(Variance.class);
        Variance[] varianceArray = new Variance[3];
        Variance[] varianceArray2 = varianceArray;
        varianceArray[0] = INVARIANT = new Variance("", true, true, 0);
        varianceArray[1] = IN_VARIANCE = new Variance("in", true, false, -1);
        varianceArray[2] = OUT_VARIANCE = new Variance("out", false, true, 1);
        $VALUES = varianceArray;
    }

    public final boolean allowsPosition(@JetValueParameter(name="position") @NotNull Variance position) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)position), (String)"position");
        Variance variance = position;
        if (Intrinsics.areEqual((Object)((Object)variance), (Object)((Object)IN_VARIANCE))) {
            bl = this.allowsInPosition;
        } else if (Intrinsics.areEqual((Object)((Object)variance), (Object)((Object)OUT_VARIANCE))) {
            bl = this.allowsOutPosition;
        } else if (Intrinsics.areEqual((Object)((Object)variance), (Object)((Object)INVARIANT))) {
            bl = this.allowsInPosition && this.allowsOutPosition;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final Variance superpose(@JetValueParameter(name="other") @NotNull Variance other) {
        Variance variance;
        Intrinsics.checkParameterIsNotNull((Object)((Object)other), (String)"other");
        int r = this.superpositionFactor * other.superpositionFactor;
        switch (r) {
            case 0: {
                variance = INVARIANT;
                break;
            }
            case -1: {
                variance = IN_VARIANCE;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Illegal factor: " + r);
            }
        }
        return variance;
    }

    @NotNull
    public final Variance opposite() {
        Variance variance;
        Variance variance2 = this;
        if (Intrinsics.areEqual((Object)((Object)variance2), (Object)((Object)INVARIANT))) {
            variance = INVARIANT;
        } else if (Intrinsics.areEqual((Object)((Object)variance2), (Object)((Object)IN_VARIANCE))) {
            variance = OUT_VARIANCE;
        } else if (Intrinsics.areEqual((Object)((Object)variance2), (Object)((Object)OUT_VARIANCE))) {
            variance = IN_VARIANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return variance;
    }

    @NotNull
    public String toString() {
        return this.label;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final boolean getAllowsInPosition() {
        return this.allowsInPosition;
    }

    public final boolean getAllowsOutPosition() {
        return this.allowsOutPosition;
    }

    protected Variance(@JetValueParameter(name="allowsOutPosition") String label, @JetValueParameter(name="superpositionFactor") boolean allowsInPosition, boolean allowsOutPosition, int superpositionFactor) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        this.label = label;
        this.allowsInPosition = allowsInPosition;
        this.allowsOutPosition = allowsOutPosition;
        this.superpositionFactor = superpositionFactor;
    }

    public static Variance[] values() {
        return (Variance[])$VALUES.clone();
    }

    public static Variance valueOf(String string) {
        return Enum.valueOf(Variance.class, string);
    }
}

