/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.structure.reflect;

import java.lang.reflect.Array;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectPackage;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;

final class ReflectPackage__ReflectClassUtilKt {
    @NotNull
    public static final ClassLoader getSafeClassLoader(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        ClassLoader classLoader = $receiver.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"classLoader ?: ClassLoader.getSystemClassLoader()");
        return classLoader;
    }

    public static final boolean isEnumClassOrSpecializedEnumEntryClass(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Enum.class.isAssignableFrom($receiver);
    }

    @NotNull
    public static final ClassId getClassId(Class<?> $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if ($receiver.isPrimitive()) {
            throw (Throwable)new IllegalArgumentException("Can't compute ClassId for primitive type: " + $receiver);
        }
        if ($receiver.isArray()) {
            throw (Throwable)new IllegalArgumentException("Can't compute ClassId for array type: " + $receiver);
        }
        if ($receiver.getEnclosingMethod() != null || $receiver.getEnclosingConstructor() != null || KotlinPackage.isEmpty((String)$receiver.getSimpleName())) {
            FqName fqName2 = new FqName($receiver.getName());
            object = new ClassId(fqName2.parent(), FqName.topLevel(fqName2.shortName()), true);
        } else {
            Class<?> clazz = $receiver.getDeclaringClass();
            if (clazz == null || (clazz = ReflectPackage.getClassId(clazz)) == null || (clazz = ((ClassId)((Object)clazz)).createNestedClassId(Name.identifier($receiver.getSimpleName()))) == null) {
                clazz = ClassId.topLevel(new FqName($receiver.getName()));
            }
            object = clazz;
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"getDeclaringClass()?.cla\u2026pLevel(FqName(getName()))");
        }
        return object;
    }

    @NotNull
    public static final String getDesc(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (Intrinsics.areEqual($receiver, Void.TYPE)) {
            return "V";
        }
        return KotlinPackage.replace$default((String)KotlinPackage.substring((String)ReflectPackage.createArrayType($receiver).getName(), (int)1), (char)'.', (char)'/', (boolean)false, (int)4);
    }

    @NotNull
    public static final Class<?> createArrayType(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Array.newInstance($receiver, 0).getClass();
    }
}

