/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.KotlinRetention;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilPackage;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilPackage__DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DescriptorUtilPackage__DescriptorUtilsKt {
    @NotNull
    public static final ClassDescriptor getClassObjectReferenceTarget(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassDescriptor classDescriptor = $receiver.getCompanionObjectDescriptor();
        if (classDescriptor == null) {
            classDescriptor = $receiver;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"getCompanionObjectDescriptor() ?: this");
        return classDescriptor;
    }

    @NotNull
    public static final DeclarationDescriptor getImportableDescriptor(DeclarationDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof ConstructorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            declarationDescriptor = declarationDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"getContainingDeclaration()");
        } else if ($receiver instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            declarationDescriptor = declarationDescriptor3;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor3, (String)"getCorrespondingProperty()");
        } else {
            declarationDescriptor = $receiver;
        }
        return declarationDescriptor;
    }

    @NotNull
    public static final FqNameUnsafe getFqNameUnsafe(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"DescriptorUtils.getFqName(this)");
        return fqNameUnsafe;
    }

    @NotNull
    public static final FqName getFqNameSafe(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FqName fqName2 = DescriptorUtils.getFqNameSafe($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"DescriptorUtils.getFqNameSafe(this)");
        return fqName2;
    }

    public static final boolean getIsExtension(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof CallableDescriptor && ((CallableDescriptor)$receiver).getExtensionReceiverParameter() != null;
    }

    @NotNull
    public static final ModuleDescriptor getModule(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"DescriptorUtils.getContainingModule(this)");
        return moduleDescriptor;
    }

    @Nullable
    public static final ClassDescriptor resolveTopLevelClass(ModuleDescriptor $receiver, @NotNull FqName topLevelClassFqName, @NotNull LookupLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)topLevelClassFqName, (String)"topLevelClassFqName");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        KotlinPackage.assert((!topLevelClassFqName.isRoot() ? 1 : 0) != 0);
        FqName fqName2 = topLevelClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"topLevelClassFqName.parent()");
        JetScope jetScope = $receiver.getPackage(fqName2).getMemberScope();
        Name name = topLevelClassFqName.shortName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"topLevelClassFqName.shortName()");
        ClassifierDescriptor classifierDescriptor = jetScope.getClassifier(name, location);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    @NotNull
    public static final ClassId getClassId(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor owner = $receiver.getContainingDeclaration();
        if (owner instanceof PackageFragmentDescriptor) {
            return new ClassId(((PackageFragmentDescriptor)owner).getFqName(), $receiver.getName());
        }
        if (owner instanceof ClassDescriptor) {
            ClassId classId = DescriptorUtilPackage.getClassId((ClassDescriptor)owner).createNestedClassId($receiver.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"owner.classId.createNestedClassId(getName())");
            return classId;
        }
        throw (Throwable)new IllegalStateException("Illegal container: " + owner);
    }

    public static final boolean getHasClassObjectType(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtilPackage.getClassObjectType($receiver) != null;
    }

    @Nullable
    public static final JetType getClassObjectType(ClassDescriptor $receiver) {
        ClassDescriptor correspondingDescriptor;
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassKind classKind = $receiver.getKind();
        if (Intrinsics.areEqual((Object)((Object)classKind), (Object)((Object)ClassKind.OBJECT))) {
            classDescriptor = $receiver;
        } else if (Intrinsics.areEqual((Object)((Object)classKind), (Object)((Object)ClassKind.ENUM_ENTRY))) {
            DeclarationDescriptor container = $receiver.getContainingDeclaration();
            KotlinPackage.assert((container instanceof ClassDescriptor && Intrinsics.areEqual((Object)((Object)((ClassDescriptor)container).getKind()), (Object)((Object)ClassKind.ENUM_CLASS)) ? 1 : 0) != 0);
            DeclarationDescriptor declarationDescriptor = container;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            classDescriptor = (ClassDescriptor)declarationDescriptor;
        } else {
            classDescriptor = $receiver.getCompanionObjectDescriptor();
        }
        ClassDescriptor classDescriptor2 = correspondingDescriptor = classDescriptor;
        return classDescriptor2 != null ? classDescriptor2.getDefaultType() : null;
    }

    public static final boolean getIsEffectivelyPublicApi(DeclarationDescriptorWithVisibility $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptorWithVisibility parent = $receiver;
        while (parent != null) {
            if (!parent.getVisibility().getIsPublicAPI()) {
                return false;
            }
            parent = DescriptorUtils.getParentOfType(parent, DeclarationDescriptorWithVisibility.class);
        }
        return true;
    }

    @Nullable
    public static final ClassDescriptor getSuperClassNotAny(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        for (JetType supertype : $receiver.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor superClassifier = supertype.getConstructor().getDeclarationDescriptor();
            if (KotlinBuiltIns.isAnyOrNullableAny(supertype) || !DescriptorUtils.isClass(superClassifier) && !DescriptorUtils.isEnumClass(superClassifier)) continue;
            ClassifierDescriptor classifierDescriptor = superClassifier;
            if (classifierDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    @NotNull
    public static final ClassDescriptor getSuperClassOrAny(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilPackage.getSuperClassNotAny($receiver);
        if (classDescriptor == null) {
            ClassDescriptor classDescriptor2 = DescriptorUtilPackage.getBuiltIns($receiver).getAny();
            classDescriptor = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"builtIns.getAny()");
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConstructorDescriptor> getSecondaryConstructors(ClassDescriptor $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Iterable $receiver3 = $receiver.getConstructors();
        Iterable iterable = $receiver3;
        Collection destination = new ArrayList();
        for (Object element : $receiver2) {
            ConstructorDescriptor it = (ConstructorDescriptor)element;
            if (it.isPrimary()) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final KotlinBuiltIns getBuiltIns(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtilPackage.getModule($receiver).getBuiltIns();
    }

    @Nullable
    public static final DeclarationDescriptor getOwnerForEffectiveDispatchReceiverParameter(CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)$receiver).getKind()), (Object)((Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE))) {
            return ((CallableMemberDescriptor)$receiver).getContainingDeclaration();
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getDispatchReceiverParameter();
        return receiverParameterDescriptor != null ? receiverParameterDescriptor.getContainingDeclaration() : null;
    }

    public static final boolean hasDefaultValue(ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DFS.AbstractNodeHandler<ValueParameterDescriptor, Boolean> handler2 = new DFS.AbstractNodeHandler<ValueParameterDescriptor, Boolean>(){
            public static final /* synthetic */ KClass $kotlinClass;
            private boolean result;

            static {
                $kotlinClass = Reflection.createKotlinClass(hasDefaultValue.handler.1.class);
            }

            public final boolean getResult() {
                return this.result;
            }

            public final void setResult(boolean bl) {
                this.result = bl;
            }

            public boolean beforeChildren(@NotNull ValueParameterDescriptor current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                this.result = this.result || current.declaresDefaultValue();
                return !this.result;
            }

            @NotNull
            public Boolean result() {
                return this.result;
            }
        };
        DFS.dfs(KotlinPackage.listOf((Object)$receiver), hasDefaultValue.1.INSTANCE$, handler2);
        return handler2.result();
    }

    public static final boolean isRepeatableAnnotation(Annotated $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.repeatable;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.repeatable");
        return annotations2.findAnnotation(fqName2) != null;
    }

    public static final boolean isDocumentedAnnotation(Annotated $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.mustBeDocumented;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.mustBeDocumented");
        return annotations2.findAnnotation(fqName2) != null;
    }

    @Nullable
    public static final KotlinRetention getAnnotationRetention(Annotated $receiver) {
        Object v3;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Annotations annotations2 = $receiver.getAnnotations();
            FqName fqName2 = KotlinBuiltIns.FQ_NAMES.retention;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.retention");
            AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor annotationEntryDescriptor = annotationDescriptor;
            Iterable $receiver2 = annotationEntryDescriptor.getAllValueArguments().entrySet();
            for (Object element : $receiver2) {
                Map.Entry it = (Map.Entry)element;
                if (!Intrinsics.areEqual((Object)((ValueParameterDescriptor)KotlinPackage.getKey((Map.Entry)it)).getName().asString(), (Object)"value")) continue;
                v3 = element;
                break block4;
            }
            v3 = null;
        }
        Map.Entry entry = v3;
        ConstantValue constantValue = entry != null ? (ConstantValue)entry.getValue() : null;
        if (!(constantValue instanceof EnumValue)) {
            constantValue = null;
        }
        EnumValue enumValue = (EnumValue)constantValue;
        if (enumValue == null) {
            return null;
        }
        EnumValue retentionArgumentValue = enumValue;
        String string = ((ClassDescriptor)retentionArgumentValue.getValue()).getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"retentionArgumentValue.value.name.asString()");
        return KotlinRetention.valueOf(string);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParentsWithSelf(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinPackage.sequence((Object)$receiver, (Function1)parentsWithSelf.1.INSTANCE$);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParents(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinPackage.drop(DescriptorUtilPackage.getParentsWithSelf($receiver), (int)1);
    }
}

