/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization;

import kotlin.reflect.jvm.internal.impl.com.google.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import org.jetbrains.annotations.NotNull;

public class Flags {
    public static final FlagField<Boolean> HAS_ANNOTATIONS = FlagField.booleanFirst();
    public static final FlagField<ProtoBuf.Visibility> VISIBILITY = FlagField.after(HAS_ANNOTATIONS, (Internal.EnumLite[])ProtoBuf.Visibility.values());
    public static final FlagField<ProtoBuf.Modality> MODALITY = FlagField.after(VISIBILITY, (Internal.EnumLite[])ProtoBuf.Modality.values());
    public static final FlagField<ProtoBuf.Class.Kind> CLASS_KIND = FlagField.after(MODALITY, (Internal.EnumLite[])ProtoBuf.Class.Kind.values());
    public static final FlagField<Boolean> INNER = FlagField.booleanAfter(CLASS_KIND);
    public static final FlagField<ProtoBuf.Callable.CallableKind> CALLABLE_KIND = FlagField.after(MODALITY, (Internal.EnumLite[])ProtoBuf.Callable.CallableKind.values());
    public static final FlagField<ProtoBuf.Callable.MemberKind> MEMBER_KIND = FlagField.after(CALLABLE_KIND, (Internal.EnumLite[])ProtoBuf.Callable.MemberKind.values());
    public static final FlagField<Boolean> HAS_GETTER = FlagField.booleanAfter(MEMBER_KIND);
    public static final FlagField<Boolean> HAS_SETTER = FlagField.booleanAfter(HAS_GETTER);
    public static final FlagField<Boolean> HAS_CONSTANT = FlagField.booleanAfter(HAS_SETTER);
    public static final FlagField<Boolean> LATE_INIT = FlagField.booleanAfter(HAS_CONSTANT);
    public static final FlagField<Boolean> DECLARES_DEFAULT_VALUE = FlagField.booleanAfter(HAS_ANNOTATIONS);
    public static final FlagField<Boolean> IS_NOT_DEFAULT = FlagField.booleanAfter(MODALITY);

    private Flags() {
    }

    private static <E> int bitWidth(@NotNull E[] enumEntries) {
        if (enumEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntries", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "bitWidth"));
        }
        int length = enumEntries.length - 1;
        if (length == 0) {
            return 1;
        }
        for (int i = 31; i >= 0; --i) {
            if ((length & 1 << i) == 0) continue;
            return i + 1;
        }
        throw new IllegalStateException("Empty enum: " + enumEntries.getClass());
    }

    public static int getClassFlags(boolean hasAnnotations, Visibility visibility, Modality modality, ClassKind kind, boolean inner, boolean isCompanionObject) {
        return HAS_ANNOTATIONS.toFlags(hasAnnotations) | MODALITY.toFlags(Flags.modality(modality)) | VISIBILITY.toFlags(Flags.visibility(visibility)) | CLASS_KIND.toFlags(Flags.classKind(kind, isCompanionObject)) | INNER.toFlags(inner);
    }

    private static ProtoBuf.Class.Kind classKind(ClassKind kind, boolean isCompanionObject) {
        if (isCompanionObject) {
            return ProtoBuf.Class.Kind.CLASS_OBJECT;
        }
        switch (kind) {
            case CLASS: {
                return ProtoBuf.Class.Kind.CLASS;
            }
            case INTERFACE: {
                return ProtoBuf.Class.Kind.TRAIT;
            }
            case ENUM_CLASS: {
                return ProtoBuf.Class.Kind.ENUM_CLASS;
            }
            case ENUM_ENTRY: {
                return ProtoBuf.Class.Kind.ENUM_ENTRY;
            }
            case ANNOTATION_CLASS: {
                return ProtoBuf.Class.Kind.ANNOTATION_CLASS;
            }
            case OBJECT: {
                return ProtoBuf.Class.Kind.OBJECT;
            }
        }
        throw new IllegalArgumentException("Unknown class kind: " + (Object)((Object)kind));
    }

    public static int getCallableFlags(boolean hasAnnotations, @NotNull Visibility visibility, @NotNull Modality modality, @NotNull CallableMemberDescriptor.Kind memberKind, @NotNull ProtoBuf.Callable.CallableKind callableKind, boolean hasGetter, boolean hasSetter, boolean hasConstant, boolean lateInit) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "getCallableFlags"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "getCallableFlags"));
        }
        if (memberKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberKind", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "getCallableFlags"));
        }
        if (callableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableKind", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "getCallableFlags"));
        }
        return HAS_ANNOTATIONS.toFlags(hasAnnotations) | MODALITY.toFlags(Flags.modality(modality)) | VISIBILITY.toFlags(Flags.visibility(visibility)) | MEMBER_KIND.toFlags(Flags.memberKind(memberKind)) | CALLABLE_KIND.toFlags(callableKind) | HAS_GETTER.toFlags(hasGetter) | HAS_SETTER.toFlags(hasSetter) | HAS_CONSTANT.toFlags(hasConstant) | LATE_INIT.toFlags(lateInit);
    }

    public static int getAccessorFlags(boolean hasAnnotations, @NotNull Visibility visibility, @NotNull Modality modality, boolean isNotDefault) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "getAccessorFlags"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "getAccessorFlags"));
        }
        return HAS_ANNOTATIONS.toFlags(hasAnnotations) | MODALITY.toFlags(Flags.modality(modality)) | VISIBILITY.toFlags(Flags.visibility(visibility)) | IS_NOT_DEFAULT.toFlags(isNotDefault);
    }

    @NotNull
    private static ProtoBuf.Visibility visibility(@NotNull Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "visibility"));
        }
        if (visibility == Visibilities.INTERNAL) {
            ProtoBuf.Visibility visibility2 = ProtoBuf.Visibility.INTERNAL;
            if (visibility2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "visibility"));
            }
            return visibility2;
        }
        if (visibility == Visibilities.PUBLIC) {
            ProtoBuf.Visibility visibility3 = ProtoBuf.Visibility.PUBLIC;
            if (visibility3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "visibility"));
            }
            return visibility3;
        }
        if (visibility == Visibilities.PRIVATE) {
            ProtoBuf.Visibility visibility4 = ProtoBuf.Visibility.PRIVATE;
            if (visibility4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "visibility"));
            }
            return visibility4;
        }
        if (visibility == Visibilities.PRIVATE_TO_THIS) {
            ProtoBuf.Visibility visibility5 = ProtoBuf.Visibility.PRIVATE_TO_THIS;
            if (visibility5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "visibility"));
            }
            return visibility5;
        }
        if (visibility == Visibilities.PROTECTED) {
            ProtoBuf.Visibility visibility6 = ProtoBuf.Visibility.PROTECTED;
            if (visibility6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "visibility"));
            }
            return visibility6;
        }
        if (visibility == Visibilities.LOCAL) {
            ProtoBuf.Visibility visibility7 = ProtoBuf.Visibility.LOCAL;
            if (visibility7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "visibility"));
            }
            return visibility7;
        }
        throw new IllegalArgumentException("Unknown visibility: " + visibility);
    }

    @NotNull
    private static ProtoBuf.Modality modality(@NotNull Modality modality) {
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "modality"));
        }
        switch (modality) {
            case FINAL: {
                ProtoBuf.Modality modality2 = ProtoBuf.Modality.FINAL;
                if (modality2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "modality"));
                }
                return modality2;
            }
            case OPEN: {
                ProtoBuf.Modality modality3 = ProtoBuf.Modality.OPEN;
                if (modality3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "modality"));
                }
                return modality3;
            }
            case ABSTRACT: {
                ProtoBuf.Modality modality4 = ProtoBuf.Modality.ABSTRACT;
                if (modality4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "modality"));
                }
                return modality4;
            }
            case SEALED: {
                ProtoBuf.Modality modality5 = ProtoBuf.Modality.SEALED;
                if (modality5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "modality"));
                }
                return modality5;
            }
        }
        throw new IllegalArgumentException("Unknown modality: " + (Object)((Object)modality));
    }

    @NotNull
    private static ProtoBuf.Callable.MemberKind memberKind(@NotNull CallableMemberDescriptor.Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "memberKind"));
        }
        switch (kind) {
            case DECLARATION: {
                ProtoBuf.Callable.MemberKind memberKind = ProtoBuf.Callable.MemberKind.DECLARATION;
                if (memberKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "memberKind"));
                }
                return memberKind;
            }
            case FAKE_OVERRIDE: {
                ProtoBuf.Callable.MemberKind memberKind = ProtoBuf.Callable.MemberKind.FAKE_OVERRIDE;
                if (memberKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "memberKind"));
                }
                return memberKind;
            }
            case DELEGATION: {
                ProtoBuf.Callable.MemberKind memberKind = ProtoBuf.Callable.MemberKind.DELEGATION;
                if (memberKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "memberKind"));
                }
                return memberKind;
            }
            case SYNTHESIZED: {
                ProtoBuf.Callable.MemberKind memberKind = ProtoBuf.Callable.MemberKind.SYNTHESIZED;
                if (memberKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/Flags", "memberKind"));
                }
                return memberKind;
            }
        }
        throw new IllegalArgumentException("Unknown member kind: " + (Object)((Object)kind));
    }

    public static int getValueParameterFlags(boolean hasAnnotations, boolean declaresDefaultValue) {
        return HAS_ANNOTATIONS.toFlags(hasAnnotations) | DECLARES_DEFAULT_VALUE.toFlags(declaresDefaultValue);
    }

    private static class EnumLiteFlagField<E extends Internal.EnumLite>
    extends FlagField<E> {
        public EnumLiteFlagField(int offset, E[] values) {
            super(offset, values);
        }

        @Override
        protected int getIntValue(E value) {
            return value.getNumber();
        }
    }

    private static class BooleanFlagField
    extends FlagField<Boolean> {
        private static final Boolean[] BOOLEAN = new Boolean[]{false, true};

        public BooleanFlagField(int offset) {
            super(offset, BOOLEAN);
        }

        @Override
        protected int getIntValue(Boolean value) {
            return value != false ? 1 : 0;
        }
    }

    public static abstract class FlagField<E> {
        private final int offset;
        private final int bitWidth;
        private final E[] values;

        public static <E extends Internal.EnumLite> FlagField<E> after(FlagField<?> previousField, E[] values) {
            int offset = previousField.offset + previousField.bitWidth;
            return new EnumLiteFlagField(offset, values);
        }

        public static <E extends Internal.EnumLite> FlagField<E> first(E[] values) {
            return new EnumLiteFlagField(0, values);
        }

        public static FlagField<Boolean> booleanFirst() {
            return new BooleanFlagField(0);
        }

        public static FlagField<Boolean> booleanAfter(FlagField<?> previousField) {
            int offset = previousField.offset + previousField.bitWidth;
            return new BooleanFlagField(offset);
        }

        private FlagField(int offset, E[] values) {
            this.offset = offset;
            this.bitWidth = Flags.bitWidth(values);
            this.values = values;
        }

        public E get(int flags) {
            int maskUnshifted = (1 << this.bitWidth) - 1;
            int mask = maskUnshifted << this.offset;
            int value = (flags & mask) >> this.offset;
            for (E e : this.values) {
                if (this.getIntValue(e) != value) continue;
                return e;
            }
            throw new IllegalStateException("Flag not found: " + value);
        }

        public int toFlags(E value) {
            return this.getIntValue(value) << this.offset;
        }

        protected abstract int getIntValue(E var1);
    }
}

