/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorEquivalenceForOverrides {
    public static final DescriptorEquivalenceForOverrides INSTANCE;

    public final boolean areEquivalent(@Nullable DeclarationDescriptor a, @Nullable DeclarationDescriptor b) {
        return a instanceof ClassDescriptor && b instanceof ClassDescriptor ? this.areClassesEquivalent((ClassDescriptor)a, (ClassDescriptor)b) : (a instanceof TypeParameterDescriptor && b instanceof TypeParameterDescriptor ? DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)a, (TypeParameterDescriptor)b, null, 4, null) : (a instanceof CallableDescriptor && b instanceof CallableDescriptor ? DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(this, (CallableDescriptor)a, (CallableDescriptor)b, false, 4, null) : (a instanceof PackageFragmentDescriptor && b instanceof PackageFragmentDescriptor ? Intrinsics.areEqual((Object)((PackageFragmentDescriptor)a).getFqName(), (Object)((PackageFragmentDescriptor)b).getFqName()) : Intrinsics.areEqual((Object)a, (Object)b))));
    }

    private final boolean areClassesEquivalent(ClassDescriptor a, ClassDescriptor b) {
        return Intrinsics.areEqual((Object)a.getTypeConstructor(), (Object)b.getTypeConstructor());
    }

    private final boolean areTypeParametersEquivalent(TypeParameterDescriptor a, TypeParameterDescriptor b, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        if (Intrinsics.areEqual((Object)a, (Object)b)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)a.getContainingDeclaration(), (Object)b.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(a, b, equivalentCallables)) {
            return false;
        }
        return a.getIndex() == b.getIndex();
    }

    static /* bridge */ /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = areTypeParametersEquivalent.1.INSTANCE;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)function2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean areCallableDescriptorsEquivalent(@NotNull CallableDescriptor a, @NotNull CallableDescriptor b, boolean ignoreReturnType) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (Intrinsics.areEqual((Object)a, (Object)b)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)a.getName(), (Object)b.getName()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)a.getContainingDeclaration(), (Object)b.getContainingDeclaration())) {
            return false;
        }
        if (DescriptorUtils.isLocal(a)) return false;
        if (DescriptorUtils.isLocal(b)) {
            return false;
        }
        if (!this.ownersEquivalent(a, b, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)((Function2)areCallableDescriptorsEquivalent.1.INSTANCE))) {
            return false;
        }
        OverridingUtil overridingUtil2 = OverridingUtil.createWithEqualityAxioms(new KotlinTypeChecker.TypeConstructorEquality(a, b){
            final /* synthetic */ CallableDescriptor $a;
            final /* synthetic */ CallableDescriptor $b;

            public final boolean invoke(@NotNull TypeConstructor c1, @NotNull TypeConstructor c2) {
                Intrinsics.checkParameterIsNotNull((Object)c1, (String)"c1");
                Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c2");
                if (Intrinsics.areEqual((Object)c1, (Object)c2)) {
                    return true;
                }
                ClassifierDescriptor d1 = c1.getDeclarationDescriptor();
                ClassifierDescriptor d2 = c2.getDeclarationDescriptor();
                if (!(d1 instanceof TypeParameterDescriptor) || !(d2 instanceof TypeParameterDescriptor)) {
                    return false;
                }
                return DescriptorEquivalenceForOverrides.access$areTypeParametersEquivalent(DescriptorEquivalenceForOverrides.INSTANCE, (TypeParameterDescriptor)d1, (TypeParameterDescriptor)d2, (Function2)new Function2<DeclarationDescriptor, DeclarationDescriptor, Boolean>(this){
                    final /* synthetic */ areCallableDescriptorsEquivalent.overridingUtil.1 this$0;

                    public final boolean invoke(@Nullable DeclarationDescriptor x, @Nullable DeclarationDescriptor y) {
                        return Intrinsics.areEqual((Object)x, (Object)this.this$0.$a) && Intrinsics.areEqual((Object)y, (Object)this.this$0.$b);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                });
            }
            {
                this.$a = callableDescriptor;
                this.$b = callableDescriptor2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)overridingUtil2, (String)"OverridingUtil.createWit\u2026= a && y == b})\n        }");
        OverridingUtil overridingUtil3 = overridingUtil2;
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = overridingUtil3.isOverridableBy(a, b, null, !ignoreReturnType);
        Intrinsics.checkExpressionValueIsNotNull((Object)overrideCompatibilityInfo, (String)"overridingUtil.isOverrid\u2026 null, !ignoreReturnType)");
        if (overrideCompatibilityInfo.getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) return false;
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo2 = overridingUtil3.isOverridableBy(b, a, null, !ignoreReturnType);
        Intrinsics.checkExpressionValueIsNotNull((Object)overrideCompatibilityInfo2, (String)"overridingUtil.isOverrid\u2026 null, !ignoreReturnType)");
        if (overrideCompatibilityInfo2.getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) return false;
        return true;
    }

    public static /* bridge */ /* synthetic */ boolean areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return descriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent(callableDescriptor, callableDescriptor2, bl);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor a, DeclarationDescriptor b, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        DeclarationDescriptor aOwner = a.getContainingDeclaration();
        DeclarationDescriptor bOwner = b.getContainingDeclaration();
        return aOwner instanceof CallableMemberDescriptor || bOwner instanceof CallableMemberDescriptor ? ((Boolean)equivalentCallables.invoke((Object)aOwner, (Object)bOwner)).booleanValue() : this.areEquivalent(aOwner, bOwner);
    }

    private DescriptorEquivalenceForOverrides() {
    }

    static {
        DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides;
        INSTANCE = descriptorEquivalenceForOverrides = new DescriptorEquivalenceForOverrides();
    }

    public static final /* synthetic */ boolean access$areTypeParametersEquivalent(DescriptorEquivalenceForOverrides $this, @NotNull TypeParameterDescriptor a, @NotNull TypeParameterDescriptor b, @NotNull Function2 equivalentCallables) {
        return $this.areTypeParametersEquivalent(a, b, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)equivalentCallables);
    }
}

