/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoEnumFlags;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.SuspendFunctionTypeUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedAnnotationsWithPossibleTargets;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeBasedStarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    private final Function1<Integer, ClassDescriptor> classDescriptors;
    private final Function1<Integer, ClassifierDescriptor> typeAliasDescriptors;
    private final Map<Integer, TypeParameterDescriptor> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final String debugName;
    private boolean experimentalSuspendFunctionTypeEncountered;

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)additionalAnnotations, (String)"additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            SimpleType lowerBound = this.simpleType(proto, additionalAnnotations);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            SimpleType upperBound = this.simpleType(type2, additionalAnnotations);
            return this.c.getComponents().getFlexibleTypeDeserializer().create(proto, id, lowerBound, upperBound);
        }
        return this.simpleType(proto, additionalAnnotations);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n, Object object) {
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type2, annotations2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType simpleType(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        SimpleType localClassifierType;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)additionalAnnotations, (String)"additionalAnnotations");
        SimpleType simpleType2 = proto.hasClassName() ? this.computeLocalClassifierReplacementType(proto.getClassName()) : (localClassifierType = proto.hasTypeAliasName() ? this.computeLocalClassifierReplacementType(proto.getTypeAliasName()) : null);
        if (localClassifierType != null) {
            return localClassifierType;
        }
        TypeConstructor constructor = this.typeConstructor(proto);
        if (ErrorUtils.isError(constructor.getDeclarationDescriptor())) {
            SimpleType simpleType3 = ErrorUtils.createErrorTypeWithCustomConstructor(constructor.toString(), constructor);
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"ErrorUtils.createErrorTy\u2026.toString(), constructor)");
            return simpleType3;
        }
        DeserializedAnnotationsWithPossibleTargets annotations2 = new DeserializedAnnotationsWithPossibleTargets(this.c.getStorageManager(), (Function0<? extends List<AnnotationWithTarget>>)((Function0)new Function0<List<? extends AnnotationWithTarget>>(this, proto, additionalAnnotations){
            final /* synthetic */ TypeDeserializer this$0;
            final /* synthetic */ ProtoBuf.Type $proto;
            final /* synthetic */ Annotations $additionalAnnotations;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<AnnotationWithTarget> invoke() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable $receiver$iv = TypeDeserializer.access$getC$p(this.this$0).getComponents().getAnnotationAndConstantLoader().loadTypeAnnotations(this.$proto, TypeDeserializer.access$getC$p(this.this$0).getNameResolver());
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    AnnotationWithTarget annotationWithTarget = new AnnotationWithTarget((AnnotationDescriptor)it, null);
                    collection.add(annotationWithTarget);
                }
                return CollectionsKt.toList((Iterable)CollectionsKt.plus((Collection)((List)var3_3), (Iterable)this.$additionalAnnotations.getAllAnnotations()));
            }
            {
                this.this$0 = typeDeserializer;
                this.$proto = type2;
                this.$additionalAnnotations = annotations2;
                super(0);
            }
        }));
        Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>> collectAllArguments$ = new Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final List<ProtoBuf.Type.Argument> invoke(@NotNull ProtoBuf.Type $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                List<ProtoBuf.Type.Argument> list = $receiver.getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"argumentList");
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.outerType($receiver, TypeDeserializer.access$getC$p(this.this$0).getTypeTable());
                List list2 = type2 != null ? this.invoke(type2) : null;
                Collection collection = list;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                List list4 = list3;
                return CollectionsKt.plus((Collection)collection, (Iterable)list4);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        };
        Iterable iterable = $receiver$iv = (Iterable)collectAllArguments$.invoke(proto);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void argumentProto;
            void index;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            List<TypeParameterDescriptor> list = constructor.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"constructor.parameters");
            TypeProjection typeProjection = this.typeArgument((TypeParameterDescriptor)CollectionsKt.getOrNull(list, (int)index), (ProtoBuf.Type.Argument)argumentProto);
            collection2.add(typeProjection);
        }
        List arguments2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Boolean bl = Flags.SUSPEND_TYPE.get(proto.getFlags());
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"Flags.SUSPEND_TYPE.get(proto.flags)");
        SimpleType simpleType4 = bl != false ? this.createSuspendFunctionType(annotations2, constructor, arguments2, proto.getNullable()) : KotlinTypeFactory.simpleType(annotations2, constructor, arguments2, proto.getNullable());
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.abbreviatedType(proto, this.c.getTypeTable());
        if (type2 == null) {
            return simpleType4;
        }
        ProtoBuf.Type abbreviatedTypeProto = type2;
        return SpecialTypesKt.withAbbreviation(simpleType4, this.simpleType(abbreviatedTypeProto, additionalAnnotations));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SimpleType simpleType$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n, Object object) {
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.simpleType(type2, annotations2);
    }

    private final TypeConstructor typeConstructor(ProtoBuf.Type proto) {
        Object object;
        Function1<Integer, ClassDescriptor> notFoundClass$ = new Function1<Integer, ClassDescriptor>(this, proto){
            final /* synthetic */ TypeDeserializer this$0;
            final /* synthetic */ ProtoBuf.Type $proto;

            @NotNull
            public final ClassDescriptor invoke(int classIdIndex) {
                ClassId classId = NameResolverUtilKt.getClassId(TypeDeserializer.access$getC$p(this.this$0).getNameResolver(), classIdIndex);
                List typeParametersCount2 = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)this.$proto, (Function1)((Function1)new Function1<ProtoBuf.Type, ProtoBuf.Type>(this){
                    final /* synthetic */ typeConstructor.1 this$0;

                    @Nullable
                    public final ProtoBuf.Type invoke(@NotNull ProtoBuf.Type it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return ProtoTypeTableUtilKt.outerType(it, TypeDeserializer.access$getC$p(this.this$0.this$0).getTypeTable());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })), (Function1)typeConstructor.typeParametersCount.2.INSTANCE));
                int classNestingLevel2 = SequencesKt.count((Sequence)SequencesKt.generateSequence((Object)classId, (Function1)typeConstructor.classNestingLevel.1.INSTANCE));
                while (typeParametersCount2.size() < classNestingLevel2) {
                    typeParametersCount2.add(0);
                }
                return TypeDeserializer.access$getC$p(this.this$0).getComponents().getNotFoundClasses().getClass(classId, typeParametersCount2);
            }
            {
                this.this$0 = typeDeserializer;
                this.$proto = type2;
                super(1);
            }
        };
        if (proto.hasClassName()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)this.classDescriptors.invoke((Object)proto.getClassName());
            if (classDescriptor == null) {
                classDescriptor = notFoundClass$.invoke(proto.getClassName());
            }
            TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
            object = typeConstructor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"(classDescriptors(proto.\u2026assName)).typeConstructor");
        } else if (proto.hasTypeParameter()) {
            object = this.typeParameterTypeConstructor(proto.getTypeParameter());
            if (object == null) {
                TypeConstructor typeConstructor3 = ErrorUtils.createErrorTypeConstructor("Unknown type parameter " + proto.getTypeParameter());
                object = typeConstructor3;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor3, (String)"ErrorUtils.createErrorTy\u2026 ${proto.typeParameter}\")");
            }
        } else if (proto.hasTypeParameterName()) {
            TypeParameterDescriptor parameter;
            Object v4;
            String name;
            DeclarationDescriptor container;
            block13: {
                Iterable iterable;
                container = this.c.getContainingDeclaration();
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable2 = iterable = (Iterable)this.getOwnTypeParameters();
                for (Object t : iterable2) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name)) continue;
                    v4 = t;
                    break block13;
                }
                v4 = null;
            }
            if ((object = (parameter = (TypeParameterDescriptor)v4)) == null || (object = object.getTypeConstructor()) == null) {
                TypeConstructor typeConstructor4 = ErrorUtils.createErrorTypeConstructor("Deserialized type parameter " + name + " in " + container);
                object = typeConstructor4;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor4, (String)"ErrorUtils.createErrorTy\u2026ter $name in $container\")");
            }
        } else if (proto.hasTypeAliasName()) {
            ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)this.typeAliasDescriptors.invoke((Object)proto.getTypeAliasName());
            if (classifierDescriptor == null) {
                classifierDescriptor = notFoundClass$.invoke(proto.getTypeAliasName());
            }
            TypeConstructor typeConstructor5 = classifierDescriptor.getTypeConstructor();
            object = typeConstructor5;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor5, (String)"(typeAliasDescriptors(pr\u2026iasName)).typeConstructor");
        } else {
            TypeConstructor typeConstructor6 = ErrorUtils.createErrorTypeConstructor("Unknown type");
            object = typeConstructor6;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor6, (String)"ErrorUtils.createErrorTy\u2026nstructor(\"Unknown type\")");
        }
        return object;
    }

    private final SimpleType createSuspendFunctionType(Annotations annotations2, TypeConstructor functionTypeConstructor, List<? extends TypeProjection> arguments2, boolean nullable) {
        SimpleType result2;
        SimpleType simpleType2;
        SimpleType simpleType3;
        switch (functionTypeConstructor.getParameters().size() - arguments2.size()) {
            case 0: {
                simpleType3 = this.createSuspendFunctionTypeForBasicCase(annotations2, functionTypeConstructor, arguments2, nullable);
                break;
            }
            case 1: {
                int arity = arguments2.size() - 1;
                if (arity >= 0) {
                    ClassDescriptor classDescriptor = functionTypeConstructor.getBuiltIns().getSuspendFunction(arity);
                    Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"functionTypeConstructor.\u2026getSuspendFunction(arity)");
                    TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"functionTypeConstructor.\u2026on(arity).typeConstructor");
                    simpleType3 = KotlinTypeFactory.simpleType(annotations2, typeConstructor2, arguments2, nullable);
                    break;
                }
                simpleType3 = null;
                break;
            }
            default: {
                simpleType3 = null;
            }
        }
        if ((simpleType2 = (result2 = simpleType3)) == null) {
            SimpleType simpleType4 = ErrorUtils.createErrorTypeWithArguments("Bad suspend function in metadata with constructor: " + functionTypeConstructor, arguments2);
            simpleType2 = simpleType4;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"ErrorUtils.createErrorTy\u2026      arguments\n        )");
        }
        return simpleType2;
    }

    private final SimpleType createSuspendFunctionTypeForBasicCase(Annotations annotations2, TypeConstructor functionTypeConstructor, List<? extends TypeProjection> arguments2, boolean nullable) {
        SimpleType functionType = KotlinTypeFactory.simpleType(annotations2, functionTypeConstructor, arguments2, nullable);
        return !FunctionTypesKt.isFunctionType(functionType) ? null : this.transformRuntimeFunctionTypeToSuspendFunction(functionType);
    }

    private final SimpleType transformRuntimeFunctionTypeToSuspendFunction(KotlinType funType) {
        FqName continuationArgumentFqName;
        boolean isReleaseCoroutines = this.c.getComponents().getConfiguration().getReleaseCoroutines();
        Object object = (TypeProjection)CollectionsKt.lastOrNull(FunctionTypesKt.getValueParameterTypesFromFunctionType(funType));
        if (object == null || (object = object.getType()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"funType.getValueParamete\u2026ll()?.type ?: return null");
        Object continuationArgumentType = object;
        ClassifierDescriptor classifierDescriptor = ((KotlinType)continuationArgumentType).getConstructor().getDeclarationDescriptor();
        FqName fqName2 = continuationArgumentFqName = classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null;
        if (((KotlinType)continuationArgumentType).getArguments().size() != 1 || !SuspendFunctionTypesKt.isContinuation(continuationArgumentFqName, true) && !SuspendFunctionTypesKt.isContinuation(continuationArgumentFqName, false)) {
            return (SimpleType)funType;
        }
        KotlinType kotlinType = ((TypeProjection)CollectionsKt.single(((KotlinType)continuationArgumentType).getArguments())).getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"continuationArgumentType.arguments.single().type");
        KotlinType suspendReturnType = kotlinType;
        DeclarationDescriptor $receiver$iv = this.c.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor = $receiver$iv;
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
        if (Intrinsics.areEqual((Object)(callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull(callableDescriptor) : null), (Object)SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
            return this.createSimpleSuspendFunctionType(funType, suspendReturnType);
        }
        this.experimentalSuspendFunctionTypeEncountered = this.experimentalSuspendFunctionTypeEncountered || isReleaseCoroutines && SuspendFunctionTypesKt.isContinuation(continuationArgumentFqName, !isReleaseCoroutines);
        return this.createSimpleSuspendFunctionType(funType, suspendReturnType);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType createSimpleSuspendFunctionType(KotlinType funType, KotlinType suspendReturnType) {
        Collection<KotlinType> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = CollectionsKt.dropLast(FunctionTypesKt.getValueParameterTypesFromFunctionType(funType), (int)1);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(funType);
        Annotations annotations2 = funType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(funType);
        void var4_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            KotlinType kotlinType2 = p1.getType();
            collection.add(kotlinType2);
        }
        collection = (List)destination$iv$iv;
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, (List<? extends KotlinType>)collection, null, suspendReturnType, true).makeNullableAsSpecified(funType.isMarkedNullable());
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Object object = this.typeParameterDescriptors.get(typeParameterId);
        if (object == null || (object = object.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            object = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return object;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id = NameResolverUtilKt.getClassId(this.c.getNameResolver(), fqNameIndex);
        if (id.isLocal()) {
            return this.c.getComponents().deserializeClass(id);
        }
        return FindClassInModuleKt.findClassAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), id);
    }

    private final SimpleType computeLocalClassifierReplacementType(int className) {
        if (NameResolverUtilKt.getClassId(this.c.getNameResolver(), className).isLocal()) {
            return this.c.getComponents().getLocalClassifierTypeSettings().getReplacementTypeForLocalClassifiers();
        }
        return null;
    }

    private final ClassifierDescriptor computeTypeAliasDescriptor(int fqNameIndex) {
        ClassId id = NameResolverUtilKt.getClassId(this.c.getNameResolver(), fqNameIndex);
        if (id.isLocal()) {
            return null;
        }
        return FindClassInModuleKt.findTypeAliasAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), id);
    }

    private final TypeProjection typeArgument(TypeParameterDescriptor parameter, ProtoBuf.Type.Argument typeArgumentProto) {
        if (typeArgumentProto.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            TypeProjection typeProjection;
            if (parameter == null) {
                SimpleType simpleType2 = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"c.components.moduleDescr\u2026.builtIns.nullableAnyType");
                typeProjection = new TypeBasedStarProjectionImpl(simpleType2);
            } else {
                typeProjection = new StarProjectionImpl(parameter);
            }
            return typeProjection;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull((Object)projection, (String)"typeArgumentProto.projection");
        Variance projection2 = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type2 == null) {
            return new TypeProjectionImpl(ErrorUtils.createErrorType("No type recorded"));
        }
        ProtoBuf.Type type3 = type2;
        return new TypeProjectionImpl(projection2, TypeDeserializer.type$default(this, type3, null, 2, null));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public final boolean getExperimentalSuspendFunctionTypeEncountered() {
        return this.experimentalSuspendFunctionTypeEncountered;
    }

    /*
     * WARNING - void declaration
     */
    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName, boolean experimentalSuspendFunctionTypeEncountered) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, (String)"typeParameterProtos");
        Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
        this.c = c;
        this.parent = parent;
        this.debugName = debugName;
        this.experimentalSuspendFunctionTypeEncountered = experimentalSuspendFunctionTypeEncountered;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeAliasDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassifierDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassifierDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeTypeAliasDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        TypeDeserializer typeDeserializer = this;
        if (typeParameterProtos.isEmpty()) {
            TypeDeserializer typeDeserializer2 = typeDeserializer;
            Map map3 = MapsKt.emptyMap();
            typeDeserializer = typeDeserializer2;
            map2 = map3;
        } else {
            LinkedHashMap result2 = new LinkedHashMap();
            boolean bl = false;
            for (ProtoBuf.TypeParameter proto : (Iterable)typeParameterProtos) {
                void index;
                Map map4 = result2;
                Integer n = proto.getId();
                DeserializedTypeParameterDescriptor deserializedTypeParameterDescriptor = new DeserializedTypeParameterDescriptor(this.c, proto, (int)index);
                TypeDeserializer typeDeserializer3 = typeDeserializer;
                map4.put(n, deserializedTypeParameterDescriptor);
                TypeDeserializer typeDeserializer4 = typeDeserializer3;
                ++index;
            }
            map2 = result2;
        }
        typeDeserializer.typeParameterDescriptors = map2;
    }

    public /* synthetic */ TypeDeserializer(DeserializationContext deserializationContext, TypeDeserializer typeDeserializer, List list, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(deserializationContext, typeDeserializer, list, string, bl);
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @Nullable
    public static final /* synthetic */ ClassifierDescriptor access$computeTypeAliasDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeTypeAliasDescriptor(fqNameIndex);
    }
}

