/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.Collections;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorNonRootImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.KtScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.LazyScopeAdapter;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeIntersector;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.ReadOnly;

public abstract class AbstractTypeParameterDescriptor
extends DeclarationDescriptorNonRootImpl
implements TypeParameterDescriptor {
    private final Variance variance;
    private final boolean reified;
    private final int index;
    private final NotNullLazyValue<TypeConstructor> typeConstructor;
    private final NotNullLazyValue<KotlinType> defaultType;
    private final NotNullLazyValue<Set<KotlinType>> upperBounds;
    private final NotNullLazyValue<KotlinType> upperBoundsAsType;

    protected AbstractTypeParameterDescriptor(final @NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name, @NotNull Variance variance, boolean isReified, int index, @NotNull SourceElement source) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variance", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        super(containingDeclaration, annotations2, name, source);
        this.variance = variance;
        this.reified = isReified;
        this.index = index;
        this.typeConstructor = storageManager.createLazyValue(new Function0<TypeConstructor>(){

            public TypeConstructor invoke() {
                return AbstractTypeParameterDescriptor.this.createTypeConstructor();
            }
        });
        this.defaultType = storageManager.createLazyValue(new Function0<KotlinType>(){

            public KotlinType invoke() {
                return KotlinTypeImpl.create(Annotations.Companion.getEMPTY(), AbstractTypeParameterDescriptor.this.getTypeConstructor(), false, Collections.emptyList(), new LazyScopeAdapter(storageManager.createLazyValue(new Function0<KtScope>(){

                    public KtScope invoke() {
                        return AbstractTypeParameterDescriptor.this.getUpperBoundsAsType().getMemberScope();
                    }
                })));
            }
        });
        this.upperBounds = storageManager.createRecursionTolerantLazyValue(new Function0<Set<KotlinType>>(){

            public Set<KotlinType> invoke() {
                return AbstractTypeParameterDescriptor.this.resolveUpperBounds();
            }
        }, Collections.singleton(ErrorUtils.createErrorType("Recursion while calculating upper bounds")));
        this.upperBoundsAsType = storageManager.createLazyValue(new Function0<KotlinType>(){

            public KotlinType invoke() {
                return AbstractTypeParameterDescriptor.this.computeUpperBoundsAsType();
            }
        });
    }

    @NotNull
    @ReadOnly
    protected abstract Set<KotlinType> resolveUpperBounds();

    @NotNull
    protected abstract TypeConstructor createTypeConstructor();

    @Override
    @NotNull
    public Variance getVariance() {
        Variance variance = this.variance;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "getVariance"));
        }
        return variance;
    }

    @Override
    public boolean isReified() {
        return this.reified;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public Set<KotlinType> getUpperBounds() {
        Set set = (Set)this.upperBounds.invoke();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "getUpperBounds"));
        }
        return set;
    }

    @Override
    @NotNull
    public KotlinType getUpperBoundsAsType() {
        KotlinType kotlinType = (KotlinType)this.upperBoundsAsType.invoke();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "getUpperBoundsAsType"));
        }
        return kotlinType;
    }

    @NotNull
    private KotlinType computeUpperBoundsAsType() {
        Set<KotlinType> upperBounds = this.getUpperBounds();
        assert (!upperBounds.isEmpty()) : "Upper bound list is empty in " + this.getName();
        KotlinType upperBoundsAsType = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, upperBounds);
        KotlinType kotlinType = upperBoundsAsType != null ? upperBoundsAsType : DescriptorUtilsKt.getBuiltIns(this).getNothingType();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "computeUpperBoundsAsType"));
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor2 = (TypeConstructor)this.typeConstructor.invoke();
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "getTypeConstructor"));
        }
        return typeConstructor2;
    }

    @Override
    @NotNull
    public KotlinType getDefaultType() {
        KotlinType kotlinType = (KotlinType)this.defaultType.invoke();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "getDefaultType"));
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public Set<KotlinType> getLowerBounds() {
        Set<KotlinType> set = Collections.singleton(DescriptorUtilsKt.getBuiltIns(this).getNothingType());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "getLowerBounds"));
        }
        return set;
    }

    @Override
    @Deprecated
    @NotNull
    public TypeParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "kotlin/reflect/jvm/internal/impl/descriptors/impl/AbstractTypeParameterDescriptor", "substitute"));
        }
        throw new UnsupportedOperationException("Don't call substitute() on type parameters");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        return visitor2.visitTypeParameterDescriptor(this, data);
    }
}

