/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.TypeBounds;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.constraintPosition.ConstraintPosition;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.AnnotationsForResolveKt;
import kotlin.reflect.jvm.internal.impl.types.CommonSupertypes;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeIntersector;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeBoundsImpl
implements TypeBounds {
    @NotNull
    private final ArrayList<TypeBounds.Bound> bounds;
    private Collection<? extends KotlinType> resultValues;
    private boolean isFixed;
    @NotNull
    private final TypeParameterDescriptor typeVariable;
    @NotNull
    private final Variance varianceOfPosition;

    @NotNull
    public ArrayList<TypeBounds.Bound> getBounds() {
        return this.bounds;
    }

    public final boolean isFixed() {
        return this.isFixed;
    }

    private final void setFixed(boolean bl) {
        this.isFixed = bl;
    }

    public final void setFixed() {
        this.isFixed = true;
    }

    public final void addBound(@NotNull TypeBounds.Bound bound) {
        Intrinsics.checkParameterIsNotNull((Object)bound, (String)"bound");
        this.resultValues = null;
        boolean value2 = Intrinsics.areEqual((Object)bound.getTypeVariable(), (Object)this.getTypeVariable());
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = bound + " is added for incorrect type variable " + bound.getTypeVariable().getName() + ". Expected: " + this.getTypeVariable().getName();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        ((ArrayList)this.getBounds()).add(bound);
    }

    private final Set<KotlinType> filterBounds(Collection<? extends TypeBounds.Bound> bounds, TypeBounds.BoundKind kind) {
        return this.filterBounds(bounds, kind, null);
    }

    private final Set<KotlinType> filterBounds(Collection<? extends TypeBounds.Bound> bounds, TypeBounds.BoundKind kind, Collection<KotlinType> errorValues) {
        LinkedHashSet<KotlinType> result = new LinkedHashSet<KotlinType>();
        for (TypeBounds.Bound bound : bounds) {
            if (!Intrinsics.areEqual((Object)((Object)bound.getKind()), (Object)((Object)kind))) continue;
            if (!ErrorUtils.containsErrorType(bound.getConstrainingType())) {
                result.add(bound.getConstrainingType());
                continue;
            }
            Collection<KotlinType> collection = errorValues;
            Boolean bl = collection != null ? Boolean.valueOf(collection.add(bound.getConstrainingType())) : null;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeBoundsImpl filter(@NotNull Function1<? super ConstraintPosition, ? extends Boolean> condition) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        TypeBoundsImpl result = new TypeBoundsImpl(this.getTypeVariable(), this.getVarianceOfPosition());
        Iterable iterable = this.getBounds();
        Collection collection = result.getBounds();
        void var5_5 = $receiver2;
        Collection collection2 = new ArrayList();
        for (Object element : $receiver) {
            TypeBounds.Bound it = (TypeBounds.Bound)element;
            if (!((Boolean)condition.invoke((Object)it.getPosition())).booleanValue()) continue;
            destination.add(element);
        }
        List list = (List)destination;
        ((ArrayList)collection).addAll(list);
        return result;
    }

    @Override
    @NotNull
    public Collection<KotlinType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<KotlinType> collection = this.resultValues;
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KotlinType> computeValues() {
        KotlinType intersectionOfUpperBounds;
        KotlinType superTypeOfAllLowerBounds;
        void numberLowerBounds;
        void generalLowerBounds;
        void $receiver;
        boolean hasStrongBound;
        Object it;
        Object element3;
        List bounds;
        LinkedHashSet values;
        block15: {
            boolean bl;
            Iterator destination;
            Iterable $receiver2;
            values = new LinkedHashSet();
            Iterable $receiver3 = this.getBounds();
            Iterable iterable = $receiver3;
            Collection collection = new ArrayList();
            for (Object element2 : $receiver2) {
                TypeBounds.Bound it2 = (TypeBounds.Bound)element2;
                if (!it2.isProper()) continue;
                destination.add(element2);
            }
            bounds = (List)((Object)destination);
            if (bounds.isEmpty()) {
                return CollectionsKt.listOf();
            }
            $receiver2 = bounds;
            for (Object element3 : $receiver2) {
                it = (TypeBounds.Bound)element3;
                if (!((TypeBounds.Bound)it).getPosition().isStrong()) continue;
                bl = true;
                break block15;
            }
            bl = hasStrongBound = false;
        }
        if (!hasStrongBound) {
            return CollectionsKt.listOf();
        }
        Set<KotlinType> exactBounds = this.filterBounds(bounds, TypeBounds.BoundKind.EXACT_BOUND, values);
        KotlinType bestFit = FlexibleTypesKt.singleBestRepresentative((Collection<? extends KotlinType>)exactBounds);
        if (bestFit != null && this.tryPossibleAnswer(bounds, bestFit)) {
            return CollectionsKt.listOf((Object)bestFit);
        }
        values.addAll(exactBounds);
        Iterable $i$f$any = this.filterBounds(bounds, TypeBounds.BoundKind.LOWER_BOUND, values);
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        for (Object element4 : $receiver) {
            KotlinType it3 = (KotlinType)element4;
            if (it3.getConstructor() instanceof IntegerValueTypeConstructor) {
                first.add(element4);
                continue;
            }
            second.add(element4);
        }
        Pair $i$a$1 = new Pair(first, second);
        element3 = (List)$i$a$1.component1();
        it = (List)$i$a$1.component2();
        $i$a$1 = null;
        KotlinType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection)generalLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfLowerBounds)) {
            KotlinType kotlinType = superTypeOfLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf((Object)kotlinType);
        }
        kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull(values, superTypeOfLowerBounds);
        KotlinType superTypeOfNumberLowerBounds = TypeUtils.commonSupertypeForNumberTypes((Collection)numberLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfNumberLowerBounds)) {
            KotlinType kotlinType = superTypeOfNumberLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf((Object)kotlinType);
        }
        kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull(values, superTypeOfNumberLowerBounds);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.tryPossibleAnswer(bounds, superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes(CollectionsKt.listOf((Object[])new KotlinType[]{superTypeOfLowerBounds, superTypeOfNumberLowerBounds})))) {
            KotlinType kotlinType = superTypeOfAllLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf((Object)kotlinType);
        }
        Set<KotlinType> upperBounds = this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND, values);
        if (CollectionsKt.isNotEmpty((Collection)upperBounds) && (intersectionOfUpperBounds = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, upperBounds)) != null && this.tryPossibleAnswer(bounds, intersectionOfUpperBounds)) {
            return SetsKt.setOf((Object)intersectionOfUpperBounds);
        }
        values.addAll(this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND));
        if (values.size() == 1 && AnnotationsForResolveKt.hasOnlyInputTypesAnnotation(this.getTypeVariable()) && !this.tryPossibleAnswer(bounds, (KotlinType)CollectionsKt.first((Iterable)values))) {
            return CollectionsKt.listOf();
        }
        return values;
    }

    private final boolean tryPossibleAnswer(Collection<? extends TypeBounds.Bound> bounds, KotlinType possibleAnswer) {
        Object object;
        if (possibleAnswer == null) {
            return false;
        }
        if (!possibleAnswer.getConstructor().isDenotable() && !CapturedTypeConstructorKt.isCaptured(possibleAnswer)) {
            return false;
        }
        if (AnnotationsForResolveKt.hasOnlyInputTypesAnnotation(this.getTypeVariable())) {
            Collection destination;
            TypeBounds.Bound it;
            Iterable $receiver;
            Iterable $receiver2 = bounds;
            object = $receiver2;
            Collection collection = new ArrayList();
            for (Object element : $receiver) {
                it = (TypeBounds.Bound)element;
                if (!(it.isProper() && it.getConstrainingType().getConstructor().isDenotable())) continue;
                destination.add(element);
            }
            Iterable $receiver3 = (List)destination;
            $receiver = $receiver3;
            destination = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
            for (Object item : $receiver) {
                it = (TypeBounds.Bound)item;
                Collection collection2 = destination;
                KotlinType kotlinType = it.getConstrainingType();
                collection2.add(kotlinType);
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination));
            if (!set.contains(possibleAnswer)) {
                return false;
            }
        }
        for (TypeBounds.Bound bound : bounds) {
            object = bound.getKind();
            if (!(Intrinsics.areEqual((Object)object, (Object)((Object)TypeBounds.BoundKind.LOWER_BOUND)) ? !KotlinTypeChecker.DEFAULT.isSubtypeOf(bound.getConstrainingType(), possibleAnswer) : (Intrinsics.areEqual((Object)object, (Object)((Object)TypeBounds.BoundKind.UPPER_BOUND)) ? !KotlinTypeChecker.DEFAULT.isSubtypeOf(possibleAnswer, bound.getConstrainingType()) : Intrinsics.areEqual((Object)object, (Object)((Object)TypeBounds.BoundKind.EXACT_BOUND)) && !KotlinTypeChecker.DEFAULT.equalTypes(bound.getConstrainingType(), possibleAnswer)))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getTypeVariable() {
        return this.typeVariable;
    }

    @Override
    @NotNull
    public Variance getVarianceOfPosition() {
        return this.varianceOfPosition;
    }

    public TypeBoundsImpl(@NotNull TypeParameterDescriptor typeVariable, @NotNull Variance varianceOfPosition) {
        Intrinsics.checkParameterIsNotNull((Object)typeVariable, (String)"typeVariable");
        Intrinsics.checkParameterIsNotNull((Object)((Object)varianceOfPosition), (String)"varianceOfPosition");
        this.typeVariable = typeVariable;
        this.varianceOfPosition = varianceOfPosition;
        this.bounds = new ArrayList();
    }

    @Override
    @Nullable
    public KotlinType getValue() {
        return TypeBounds.DefaultImpls.getValue(this);
    }
}

