/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportPath {
    @NotNull
    private final FqName fqName;
    @Nullable
    private final Name alias;
    private final boolean isAllUnder;

    public ImportPath(@NotNull FqName fqName2, boolean isAllUnder) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/resolve/ImportPath", "<init>"));
        }
        this(fqName2, isAllUnder, null);
    }

    public ImportPath(@NotNull FqName fqName2, boolean isAllUnder, @Nullable Name alias) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/resolve/ImportPath", "<init>"));
        }
        this.fqName = fqName2;
        this.isAllUnder = isAllUnder;
        this.alias = alias;
    }

    public ImportPath(@NotNull String pathStr) {
        if (pathStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathStr", "kotlin/reflect/jvm/internal/impl/resolve/ImportPath", "<init>"));
        }
        if (pathStr.endsWith(".*")) {
            this.isAllUnder = true;
            this.fqName = new FqName(pathStr.substring(0, pathStr.length() - 2));
        } else {
            this.isAllUnder = false;
            this.fqName = new FqName(pathStr);
        }
        this.alias = null;
    }

    public String getPathStr() {
        return RenderingUtilsKt.render(this.fqName) + (this.isAllUnder ? ".*" : "");
    }

    public String toString() {
        return this.getPathStr() + (this.alias != null ? " as " + this.alias.asString() : "");
    }

    @NotNull
    public FqName fqnPart() {
        FqName fqName2 = this.fqName;
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/ImportPath", "fqnPart"));
        }
        return fqName2;
    }

    @Nullable
    public Name getAlias() {
        return this.alias;
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public boolean isAllUnder() {
        return this.isAllUnder;
    }

    @Nullable
    public Name getImportedName() {
        if (!this.isAllUnder()) {
            return this.alias != null ? this.alias : this.fqName.shortName();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportPath path = (ImportPath)o;
        if (this.isAllUnder != path.isAllUnder) {
            return false;
        }
        if (this.alias != null ? !this.alias.equals(path.alias) : path.alias != null) {
            return false;
        }
        return this.fqName.equals(path.fqName);
    }

    public int hashCode() {
        int result = this.fqName.hashCode();
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        result = 31 * result + (this.isAllUnder ? 1 : 0);
        return result;
    }
}

