/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.MapsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.SetsKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedType;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.ConstraintContext;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.ConstraintSystemImpl;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.TypeBounds;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.TypeBoundsImpl;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.TypeBoundsKt;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.constraintPosition.CompoundConstraintPosition;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.ApproximationBounds;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.annotations.NotNull;

public final class ConstraintIncorporationKt {
    /*
     * WARNING - void declaration
     */
    public static final void incorporateBound(ConstraintSystemImpl $receiver, @NotNull TypeBounds.Bound newBound) {
        void $receiver2;
        KotlinType constrainingType;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)newBound, (String)"newBound");
        TypeParameterDescriptor typeVariable = newBound.getTypeVariable();
        TypeBoundsImpl typeBounds = $receiver.getTypeBounds(typeVariable);
        IntRange intRange = CollectionsKt.getIndices((Collection)typeBounds.getBounds());
        int n2 = ((Number)intRange.getStart()).intValue();
        int n3 = ((Number)intRange.getEnd()).intValue();
        if (n2 <= n3) {
            while (true) {
                void oldBoundIndex;
                TypeBounds.Bound bound = (TypeBounds.Bound)((ArrayList)typeBounds.getBounds()).get((int)oldBoundIndex);
                Intrinsics.checkExpressionValueIsNotNull((Object)bound, (String)"typeBounds.bounds[oldBoundIndex]");
                ConstraintIncorporationKt.addConstraintFromBounds($receiver, bound, newBound);
                if (oldBoundIndex == n3) break;
                ++oldBoundIndex;
            }
        }
        List<TypeBounds.Bound> boundsUsedIn = $receiver.getBoundsUsedIn(typeVariable);
        IntRange intRange2 = CollectionsKt.getIndices((Collection)boundsUsedIn);
        n3 = ((Number)intRange2.getStart()).intValue();
        if (n3 <= (n = ((Number)intRange2.getEnd()).intValue())) {
            while (true) {
                void index;
                TypeBounds.Bound boundUsedIn = boundsUsedIn.get((int)index);
                ConstraintIncorporationKt.generateNewBound($receiver, boundUsedIn, newBound);
                if (index == n) break;
                ++index;
            }
        }
        if ($receiver.isMyTypeVariable(constrainingType = newBound.getConstrainingType())) {
            ConstraintContext context = new ConstraintContext(newBound.getPosition(), newBound.getDerivedFrom(), false, 4, null);
            TypeParameterDescriptor typeParameterDescriptor = $receiver.getMyTypeVariable(constrainingType);
            if (typeParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            $receiver.addBound(typeParameterDescriptor, $receiver.getCorrespondingType(typeVariable), TypeBoundsKt.reverse(newBound.getKind()), context);
            return;
        }
        Iterable context = ConstraintSystemImpl.getNestedTypeVariables$default($receiver, constrainingType, false, 1);
        for (Object element : $receiver2) {
            int n4;
            TypeParameterDescriptor it = (TypeParameterDescriptor)element;
            Collection boundsForNestedVariable = $receiver.getTypeBounds(it).getBounds();
            IntRange intRange3 = CollectionsKt.getIndices((Collection)boundsForNestedVariable);
            int n5 = ((Number)intRange3.getStart()).intValue();
            if (n5 > (n4 = ((Number)intRange3.getEnd()).intValue())) continue;
            while (true) {
                void index;
                TypeBounds.Bound bound = (TypeBounds.Bound)((ArrayList)boundsForNestedVariable).get((int)index);
                Intrinsics.checkExpressionValueIsNotNull((Object)bound, (String)"boundsForNestedVariable[index]");
                ConstraintIncorporationKt.generateNewBound($receiver, newBound, bound);
                if (index == n4) break;
                ++index;
            }
        }
    }

    private static final void addConstraintFromBounds(ConstraintSystemImpl $receiver, TypeBounds.Bound old, TypeBounds.Bound bound) {
        Enum $receiver2;
        if (Intrinsics.areEqual((Object)old, (Object)bound)) {
            return;
        }
        KotlinType oldType = old.getConstrainingType();
        KotlinType newType = bound.getConstrainingType();
        ConstraintContext context = new ConstraintContext(new CompoundConstraintPosition(old.getPosition(), bound.getPosition()), SetsKt.plus(old.getDerivedFrom(), (Iterable)bound.getDerivedFrom()), false, 4, null);
        Enum enum_ = old.getKind();
        int n = $receiver2.ordinal();
        $receiver2 = bound.getKind();
        int n2 = n;
        int n3 = $receiver2.ordinal();
        if (n2 < n3) {
            $receiver.addConstraint(ConstraintSystemImpl.ConstraintKind.SUB_TYPE, oldType, newType, context);
        } else {
            $receiver2 = old.getKind();
            int n4 = $receiver2.ordinal();
            $receiver2 = bound.getKind();
            n2 = n4;
            n3 = $receiver2.ordinal();
            if (n2 > n3) {
                $receiver.addConstraint(ConstraintSystemImpl.ConstraintKind.SUB_TYPE, newType, oldType, context);
            } else if (Intrinsics.areEqual((Object)((Object)old.getKind()), (Object)((Object)bound.getKind())) && Intrinsics.areEqual((Object)((Object)old.getKind()), (Object)((Object)TypeBounds.BoundKind.EXACT_BOUND))) {
                $receiver.addConstraint(ConstraintSystemImpl.ConstraintKind.EQUAL, oldType, newType, context);
            }
        }
    }

    private static final void generateNewBound(ConstraintSystemImpl $receiver, TypeBounds.Bound bound, TypeBounds.Bound substitution) {
        KotlinType kotlinType;
        TypeBounds.BoundKind boundKind = substitution.getKind();
        if (Intrinsics.areEqual((Object)((Object)boundKind), (Object)((Object)TypeBounds.BoundKind.EXACT_BOUND))) {
            kotlinType = substitution.getConstrainingType();
        } else if (Intrinsics.areEqual((Object)((Object)boundKind), (Object)((Object)TypeBounds.BoundKind.UPPER_BOUND))) {
            kotlinType = new CapturedType(new TypeProjectionImpl(Variance.OUT_VARIANCE, substitution.getConstrainingType()));
        } else if (Intrinsics.areEqual((Object)((Object)boundKind), (Object)((Object)TypeBounds.BoundKind.LOWER_BOUND))) {
            kotlinType = new CapturedType(new TypeProjectionImpl(Variance.IN_VARIANCE, substitution.getConstrainingType()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KotlinType substitutedType = kotlinType;
        TypeProjectionImpl newTypeProjection = new TypeProjectionImpl(substitutedType);
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(MapsKt.mapOf((Pair)TuplesKt.to((Object)substitution.getTypeVariable().getTypeConstructor(), (Object)newTypeProjection)));
        KotlinType kotlinType2 = substitutor2.substitute(bound.getConstrainingType(), Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType type2 = kotlinType2;
        CompoundConstraintPosition position = new CompoundConstraintPosition(bound.getPosition(), substitution.getPosition());
        Function2<KotlinType, TypeBounds.BoundKind, Unit> addNewBound$ = new Function2<KotlinType, TypeBounds.BoundKind, Unit>($receiver, bound, substitution, position){
            final /* synthetic */ ConstraintSystemImpl receiver$0;
            final /* synthetic */ TypeBounds.Bound $bound;
            final /* synthetic */ TypeBounds.Bound $substitution;
            final /* synthetic */ CompoundConstraintPosition $position;

            public final void invoke(@NotNull KotlinType newConstrainingType, @NotNull TypeBounds.BoundKind newBoundKind) {
                Intrinsics.checkParameterIsNotNull((Object)newConstrainingType, (String)"newConstrainingType");
                Intrinsics.checkParameterIsNotNull((Object)((Object)newBoundKind), (String)"newBoundKind");
                List<TypeParameterDescriptor> nestedTypeVariables = this.receiver$0.getNestedTypeVariables(newConstrainingType, false);
                if (nestedTypeVariables.contains(this.$bound.getTypeVariable())) {
                    return;
                }
                HashSet<TypeParameterDescriptor> derivedFrom = new HashSet<TypeParameterDescriptor>(SetsKt.plus(this.$bound.getDerivedFrom(), (Iterable)this.$substitution.getDerivedFrom()));
                if (derivedFrom.contains(this.$substitution.getTypeVariable())) {
                    return;
                }
                derivedFrom.add(this.$substitution.getTypeVariable());
                this.receiver$0.addBound(this.$bound.getTypeVariable(), newConstrainingType, newBoundKind, new ConstraintContext(this.$position, derivedFrom, false, 4, null));
            }
            {
                this.receiver$0 = constraintSystemImpl;
                this.$bound = bound;
                this.$substitution = bound2;
                this.$position = compoundConstraintPosition;
                super(2);
            }
        };
        if (Intrinsics.areEqual((Object)((Object)substitution.getKind()), (Object)((Object)TypeBounds.BoundKind.EXACT_BOUND))) {
            KotlinType kotlinType3 = type2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"type");
            addNewBound$.invoke(kotlinType3, bound.getKind());
            return;
        }
        KotlinType kotlinType4 = type2;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"type");
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType4);
        Function1<KotlinType, Boolean> containsConstrainingTypeWithoutProjection$ = new Function1<KotlinType, Boolean>(substitution){
            final /* synthetic */ TypeBounds.Bound $substitution;

            public final boolean invoke(KotlinType $receiver) {
                boolean bl;
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Iterable $receiver2 = TypeUtilsKt.getNestedArguments($receiver);
                    for (T element : $receiver2) {
                        TypeProjection it = (TypeProjection)element;
                        if (!(Intrinsics.areEqual((Object)it.getType().getConstructor(), (Object)this.$substitution.getConstrainingType().getConstructor()) && Intrinsics.areEqual((Object)((Object)it.getProjectionKind()), (Object)((Object)Variance.INVARIANT)))) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$substitution = bound;
                super(1);
            }
        };
        if (containsConstrainingTypeWithoutProjection$.invoke(approximationBounds.getUpper()) && Intrinsics.areEqual((Object)((Object)bound.getKind()), (Object)((Object)TypeBounds.BoundKind.LOWER_BOUND)) ^ true) {
            addNewBound$.invoke(approximationBounds.getUpper(), TypeBounds.BoundKind.UPPER_BOUND);
        }
        if (containsConstrainingTypeWithoutProjection$.invoke(approximationBounds.getLower()) && Intrinsics.areEqual((Object)((Object)bound.getKind()), (Object)((Object)TypeBounds.BoundKind.UPPER_BOUND)) ^ true) {
            addNewBound$.invoke(approximationBounds.getLower(), TypeBounds.BoundKind.LOWER_BOUND);
        }
    }
}

