/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public final class AnnotationsForResolveKt {
    private static final FqName NO_INFER_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.NoInfer");
    private static final FqName EXACT_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.Exact");
    private static final FqName LOW_PRIORITY_IN_OVERLOAD_RESOLUTION_FQ_NAME = new FqName("kotlin.internal.LowPriorityInOverloadResolution");
    private static final FqName ONLY_INPUT_TYPES_FQ_NAME = new FqName("kotlin.internal.OnlyInputTypes");

    public static final boolean hasNoInferAnnotation(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getAnnotations().hasAnnotation(NO_INFER_ANNOTATION_FQ_NAME);
    }

    public static final boolean hasExactAnnotation(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getAnnotations().hasAnnotation(EXACT_ANNOTATION_FQ_NAME);
    }

    public static final boolean hasInternalAnnotationForResolve(Annotations $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.hasAnnotation(NO_INFER_ANNOTATION_FQ_NAME) || $receiver.hasAnnotation(EXACT_ANNOTATION_FQ_NAME);
    }

    public static final boolean isInternalAnnotationForResolve(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver, (Object)NO_INFER_ANNOTATION_FQ_NAME) || Intrinsics.areEqual((Object)$receiver, (Object)EXACT_ANNOTATION_FQ_NAME);
    }

    public static final boolean hasLowPriorityInOverloadResolution(CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getAnnotations().hasAnnotation(LOW_PRIORITY_IN_OVERLOAD_RESOLUTION_FQ_NAME);
    }

    public static final boolean hasOnlyInputTypesAnnotation(TypeParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getAnnotations().hasAnnotation(ONLY_INPUT_TYPES_FQ_NAME);
    }
}

