/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaClassDataFinder
implements ClassDataFinder {
    private final KotlinClassFinder kotlinClassFinder;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.kotlinClassFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        boolean value2 = Intrinsics.areEqual((Object)kotlinJvmBinaryClass2.getClassId(), (Object)classId);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "Class with incorrect id found: expected " + classId + ", actual " + kotlinJvmBinaryClass2.getClassId();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        String[] stringArray = this.deserializedDescriptorResolver.readData(kotlinJvmBinaryClass2, DeserializedDescriptorResolver.KOTLIN_CLASS);
        if (stringArray == null) {
            return null;
        }
        String[] data = stringArray;
        String[] stringArray2 = kotlinJvmBinaryClass2.getClassHeader().getStrings();
        if (stringArray2 == null) {
            stringArray2 = (String[])PreconditionsKt.error((Object)("String table not found in " + kotlinJvmBinaryClass2));
        }
        String[] strings = stringArray2;
        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"data");
        ClassData classData = JvmProtoBufUtil.readClassDataFrom(data, strings);
        return new ClassDataWithSource(classData, new KotlinJvmBinarySourceElement(kotlinJvmBinaryClass2));
    }

    public JavaClassDataFinder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull((Object)deserializedDescriptorResolver, (String)"deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }
}

