/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import org.jetbrains.annotations.NotNull;

public final class CompanionObjectMapping {
    private final LinkedHashSet<ClassDescriptor> classes;
    private final KotlinBuiltIns builtIns;

    @NotNull
    public final Set<ClassDescriptor> allClassesWithIntrinsicCompanions() {
        Set<ClassDescriptor> set = Collections.unmodifiableSet((Set)this.classes);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.unmodifiableSet(classes)");
        return set;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasMappingToObject(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        if (!DescriptorUtils.isCompanionObject(classDescriptor)) return false;
        Iterable iterable = this.classes;
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"classDescriptor.getContainingDeclaration()");
        if (!CollectionsKt.containsAny((Iterable)iterable, (Object)declarationDescriptor)) return false;
        return true;
    }

    public CompanionObjectMapping(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        this.builtIns = builtIns;
        this.classes = SetsKt.linkedSetOf((Object[])new ClassDescriptor[0]);
        for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
            ClassDescriptor classDescriptor = this.builtIns.getPrimitiveClassDescriptor(type2);
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"builtIns.getPrimitiveClassDescriptor(type)");
            this.classes.add(classDescriptor);
        }
        ClassDescriptor classDescriptor = this.builtIns.getString();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"builtIns.getString()");
        this.classes.add(classDescriptor);
        ClassDescriptor classDescriptor2 = this.builtIns.getEnum();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"builtIns.getEnum()");
        this.classes.add(classDescriptor2);
    }
}

