/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuiltinSpecialProperties {
    private static final Map<FqName, ? extends Name> PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP;
    private static final Map<Name, ? extends List<? extends Name>> GETTER_JVM_NAME_TO_PROPERTIES_SHORT_NAME_MAP;
    private static final Set<? extends FqName> FQ_NAMES;
    @NotNull
    public static final Set<? extends Name> SHORT_NAMES;
    public static final BuiltinSpecialProperties INSTANCE;
    public static final BuiltinSpecialProperties INSTANCE$;

    @NotNull
    public final Set<Name> getSHORT_NAMES$kotlin_core() {
        return SHORT_NAMES;
    }

    public final boolean hasBuiltinSpecialPropertyFqName(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)callableMemberDescriptor, (String)"callableMemberDescriptor");
        if (SHORT_NAMES.contains(callableMemberDescriptor.getName()) ^ true) {
            return false;
        }
        return this.hasBuiltinSpecialPropertyFqNameImpl(callableMemberDescriptor);
    }

    public final boolean hasBuiltinSpecialPropertyFqNameImpl(CallableMemberDescriptor $receiver) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if (CollectionsKt.containsAny((Iterable)FQ_NAMES, (Object)SpecialBuiltinMembers.access$fqNameOrNull($receiver))) {
                return true;
            }
            if (!SpecialBuiltinMembers.access$isFromBuiltins($receiver)) {
                return false;
            }
            Iterable $receiver2 = $receiver.getOverriddenDescriptors();
            for (Object element : $receiver2) {
                CallableMemberDescriptor it;
                CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"it");
                if (!INSTANCE.hasBuiltinSpecialPropertyFqName(callableMemberDescriptor)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<Name> getPropertyNameCandidatesBySpecialGetterName(@NotNull Name name1) {
        Intrinsics.checkParameterIsNotNull((Object)name1, (String)"name1");
        List list = GETTER_JVM_NAME_TO_PROPERTIES_SHORT_NAME_MAP.get(name1);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final String getBuiltinSpecialPropertyGetterName(CallableMemberDescriptor $receiver) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean value2 = SpecialBuiltinMembers.access$isFromBuiltins($receiver);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "This method is defined only for builtin members, but " + $receiver + " found";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        CallableMemberDescriptor callableMemberDescriptor = SpecialBuiltinMembers.access$firstOverridden(SpecialBuiltinMembers.access$getPropertyIfAccessor$p($receiver), (Function1<? super CallableMemberDescriptor, ? extends Boolean>)((Function1)getBuiltinSpecialPropertyGetterName.descriptor.1.INSTANCE));
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor descriptor2 = callableMemberDescriptor;
        Name name = PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP.get(DescriptorUtilsKt.getFqNameSafe(descriptor2));
        return name != null ? name.asString() : null;
    }

    static {
        new BuiltinSpecialProperties();
    }

    /*
     * WARNING - void declaration
     */
    private BuiltinSpecialProperties() {
        void var3_3;
        void $receiver;
        INSTANCE = this;
        INSTANCE$ = this;
        PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)new FqName("kotlin.Enum.name"), (Object)Name.identifier("name")), TuplesKt.to((Object)new FqName("kotlin.Enum.ordinal"), (Object)Name.identifier("ordinal")), TuplesKt.to((Object)new FqName("kotlin.Collection.size"), (Object)Name.identifier("size")), TuplesKt.to((Object)new FqName("kotlin.Map.size"), (Object)Name.identifier("size")), TuplesKt.to((Object)new FqName("kotlin.CharSequence.length"), (Object)Name.identifier("length")), TuplesKt.to((Object)new FqName("kotlin.Map.keys"), (Object)Name.identifier("keySet")), TuplesKt.to((Object)new FqName("kotlin.Map.values"), (Object)Name.identifier("values")), TuplesKt.to((Object)new FqName("kotlin.Map.entries"), (Object)Name.identifier("entrySet"))});
        GETTER_JVM_NAME_TO_PROPERTIES_SHORT_NAME_MAP = SpecialBuiltinMembers.access$getInversedShortNamesMap(PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP);
        Object $receiver2 = PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP;
        FQ_NAMES = $receiver2.keySet();
        $receiver2 = FQ_NAMES;
        Object $i$f$keySet = $receiver2;
        Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            FqName fqName2 = (FqName)item;
            Collection collection = destination;
            Name name = it.shortName();
            collection.add(name);
        }
        SHORT_NAMES = CollectionsKt.toSet((Iterable)((List)var3_3));
    }
}

