/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.jvm;

import kotlin.StringsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.annotations.NotNull;

public final class ClassMapperLite {
    public static final ClassMapperLite INSTANCE;
    public static final ClassMapperLite INSTANCE$;

    @JvmStatic
    @NotNull
    public static final String mapClass(@NotNull ClassId classId) {
        ClassId javaClassId;
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        String internalName = StringsKt.replace$default((String)classId.asString(), (char)'.', (char)'$', (boolean)false, (int)4);
        String simpleName = StringsKt.removePrefix((String)internalName, (CharSequence)"kotlin/");
        if (Intrinsics.areEqual((Object)simpleName, (Object)internalName) ^ true) {
            JvmPrimitiveType[] jvmPrimitiveTypeArray = JvmPrimitiveType.values();
            for (int i = 0; i < jvmPrimitiveTypeArray.length; ++i) {
                JvmPrimitiveType jvmPrimitive = jvmPrimitiveTypeArray[i];
                PrimitiveType primitiveType = jvmPrimitive.getPrimitiveType();
                if (Intrinsics.areEqual((Object)simpleName, (Object)primitiveType.getTypeName().asString())) {
                    String string = jvmPrimitive.getDesc();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jvmPrimitive.desc");
                    return string;
                }
                if (!Intrinsics.areEqual((Object)simpleName, (Object)primitiveType.getArrayTypeName().asString())) continue;
                return "[" + jvmPrimitive.getDesc();
            }
            if (Intrinsics.areEqual((Object)simpleName, (Object)KotlinBuiltIns.FQ_NAMES.unit.shortName().asString())) {
                return "V";
            }
        }
        if ((javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(classId.asSingleFqName().toUnsafe())) != null) {
            return "L" + StringsKt.replace$default((String)javaClassId.asString(), (char)'.', (char)'$', (boolean)false, (int)4) + ";";
        }
        return "L" + internalName + ";";
    }

    static {
        new ClassMapperLite();
    }

    private ClassMapperLite() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

