/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import kotlin.PreconditionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import org.jetbrains.annotations.NotNull;

public final class VisibilityUtilKt {
    @NotNull
    public static final CallableMemberDescriptor findMemberWithMaxVisibility(@NotNull Collection<? extends CallableMemberDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        PreconditionsKt.assert((boolean)CollectionsKt.isNotEmpty(descriptors));
        CallableMemberDescriptor descriptor2 = null;
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            if (descriptor2 == null) {
                descriptor2 = callableMemberDescriptor;
                continue;
            }
            Integer result = Visibilities.compare(descriptor2.getVisibility(), callableMemberDescriptor.getVisibility());
            if (result == null || ((Number)result).intValue() >= 0) continue;
            descriptor2 = callableMemberDescriptor;
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor2;
        if (callableMemberDescriptor == null) {
            Intrinsics.throwNpe();
        }
        return callableMemberDescriptor;
    }
}

