/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class AnnotationDeserializer {
    private final ConstantValueFactory factory;
    private final ModuleDescriptor module;

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        ConstructorDescriptor constructor;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        ClassId classId = nameResolver.getClassId(proto.getId());
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(proto.id)");
        ClassDescriptor annotationClass = this.resolveClass(classId);
        Map arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass) && (constructor = (ConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)annotationClass.getConstructors())) != null) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Pair<ValueParameterDescriptor, ConstantValue<?>> pair;
            ProtoBuf.Annotation.Argument it;
            LinkedHashMap linkedHashMap;
            Iterable $receiver$iv;
            Iterable iterable = constructor.getValueParameters();
            float capacity$iv22 = (float)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10) / 0.75f + 1.0f;
            Object result$iv = new LinkedHashMap(Math.max((int)capacity$iv22, 16));
            for (Object element$iv : $receiver$iv) {
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv;
                linkedHashMap = result$iv;
                pair = it.getName();
                linkedHashMap.put(pair, element$iv);
            }
            Map parameterByName = (Map)result$iv;
            $receiver$iv = proto.getArgumentList();
            Iterable capacity$iv22 = $receiver$iv;
            result$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (ProtoBuf.Annotation.Argument)item$iv$iv;
                linkedHashMap = destination$iv$iv;
                ProtoBuf.Annotation.Argument argument = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)argument, (String)"it");
                pair = this.resolveArgument(argument, parameterByName, nameResolver);
                linkedHashMap.add(pair);
            }
            arguments2 = MapsKt.toMap((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<ValueParameterDescriptor, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(nameResolver.getName(proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.getType()");
        ProtoBuf.Annotation.Argument.Value value = proto.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"proto.getValue()");
        return new Pair((Object)parameter, this.resolveValue(kotlinType, value, nameResolver));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = this.factory.createByteValue((byte)value.getIntValue());
                break;
            }
            case 2: {
                v1 = this.factory.createCharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                v1 = this.factory.createShortValue((short)value.getIntValue());
                break;
            }
            case 4: {
                v1 = this.factory.createIntValue((int)value.getIntValue());
                break;
            }
            case 5: {
                v1 = this.factory.createLongValue(value.getIntValue());
                break;
            }
            case 6: {
                v1 = this.factory.createFloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                v1 = this.factory.createDoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                v1 = this.factory.createBooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                v2 = nameResolver.getString(value.getStringValue());
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"nameResolver.getString(value.getStringValue())");
                v1 = this.factory.createStringValue(v2);
                break;
            }
            case 10: {
                v1 = (ConstantValue)PreconditionsKt.error((Object)("Class literal annotation arguments are not supported yet (" + nameResolver.getClassId(value.getClassId()) + ")"));
                break;
            }
            case 11: {
                v3 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"nameResolver.getClassId(value.getClassId())");
                v4 = nameResolver.getName(value.getEnumValueId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"nameResolver.getName(value.getEnumValueId())");
                v1 = this.resolveEnumValue(v3, v4);
                break;
            }
            case 12: {
                v5 = value.getAnnotation();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"value.getAnnotation()");
                v1 = new AnnotationValue(this.deserializeAnnotation(v5, nameResolver));
                break;
            }
            case 13: {
                expectedIsArray = KotlinBuiltIns.isArray(expectedType) != false || KotlinBuiltIns.isPrimitiveArray(expectedType) != false;
                arrayElements = value.getArrayElementList();
                if (CollectionsKt.isNotEmpty((Collection)arrayElements)) {
                    v6 = (ProtoBuf.Annotation.Argument.Value)CollectionsKt.first(arrayElements);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"arrayElements.first()");
                    actualElementType = this.resolveArrayElementType(v6, nameResolver);
                    v7 = this.getBuiltIns().getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(actualElementType);
                    if (v7 == null) {
                        v7 = this.getBuiltIns().getArrayType(Variance.INVARIANT, actualElementType);
                    }
                } else if (expectedIsArray) {
                    v7 = expectedType;
                } else {
                    v8 = this.getBuiltIns().getArrayType(Variance.INVARIANT, this.getBuiltIns().getAnyType());
                    v7 = v8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"builtIns.getArrayType(Va\u2026T, builtIns.getAnyType())");
                }
                actualArrayType = v7;
                v9 = this.getBuiltIns();
                if (expectedIsArray) {
                    v10 = expectedType;
                } else {
                    v11 = actualArrayType;
                    v10 = v11;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"actualArrayType");
                }
                expectedElementType = v9.getArrayElementType(v10);
                var8_8 = arrayElements;
                var9_9 = this.factory;
                var10_10 = $receiver$iv;
                var11_11 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var14_14 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    var15_15 = destination$iv$iv;
                    v12 = expectedElementType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"expectedElementType");
                    v13 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"it");
                    var16_16 = this.resolveValue(v12, (ProtoBuf.Annotation.Argument.Value)v13, nameResolver);
                    var15_15.add(var16_16);
                }
                var15_15 = (List)destination$iv$iv;
                v14 = actualArrayType;
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"actualArrayType");
                v1 = var9_9.createArrayValue(var15_15, v14);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = result = (ConstantValue)PreconditionsKt.error((Object)("Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ")"));
            }
        }
        if (TypeUtilsKt.isSubtypeOf(result.getType(), expectedType)) {
            return result;
        }
        return this.factory.createErrorValue("Unexpected argument value");
    }

    private final ConstantValue<?> resolveEnumValue(ClassId enumClassId, Name enumEntryName) {
        ClassifierDescriptor enumEntry;
        ClassDescriptor enumClass = this.resolveClass(enumClassId);
        if (Intrinsics.areEqual((Object)((Object)enumClass.getKind()), (Object)((Object)ClassKind.ENUM_CLASS)) && (enumEntry = enumClass.getUnsubstitutedInnerClassesScope().getContributedClassifier(enumEntryName, NoLookupLocation.FROM_DESERIALIZATION)) instanceof ClassDescriptor) {
            return this.factory.createEnumValue((ClassDescriptor)enumEntry);
        }
        return this.factory.createErrorValue("Unresolved enum entry: " + enumClassId + "." + enumEntryName);
    }

    /*
     * Unable to fully structure code
     */
    private final KotlinType resolveArrayElementType(ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        receiver$iv = this.getBuiltIns();
        $receiver = receiver$iv;
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
            case 1: {
                v1 = $receiver.getByteType();
                v2 = v1;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"getByteType()");
                break;
            }
            case 2: {
                v3 = $receiver.getCharType();
                v2 = v3;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"getCharType()");
                break;
            }
            case 3: {
                v4 = $receiver.getShortType();
                v2 = v4;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"getShortType()");
                break;
            }
            case 4: {
                v5 = $receiver.getIntType();
                v2 = v5;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"getIntType()");
                break;
            }
            case 5: {
                v6 = $receiver.getLongType();
                v2 = v6;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"getLongType()");
                break;
            }
            case 6: {
                v7 = $receiver.getFloatType();
                v2 = v7;
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"getFloatType()");
                break;
            }
            case 7: {
                v8 = $receiver.getDoubleType();
                v2 = v8;
                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"getDoubleType()");
                break;
            }
            case 8: {
                v9 = $receiver.getBooleanType();
                v2 = v9;
                Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"getBooleanType()");
                break;
            }
            case 9: {
                v10 = $receiver.getStringType();
                v2 = v10;
                Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"getStringType()");
                break;
            }
            case 10: {
                v2 = (KotlinType)PreconditionsKt.error((Object)"Arrays of class literals are not supported yet");
                break;
            }
            case 11: {
                v11 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"nameResolver.getClassId(value.getClassId())");
                v12 = this.resolveClass(v11).getDefaultType();
                v2 = v12;
                Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"resolveClass(nameResolve\u2026ssId())).getDefaultType()");
                break;
            }
            case 12: {
                v13 = nameResolver.getClassId(value.getAnnotation().getId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"nameResolver.getClassId(\u2026.getAnnotation().getId())");
                v14 = this.resolveClass(v13).getDefaultType();
                v2 = v14;
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"resolveClass(nameResolve\u2026etId())).getDefaultType()");
                break;
            }
            case 13: {
                v2 = (KotlinType)PreconditionsKt.error((Object)"Array of arrays is impossible");
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v2 = (KotlinType)PreconditionsKt.error((Object)("Unknown type: " + value.getType()));
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"when (value.getType()) {\u2026pe()}\")\n                }");
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"with(builtIns) {\n       \u2026          }\n            }");
        return v2;
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(this.module, classId);
        if (classDescriptor == null) {
            ClassDescriptor classDescriptor2 = ErrorUtils.createErrorClass(classId.asSingleFqName().asString());
            classDescriptor = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"ErrorUtils.createErrorCl\u2026ingleFqName().asString())");
        }
        return classDescriptor;
    }

    public AnnotationDeserializer(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.module = module;
        this.factory = new ConstantValueFactory(this.getBuiltIns());
    }
}

