/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class FlexibleTypesKt {
    public static final boolean isFlexible(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getCapability(Flexibility.class) != null;
    }

    @NotNull
    public static final Flexibility flexibility(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility == null) {
            Intrinsics.throwNpe();
        }
        return flexibility;
    }

    public static final boolean isNullabilityFlexible(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility == null) {
            return false;
        }
        Flexibility flexibility2 = flexibility;
        return TypeUtils.isNullableType(flexibility2.getLowerBound()) != TypeUtils.isNullableType(flexibility2.getUpperBound());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KotlinType singleBestRepresentative(Collection<? extends KotlinType> $receiver) {
        KotlinType kotlinType;
        block4: {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Iterable<KotlinType> $receiver$iv = $receiver;
            if ($receiver$iv.size() == 1) {
                return (KotlinType)CollectionsKt.first((Iterable)$receiver);
            }
            $receiver$iv = $receiver;
            Iterator<KotlinType> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                KotlinType element$iv;
                block3: {
                    void $receiver$iv2;
                    KotlinType candidate = element$iv = iterator2.next();
                    Iterable iterable = $receiver;
                    for (Object element$iv2 : $receiver$iv2) {
                        KotlinType other = (KotlinType)element$iv2;
                        if (Intrinsics.areEqual((Object)candidate, (Object)other) || KotlinTypeChecker.ERROR_TYPES_ARE_EQUAL_TO_ANYTHING.equalTypes(candidate, other)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (!bl) continue;
                kotlinType = element$iv;
                break block4;
            }
            kotlinType = null;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final TypeProjection singleBestRepresentative(Collection<? extends TypeProjection> $receiver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object object;
        void var8_8;
        Iterable destination$iv$iv2;
        void $receiver$iv$iv2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Collection<? extends TypeProjection> $receiver$iv = $receiver;
        if ($receiver$iv.size() == 1) {
            return (TypeProjection)CollectionsKt.first((Iterable)$receiver);
        }
        Iterable $receiver$iv2 = $receiver;
        Iterable iterable = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            var8_8 = destination$iv$iv2;
            object = it.getProjectionKind();
            var8_8.add(object);
        }
        Set projectionKinds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        $receiver$iv2 = projectionKinds;
        if ($receiver$iv2.size() != 1) {
            return null;
        }
        Iterable $receiver$iv3 = $receiver;
        destination$iv$iv2 = $receiver$iv3;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeProjection $i$a$1 = (TypeProjection)item$iv$iv;
            var8_8 = destination$iv$iv;
            object = it.getType();
            var8_8.add(object);
        }
        KotlinType bestType = FlexibleTypesKt.singleBestRepresentative((List)destination$iv$iv);
        if (bestType == null) {
            return null;
        }
        return new TypeProjectionImpl((Variance)((Object)CollectionsKt.single((Iterable)projectionKinds)), bestType);
    }

    @NotNull
    public static final KotlinType lowerIfFlexible(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FlexibleTypesKt.isFlexible($receiver) ? FlexibleTypesKt.flexibility($receiver).getLowerBound() : $receiver;
    }

    @NotNull
    public static final KotlinType upperIfFlexible(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FlexibleTypesKt.isFlexible($receiver) ? FlexibleTypesKt.flexibility($receiver).getUpperBound() : $receiver;
    }
}

