/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithDifferentJvmName;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaCallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckingProcedure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JvmName(name="SpecialBuiltinMembers")
public final class SpecialBuiltinMembers {
    @Nullable
    public static final <T extends CallableMemberDescriptor> T getOverriddenBuiltinWithDifferentJvmName(T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (BuiltinMethodsWithDifferentJvmName.INSTANCE.getORIGINAL_SHORT_NAMES().contains($receiver.getName()) ^ true && BuiltinSpecialProperties.INSTANCE.getSHORT_NAMES$kotlin_core().contains(DescriptorUtilsKt.getPropertyIfAccessor($receiver).getName()) ^ true) {
            return (T)((CallableMemberDescriptor)null);
        }
        T t = $receiver;
        return (T)(t instanceof PropertyDescriptor || t instanceof PropertyAccessorDescriptor ? DescriptorUtilsKt.firstOverridden($receiver, (Function1<? super CallableMemberDescriptor, Boolean>)((Function1)getOverriddenBuiltinWithDifferentJvmName.1.INSTANCE)) : DescriptorUtilsKt.firstOverridden($receiver, (Function1<? super CallableMemberDescriptor, Boolean>)((Function1)getOverriddenBuiltinWithDifferentJvmName.2.INSTANCE)));
    }

    public static final boolean doesOverrideBuiltinWithDifferentJvmName(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName($receiver) != null;
    }

    @Nullable
    public static final <T extends CallableMemberDescriptor> T getOverriddenSpecialBuiltin(T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        T t = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName($receiver);
        if (t != null) {
            T $receiver$iv = t;
            T it = $receiver$iv;
            return it;
        }
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters($receiver.getName())) {
            return (T)((CallableMemberDescriptor)null);
        }
        return (T)DescriptorUtilsKt.firstOverridden($receiver, (Function1<? super CallableMemberDescriptor, Boolean>)((Function1)getOverriddenSpecialBuiltin.2.INSTANCE));
    }

    @Nullable
    public static final <T extends CallableMemberDescriptor> T getOverriddenBuiltinReflectingJvmDescriptor(T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        T t = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName($receiver);
        if (t != null) {
            T $receiver$iv = t;
            T it = $receiver$iv;
            return it;
        }
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters($receiver.getName())) {
            return (T)((CallableMemberDescriptor)null);
        }
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtilsKt.firstOverridden($receiver, (Function1<? super CallableMemberDescriptor, Boolean>)((Function1)getOverriddenBuiltinReflectingJvmDescriptor.2.INSTANCE));
        return (T)(callableMemberDescriptor != null ? callableMemberDescriptor.getOriginal() : null);
    }

    @Nullable
    public static final String getJvmMethodNameIfSpecial(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        String string;
        CallableMemberDescriptor overriddenBuiltin;
        CallableMemberDescriptor callableMemberDescriptor2;
        Intrinsics.checkParameterIsNotNull((Object)callableMemberDescriptor, (String)"callableMemberDescriptor");
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor).getName(), (Object)DescriptorUtils.ENUM_VALUES)) {
            DeclarationDescriptor containingDeclaration = callableMemberDescriptor.getContainingDeclaration();
            if (callableMemberDescriptor instanceof PropertyAccessorDescriptor && containingDeclaration instanceof ClassDescriptor && Intrinsics.areEqual((Object)((Object)((ClassDescriptor)containingDeclaration).getKind()), (Object)((Object)ClassKind.ENUM_CLASS))) {
                return DescriptorUtils.ENUM_VALUES.asString();
            }
        }
        if ((callableMemberDescriptor2 = SpecialBuiltinMembers.getOverriddenBuiltinThatAffectsJvmName(callableMemberDescriptor)) == null || (callableMemberDescriptor2 = DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor2)) == null) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor3 = overriddenBuiltin = callableMemberDescriptor2;
        if (callableMemberDescriptor3 instanceof PropertyDescriptor) {
            string = BuiltinSpecialProperties.INSTANCE.getBuiltinSpecialPropertyGetterName(overriddenBuiltin);
        } else {
            Name name = BuiltinMethodsWithDifferentJvmName.INSTANCE.getJvmName(overriddenBuiltin);
            string = name != null ? name.asString() : null;
        }
        return string;
    }

    private static final CallableMemberDescriptor getOverriddenBuiltinThatAffectsJvmName(CallableMemberDescriptor callableMemberDescriptor) {
        CallableMemberDescriptor callableMemberDescriptor2 = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName(callableMemberDescriptor);
        if (callableMemberDescriptor2 == null) {
            return null;
        }
        CallableMemberDescriptor overriddenBuiltin = callableMemberDescriptor2;
        if (SpecialBuiltinMembers.isFromBuiltins(callableMemberDescriptor)) {
            return overriddenBuiltin;
        }
        return null;
    }

    public static final boolean hasRealKotlinSuperClassWithOverrideOf(ClassDescriptor $receiver, @NotNull CallableDescriptor specialCallableDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)specialCallableDescriptor, (String)"specialCallableDescriptor");
        DeclarationDescriptor declarationDescriptor = specialCallableDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        KotlinType builtinContainerDefaultType = ((ClassDescriptor)declarationDescriptor).getDefaultType();
        ClassDescriptor superClassDescriptor = DescriptorUtils.getSuperClassDescriptor($receiver);
        while (superClassDescriptor != null) {
            if (!(superClassDescriptor instanceof JavaClassDescriptor)) {
                boolean doesOverrideBuiltinDeclaration;
                boolean bl = doesOverrideBuiltinDeclaration = TypeCheckingProcedure.findCorrespondingSupertype(superClassDescriptor.getDefaultType(), builtinContainerDefaultType) != null;
                if (doesOverrideBuiltinDeclaration) {
                    PackageFragmentDescriptor containingPackageFragment = DescriptorUtils.getParentOfType(superClassDescriptor, PackageFragmentDescriptor.class);
                    return containingPackageFragment != DescriptorUtilsKt.getBuiltIns(superClassDescriptor).getBuiltInsPackageFragment();
                }
            }
            superClassDescriptor = DescriptorUtils.getSuperClassDescriptor(superClassDescriptor);
        }
        return false;
    }

    public static final boolean isFromJava(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtilsKt.getPropertyIfAccessor($receiver) instanceof JavaCallableMemberDescriptor && DescriptorUtilsKt.getPropertyIfAccessor($receiver).getContainingDeclaration() instanceof JavaClassDescriptor;
    }

    public static final boolean isFromBuiltins(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FqName fqName2 = DescriptorUtilsKt.fqNameOrNull(DescriptorUtilsKt.getPropertyIfAccessor($receiver));
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return fqName3.toUnsafe().startsWith(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME) && Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule($receiver), (Object)DescriptorUtilsKt.getBuiltIns($receiver).getBuiltInsModule());
    }

    public static final boolean isFromJavaOrBuiltins(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SpecialBuiltinMembers.isFromJava($receiver) || SpecialBuiltinMembers.isFromBuiltins($receiver);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Name, List<Name>> getInversedShortNamesMap(Map<FqName, Name> $receiver) {
        void var3_3;
        Object list$iv$iv;
        Collection $receiver$iv$iv$iv;
        Name key$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = $receiver;
        $receiver$iv = $receiver$iv.entrySet();
        Object $i$f$entrySet = $receiver$iv;
        Map map$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            Map.Entry it = (Map.Entry)element$iv$iv;
            key$iv$iv = (Name)it.getValue();
            Map map2 = map$iv$iv;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = map$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap($receiver$iv.size());
        iterator2 = MapsKt.iterator((Map)$receiver$iv$iv);
        while (iterator2.hasNext()) {
            void destination$iv$iv2;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            Map.Entry e$iv$iv;
            Map.Entry entry = e$iv$iv = (Map.Entry)iterator2.next();
            Iterable $i$a$1 = (Iterable)entry.getValue();
            key$iv$iv = $receiver$iv2;
            $receiver$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                list$iv$iv = (Map.Entry)item$iv$iv;
                void var13_13 = destination$iv$iv2;
                Name name = ((FqName)it.getKey()).shortName();
                var13_13.add(name);
            }
            List newValue$iv$iv = (List)destination$iv$iv2;
            destination$iv$iv.put(e$iv$iv.getKey(), newValue$iv$iv);
        }
        return var3_3;
    }

    @NotNull
    public static final /* synthetic */ Map access$getInversedShortNamesMap(Map $receiver) {
        return SpecialBuiltinMembers.getInversedShortNamesMap($receiver);
    }
}

