/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProtoContainer {
    @Nullable
    private final ProtoBuf.Class classProto;
    @Nullable
    private final FqName packageFqName;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;

    @NotNull
    public final FqName getFqName() {
        FqName fqName2 = this.packageFqName;
        if (fqName2 == null) {
            ProtoBuf.Class clazz = this.classProto;
            if (clazz == null) {
                Intrinsics.throwNpe();
            }
            FqName fqName3 = this.nameResolver.getClassId(clazz.getFqName()).asSingleFqName();
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"nameResolver.getClassId(\u2026qName()).asSingleFqName()");
        }
        return fqName2;
    }

    @Nullable
    public final ProtoBuf.Class getClassProto() {
        return this.classProto;
    }

    @Nullable
    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    public ProtoContainer(@Nullable ProtoBuf.Class classProto, @Nullable FqName packageFqName, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        this.classProto = classProto;
        this.packageFqName = packageFqName;
        this.nameResolver = nameResolver;
        this.typeTable = typeTable;
        PreconditionsKt.assert((boolean)(this.classProto != null ^ this.packageFqName != null));
    }

    @Nullable
    public final ProtoBuf.Class component1() {
        return this.classProto;
    }

    @Nullable
    public final FqName component2() {
        return this.packageFqName;
    }

    @NotNull
    public final NameResolver component3() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable component4() {
        return this.typeTable;
    }

    @NotNull
    public final ProtoContainer copy(@Nullable ProtoBuf.Class classProto, @Nullable FqName packageFqName, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        return new ProtoContainer(classProto, packageFqName, nameResolver, typeTable);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ProtoContainer copy$default(ProtoContainer protoContainer, ProtoBuf.Class clazz, FqName fqName2, NameResolver nameResolver, TypeTable typeTable, int n) {
        if ((n & 1) != 0) {
            clazz = protoContainer.classProto;
        }
        if ((n & 2) != 0) {
            fqName2 = protoContainer.packageFqName;
        }
        if ((n & 4) != 0) {
            nameResolver = protoContainer.nameResolver;
        }
        if ((n & 8) != 0) {
            typeTable = protoContainer.typeTable;
        }
        return protoContainer.copy(clazz, fqName2, nameResolver, typeTable);
    }

    public String toString() {
        return "ProtoContainer(classProto=" + this.classProto + ", packageFqName=" + this.packageFqName + ", nameResolver=" + this.nameResolver + ", typeTable=" + this.typeTable + ")";
    }

    public int hashCode() {
        ProtoBuf.Class clazz = this.classProto;
        FqName fqName2 = this.packageFqName;
        NameResolver nameResolver = this.nameResolver;
        TypeTable typeTable = this.typeTable;
        return (((clazz != null ? clazz.hashCode() : 0) * 31 + (fqName2 != null ? ((Object)fqName2).hashCode() : 0)) * 31 + (nameResolver != null ? nameResolver.hashCode() : 0)) * 31 + (typeTable != null ? typeTable.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ProtoContainer)) break block3;
                ProtoContainer protoContainer = (ProtoContainer)object;
                if (!Intrinsics.areEqual((Object)this.classProto, (Object)protoContainer.classProto) || !Intrinsics.areEqual((Object)this.packageFqName, (Object)protoContainer.packageFqName) || !Intrinsics.areEqual((Object)this.nameResolver, (Object)protoContainer.nameResolver) || !Intrinsics.areEqual((Object)this.typeTable, (Object)protoContainer.typeTable)) break block3;
            }
            return true;
        }
        return false;
    }
}

