/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.ClassMemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.MemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.MemberIndexKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaField;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMethod;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMemberIndex
implements MemberIndex {
    private final Function1<JavaMethod, Boolean> methodFilter;
    private final Map<Name, List<JavaMethod>> methods;
    private final Map<Name, JavaField> fields;
    @NotNull
    private final JavaClass jClass;
    @NotNull
    private final Function1<JavaMember, Boolean> memberFilter;

    @Override
    @NotNull
    public Collection<JavaMethod> findMethodsByName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        List<JavaMethod> list = this.methods.get(name);
        return list != null ? (Collection)list : (Collection)CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<Name> getMethodNames(@NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull(nameFilter, (String)"nameFilter");
        return MemberIndexKt.access$getAllMemberNames(this.jClass, this.methodFilter, getMethodNames.1.INSTANCE);
    }

    @Override
    @Nullable
    public JavaField findFieldByName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.fields.get(name);
    }

    @Override
    @NotNull
    public Collection<Name> getAllFieldNames() {
        return MemberIndexKt.access$getAllMemberNames(this.jClass, this.memberFilter, getAllFieldNames.1.INSTANCE);
    }

    @NotNull
    public final JavaClass getJClass() {
        return this.jClass;
    }

    @NotNull
    public final Function1<JavaMember, Boolean> getMemberFilter() {
        return this.memberFilter;
    }

    /*
     * WARNING - void declaration
     */
    public ClassMemberIndex(@NotNull JavaClass jClass, @NotNull Function1<? super JavaMember, Boolean> memberFilter) {
        Map destination$iv$iv;
        JavaMember m;
        Sequence $receiver$iv$iv;
        Sequence $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)jClass, (String)"jClass");
        Intrinsics.checkParameterIsNotNull(memberFilter, (String)"memberFilter");
        this.jClass = jClass;
        this.memberFilter = memberFilter;
        this.methodFilter = (Function1)new Function1<JavaMethod, Boolean>(this){
            final /* synthetic */ ClassMemberIndex this$0;

            public final boolean invoke(@NotNull JavaMethod m) {
                Intrinsics.checkParameterIsNotNull((Object)m, (String)"m");
                return (Boolean)this.this$0.getMemberFilter().invoke((Object)m) != false && !DescriptorResolverUtils.isObjectMethodInInterface(m);
            }
            {
                this.this$0 = classMemberIndex;
                super(1);
            }
        };
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.jClass.getMethods()), this.methodFilter);
        ClassMemberIndex classMemberIndex = this;
        void var5_5 = $receiver$iv;
        Map map2 = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            void key$iv$iv$iv;
            void $receiver$iv$iv$iv;
            m = (JavaMethod)element$iv$iv;
            Name key$iv$iv = m.getName();
            void var11_11 = destination$iv$iv;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map map3 = destination$iv$iv;
        classMemberIndex.methods = map3;
        $receiver$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.jClass.getFields()), this.memberFilter);
        classMemberIndex = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            m = (JavaField)element$iv$iv;
            map3 = destination$iv$iv;
            Name name = m.getName();
            map3.put(name, element$iv$iv);
        }
        classMemberIndex.fields = map3 = destination$iv$iv;
    }
}

