/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.jvm;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.PackageData;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.BitEncoding;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmProtoBufUtil {
    @NotNull
    private static final ExtensionRegistryLite EXTENSION_REGISTRY;
    public static final JvmProtoBufUtil INSTANCE;

    @NotNull
    public final ExtensionRegistryLite getEXTENSION_REGISTRY() {
        return EXTENSION_REGISTRY;
    }

    @JvmStatic
    @NotNull
    public static final ClassData readClassDataFrom(@NotNull String[] data, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        byte[] byArray = BitEncoding.decodeBytes(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BitEncoding.decodeBytes(data)");
        return JvmProtoBufUtil.readClassDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final ClassData readClassDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom(input, EXTENSION_REGISTRY);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringTableTypes, (String)"JvmProtoBuf.StringTableT\u2026nput, EXTENSION_REGISTRY)");
        JvmNameResolver nameResolver = new JvmNameResolver(stringTableTypes, strings);
        ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(input, EXTENSION_REGISTRY);
        NameResolver nameResolver2 = nameResolver;
        ProtoBuf.Class clazz = classProto;
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"classProto");
        return new ClassData(nameResolver2, clazz);
    }

    @JvmStatic
    @NotNull
    public static final PackageData readPackageDataFrom(@NotNull String[] data, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        byte[] byArray = BitEncoding.decodeBytes(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BitEncoding.decodeBytes(data)");
        return JvmProtoBufUtil.readPackageDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final PackageData readPackageDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom(input, EXTENSION_REGISTRY);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringTableTypes, (String)"JvmProtoBuf.StringTableT\u2026nput, EXTENSION_REGISTRY)");
        JvmNameResolver nameResolver = new JvmNameResolver(stringTableTypes, strings);
        ProtoBuf.Package packageProto = ProtoBuf.Package.parseFrom(input, EXTENSION_REGISTRY);
        NameResolver nameResolver2 = nameResolver;
        ProtoBuf.Package package_ = packageProto;
        Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"packageProto");
        return new PackageData(nameResolver2, package_);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getJvmMethodSignature(@NotNull ProtoBuf.Function proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        JvmProtoBuf.JvmMethodSignature signature = proto.hasExtension(JvmProtoBuf.methodSignature) ? proto.getExtension(JvmProtoBuf.methodSignature) : (JvmProtoBuf.JvmMethodSignature)null;
        int n = name = signature != null && signature.hasName() ? signature.getName() : proto.getName();
        if (signature != null && signature.hasDesc()) {
            string = nameResolver.getString(signature.getDesc());
        } else {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Object object;
            void destination$iv$iv2;
            Iterable $receiver$iv$iv2;
            void $receiver$iv2;
            Iterable iterable = proto.getValueParameterList();
            Collection collection = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.singletonOrEmptyList(ProtoTypeTableUtilKt.receiverType(proto, typeTable));
            void var8_8 = $receiver$iv2;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item$iv$iv;
                object = destination$iv$iv2;
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)it, typeTable);
                object.add(type2);
            }
            object = (List)destination$iv$iv2;
            List parameterTypes = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
            $receiver$iv$iv2 = parameterTypes;
            destination$iv$iv2 = $receiver$iv;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ProtoBuf.Type $i$a$1 = (ProtoBuf.Type)item$iv$iv;
                collection = destination$iv$iv;
                if (INSTANCE.mapTypeDefault((ProtoBuf.Type)it, nameResolver) == null) {
                    return null;
                }
                collection.add(object);
            }
            List parametersDesc = (List)destination$iv$iv;
            String string2 = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string2 == null) {
                return null;
            }
            String returnTypeDesc = string2;
            string = CollectionsKt.joinToString$default((Iterable)parametersDesc, (CharSequence)"", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null) + returnTypeDesc;
        }
        String desc = string;
        return nameResolver.getString(name) + desc;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getJvmConstructorSignature(@NotNull ProtoBuf.Constructor proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        JvmProtoBuf.JvmMethodSignature signature;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature = proto.hasExtension(JvmProtoBuf.constructorSignature) ? proto.getExtension(JvmProtoBuf.constructorSignature) : (JvmProtoBuf.JvmMethodSignature)null;
        if (signature != null && signature.hasDesc()) {
            string = nameResolver.getString(signature.getDesc());
        } else {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = proto.getValueParameterList();
            void var6_6 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string2;
                void it;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item$iv$iv;
                void var11_11 = destination$iv$iv;
                if (INSTANCE.mapTypeDefault(ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)it, typeTable), nameResolver) == null) {
                    return null;
                }
                var11_11.add(string2);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", (CharSequence)"(", (CharSequence)")V", (int)0, null, null, (int)56, null);
        }
        String desc = string;
        return "<init>" + desc;
    }

    @Nullable
    public final PropertySignature getJvmFieldSignature(@NotNull ProtoBuf.Property proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        if (!proto.hasExtension(JvmProtoBuf.propertySignature)) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature signature = proto.getExtension(JvmProtoBuf.propertySignature);
        JvmProtoBuf.JvmFieldSignature field = signature.hasField() ? signature.getField() : (JvmProtoBuf.JvmFieldSignature)null;
        int n = name = field != null && field.hasName() ? field.getName() : proto.getName();
        if (field != null && field.hasDesc()) {
            string = nameResolver.getString(field.getDesc());
        } else {
            string = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string == null) {
                return null;
            }
        }
        String desc = string;
        String string2 = nameResolver.getString(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"nameResolver.getString(name)");
        String string3 = desc;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"desc");
        return new PropertySignature(string2, string3);
    }

    private final String mapTypeDefault(ProtoBuf.Type type2, NameResolver nameResolver) {
        String string;
        if (type2.hasClassName()) {
            ClassId classId = nameResolver.getClassId(type2.getClassName());
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(type.className)");
            string = ClassMapperLite.mapClass(classId);
        } else {
            string = null;
        }
        return string;
    }

    private JvmProtoBufUtil() {
        INSTANCE = this;
        JvmProtoBufUtil $receiver$iv = this;
        JvmProtoBufUtil $receiver = $receiver$iv;
        ExtensionRegistryLite registry = ExtensionRegistryLite.newInstance();
        JvmProtoBuf.registerAllExtensions(registry);
        ExtensionRegistryLite extensionRegistryLite = registry;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionRegistryLite, (String)"registry");
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionRegistryLite, (String)"run {\n        val regist\u2026y)\n        registry\n    }");
        EXTENSION_REGISTRY = extensionRegistryLite;
    }

    static {
        new JvmProtoBufUtil();
    }

    public static final class PropertySignature {
        @NotNull
        private final String name;
        @NotNull
        private final String desc;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDesc() {
            return this.desc;
        }

        public PropertySignature(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            this.name = name;
            this.desc = desc;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.desc;
        }

        @NotNull
        public final PropertySignature copy(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            return new PropertySignature(name, desc);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertySignature copy$default(PropertySignature propertySignature, String string, String string2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                string = propertySignature.name;
            }
            if ((n & 2) != 0) {
                string2 = propertySignature.desc;
            }
            return propertySignature.copy(string, string2);
        }

        public String toString() {
            return "PropertySignature(name=" + this.name + ", desc=" + this.desc + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.desc;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PropertySignature)) break block3;
                    PropertySignature propertySignature = (PropertySignature)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)propertySignature.name) || !Intrinsics.areEqual((Object)this.desc, (Object)propertySignature.desc)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

