/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.SerializedResourcePaths;
import kotlin.reflect.jvm.internal.impl.serialization.builtins.BuiltInsProtoBuf;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class BuiltInsSerializedResourcePaths
implements SerializedResourcePaths {
    @NotNull
    private static final ExtensionRegistryLite extensionRegistry;
    @NotNull
    private static final String CLASS_METADATA_FILE_EXTENSION = "kotlin_class";
    @NotNull
    private static final String PACKAGE_FILE_EXTENSION = "kotlin_package";
    @NotNull
    private static final String STRING_TABLE_FILE_EXTENSION = "kotlin_string_table";
    @NotNull
    private static final String BUILTINS_FILE_EXTENSION = "kotlin_builtins";
    public static final BuiltInsSerializedResourcePaths INSTANCE;

    @Override
    @NotNull
    public ExtensionRegistryLite getExtensionRegistry() {
        return extensionRegistry;
    }

    @NotNull
    public final String getCLASS_METADATA_FILE_EXTENSION() {
        return CLASS_METADATA_FILE_EXTENSION;
    }

    @NotNull
    public final String getPACKAGE_FILE_EXTENSION() {
        return PACKAGE_FILE_EXTENSION;
    }

    @NotNull
    public final String getSTRING_TABLE_FILE_EXTENSION() {
        return STRING_TABLE_FILE_EXTENSION;
    }

    @NotNull
    public final String getBUILTINS_FILE_EXTENSION() {
        return BUILTINS_FILE_EXTENSION;
    }

    @Override
    @NotNull
    public String getClassMetadataPath(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        StringBuilder stringBuilder = new StringBuilder();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
        return stringBuilder.append(this.packageFqNameToPath(fqName2)).append("/").append(classId.getRelativeClassName().asString()).append(".").append(CLASS_METADATA_FILE_EXTENSION).toString();
    }

    @Override
    @NotNull
    public String getPackageFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + PACKAGE_FILE_EXTENSION;
    }

    @Override
    @NotNull
    public String getStringTableFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + STRING_TABLE_FILE_EXTENSION;
    }

    @NotNull
    public final String getBuiltInsFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + BUILTINS_FILE_EXTENSION;
    }

    private final String packageFqNameToPath(FqName fqName2) {
        return StringsKt.replace$default((String)fqName2.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    private final String shortName(FqName fqName2) {
        String string;
        if (fqName2.isRoot()) {
            string = "default-package";
        } else {
            String string2 = fqName2.shortName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fqName.shortName().asString()");
        }
        return string;
    }

    private BuiltInsSerializedResourcePaths() {
        INSTANCE = this;
        ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionRegistryLite, (String)"ExtensionRegistryLite.newInstance()");
        extensionRegistry = extensionRegistryLite;
        BuiltInsProtoBuf.registerAllExtensions(this.getExtensionRegistry());
        CLASS_METADATA_FILE_EXTENSION = CLASS_METADATA_FILE_EXTENSION;
        PACKAGE_FILE_EXTENSION = PACKAGE_FILE_EXTENSION;
        STRING_TABLE_FILE_EXTENSION = STRING_TABLE_FILE_EXTENSION;
        BUILTINS_FILE_EXTENSION = BUILTINS_FILE_EXTENSION;
    }

    static {
        new BuiltInsSerializedResourcePaths();
    }
}

