/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.components;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaDeprecatedAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaRetentionAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaTargetAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaAnnotationMapper {
    private static final FqName JAVA_TARGET_FQ_NAME;
    private static final FqName JAVA_RETENTION_FQ_NAME;
    private static final FqName JAVA_DEPRECATED_FQ_NAME;
    private static final FqName JAVA_DOCUMENTED_FQ_NAME;
    private static final FqName JAVA_REPEATABLE_FQ_NAME;
    @NotNull
    private static final Name DEPRECATED_ANNOTATION_MESSAGE;
    @NotNull
    private static final Name TARGET_ANNOTATION_ALLOWED_TARGETS;
    private static final Map<FqName, FqName> kotlinToJavaNameMap;
    @NotNull
    private static final Map<FqName, FqName> javaToKotlinNameMap;
    public static final JavaAnnotationMapper INSTANCE;

    @NotNull
    public final Name getDEPRECATED_ANNOTATION_MESSAGE$kotlin_core() {
        return DEPRECATED_ANNOTATION_MESSAGE;
    }

    @NotNull
    public final Name getTARGET_ANNOTATION_ALLOWED_TARGETS$kotlin_core() {
        return TARGET_ANNOTATION_ALLOWED_TARGETS;
    }

    @Nullable
    public final AnnotationDescriptor mapOrResolveJavaAnnotation(@NotNull JavaAnnotation annotation, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        ClassId classId = annotation.getClassId();
        if (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JAVA_TARGET_FQ_NAME))) {
            annotationDescriptor = new JavaTargetAnnotationDescriptor(annotation, c);
        } else if (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JAVA_RETENTION_FQ_NAME))) {
            annotationDescriptor = new JavaRetentionAnnotationDescriptor(annotation, c);
        } else if (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JAVA_REPEATABLE_FQ_NAME))) {
            ClassDescriptor classDescriptor = c.getModule().getBuiltIns().getRepeatableAnnotation();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"c.module.builtIns.repeatableAnnotation");
            annotationDescriptor = new JavaAnnotationDescriptor(c, annotation, classDescriptor);
        } else if (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JAVA_DOCUMENTED_FQ_NAME))) {
            ClassDescriptor classDescriptor = c.getModule().getBuiltIns().getMustBeDocumentedAnnotation();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"c.module.builtIns.mustBeDocumentedAnnotation");
            annotationDescriptor = new JavaAnnotationDescriptor(c, annotation, classDescriptor);
        } else {
            annotationDescriptor = Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JAVA_DEPRECATED_FQ_NAME)) ? (AnnotationDescriptor)null : (AnnotationDescriptor)new LazyJavaAnnotationDescriptor(c, annotation);
        }
        return annotationDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AnnotationDescriptor findMappedJavaAnnotation(@NotNull FqName kotlinName, @NotNull JavaAnnotationOwner annotationOwner, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        Object javaAnnotation;
        Intrinsics.checkParameterIsNotNull((Object)kotlinName, (String)"kotlinName");
        Intrinsics.checkParameterIsNotNull((Object)annotationOwner, (String)"annotationOwner");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        if (Intrinsics.areEqual((Object)kotlinName, (Object)KotlinBuiltIns.FQ_NAMES.deprecated) && ((javaAnnotation = annotationOwner.findAnnotation(JAVA_DEPRECATED_FQ_NAME)) != null || annotationOwner.isDeprecatedInJavaDoc())) {
            return new JavaDeprecatedAnnotationDescriptor((JavaAnnotation)javaAnnotation, c);
        }
        FqName fqName2 = kotlinToJavaNameMap.get(kotlinName);
        if (fqName2 != null) {
            AnnotationDescriptor annotationDescriptor2;
            void $receiver$iv;
            javaAnnotation = fqName2;
            FqName it = (FqName)$receiver$iv;
            JavaAnnotation javaAnnotation2 = annotationOwner.findAnnotation(it);
            if (javaAnnotation2 != null) {
                void $receiver$iv2;
                JavaAnnotation it2;
                JavaAnnotation javaAnnotation3 = javaAnnotation2;
                JavaAnnotation javaAnnotation4 = it2 = (JavaAnnotation)$receiver$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)javaAnnotation4, (String)"it");
                annotationDescriptor2 = INSTANCE.mapOrResolveJavaAnnotation(javaAnnotation4, c);
            } else {
                annotationDescriptor2 = null;
            }
            annotationDescriptor = annotationDescriptor2;
        } else {
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    @NotNull
    public final Map<FqName, FqName> getJavaToKotlinNameMap() {
        return javaToKotlinNameMap;
    }

    private JavaAnnotationMapper() {
        INSTANCE = this;
        JAVA_TARGET_FQ_NAME = new FqName(Target.class.getCanonicalName());
        JAVA_RETENTION_FQ_NAME = new FqName(Retention.class.getCanonicalName());
        JAVA_DEPRECATED_FQ_NAME = new FqName(Deprecated.class.getCanonicalName());
        JAVA_DOCUMENTED_FQ_NAME = new FqName(Documented.class.getCanonicalName());
        JAVA_REPEATABLE_FQ_NAME = new FqName("java.lang.annotation.Repeatable");
        DEPRECATED_ANNOTATION_MESSAGE = Name.identifier("message");
        TARGET_ANNOTATION_ALLOWED_TARGETS = Name.identifier("allowedTargets");
        kotlinToJavaNameMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)KotlinBuiltIns.FQ_NAMES.target, (Object)JAVA_TARGET_FQ_NAME), TuplesKt.to((Object)KotlinBuiltIns.FQ_NAMES.retention, (Object)JAVA_RETENTION_FQ_NAME), TuplesKt.to((Object)KotlinBuiltIns.FQ_NAMES.repeatable, (Object)JAVA_REPEATABLE_FQ_NAME), TuplesKt.to((Object)KotlinBuiltIns.FQ_NAMES.mustBeDocumented, (Object)JAVA_DOCUMENTED_FQ_NAME)});
        javaToKotlinNameMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)JAVA_TARGET_FQ_NAME, (Object)KotlinBuiltIns.FQ_NAMES.target), TuplesKt.to((Object)JAVA_RETENTION_FQ_NAME, (Object)KotlinBuiltIns.FQ_NAMES.retention), TuplesKt.to((Object)JAVA_DEPRECATED_FQ_NAME, (Object)KotlinBuiltIns.FQ_NAMES.deprecated), TuplesKt.to((Object)JAVA_REPEATABLE_FQ_NAME, (Object)KotlinBuiltIns.FQ_NAMES.repeatable), TuplesKt.to((Object)JAVA_DOCUMENTED_FQ_NAME, (Object)KotlinBuiltIns.FQ_NAMES.mustBeDocumented)});
    }

    static {
        new JavaAnnotationMapper();
    }
}

