/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.List;
import kotlin.collections.CharIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.KeywordStringsGenerated;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class RenderingUtilsKt {
    @NotNull
    public static final String qualifiedNameForSourceCode(@NotNull ClassifierDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        String nameString = RenderingUtilsKt.render(descriptor2.getName());
        if (descriptor2 instanceof TypeParameterDescriptor) {
            return nameString;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        String qualifier = RenderingUtilsKt.qualifierName(declarationDescriptor);
        return qualifier != null && Intrinsics.areEqual((Object)qualifier, (Object)"") ^ true ? qualifier + "." + nameString : nameString;
    }

    private static final String qualifierName(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2;
        return declarationDescriptor instanceof ClassDescriptor ? RenderingUtilsKt.qualifiedNameForSourceCode((ClassifierDescriptor)descriptor2) : (declarationDescriptor instanceof PackageFragmentDescriptor ? RenderingUtilsKt.render(((PackageFragmentDescriptor)descriptor2).getFqName().toUnsafe()) : (String)null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String render(Name $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (RenderingUtilsKt.shouldBeEscaped($receiver)) {
            void other$iv;
            void $receiver$iv;
            StringBuilder stringBuilder = new StringBuilder();
            int n = 96;
            String string2 = $receiver.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"asString()");
            String string3 = string2;
            StringBuilder stringBuilder2 = stringBuilder;
            String string4 = String.valueOf((char)$receiver$iv) + (String)other$iv;
            string = stringBuilder2.append(string4).append('`').toString();
        } else {
            String string5 = $receiver.asString();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"asString()");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name $receiver) {
        boolean bl;
        if ($receiver.isSpecial()) {
            return false;
        }
        String string = $receiver.asString();
        if (KeywordStringsGenerated.KEYWORDS.contains(string)) return true;
        CharSequence $receiver$iv = string;
        CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver$iv);
        do {
            if (!charIterator.hasNext()) return false;
            char element$iv = charIterator.nextChar();
            char it = element$iv;
            if (!Character.isLetterOrDigit(it) && it != '_') {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final String render(FqNameUnsafe $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<Name> list = $receiver.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"pathSegments()");
        return RenderingUtilsKt.renderFqName(list);
    }

    @NotNull
    public static final String render(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<Name> list = $receiver.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"pathSegments()");
        return RenderingUtilsKt.renderFqName(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderFqName(@NotNull List<Name> pathSegments) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull(pathSegments, (String)"pathSegments");
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        for (Name element : pathSegments) {
            if ($receiver.length() > 0) {
                $receiver.append(".");
            }
            $receiver.append(RenderingUtilsKt.render(element));
        }
        String string = ((StringBuilder)var1_1).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

