/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CompositeTypeSubstitution
extends TypeSubstitution {
    private final TypeSubstitution first;
    private final TypeSubstitution second;

    @Override
    @Nullable
    public TypeProjection get(@NotNull KotlinType key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        TypeProjection typeProjection = this.first.get(key);
        if (typeProjection == null) {
            return this.second.get(key);
        }
        TypeProjection firstResult = typeProjection;
        return this.second.buildSubstitutor().substitute(firstResult);
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean approximateCapturedTypes() {
        return this.first.approximateCapturedTypes() || this.second.approximateCapturedTypes();
    }

    @Override
    public boolean approximateContravariantCapturedTypes() {
        return this.first.approximateContravariantCapturedTypes() || this.second.approximateContravariantCapturedTypes();
    }

    @Override
    @NotNull
    public Annotations filterAnnotations(@NotNull Annotations annotations2) {
        Intrinsics.checkParameterIsNotNull((Object)annotations2, (String)"annotations");
        return this.second.filterAnnotations(this.first.filterAnnotations(annotations2));
    }

    public CompositeTypeSubstitution(@NotNull TypeSubstitution first, @NotNull TypeSubstitution second) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)second, (String)"second");
        this.first = first;
        this.second = second;
    }
}

