/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.EffectiveVisibilityKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.KotlinRetention;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$WhenMappings;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.reflect.jvm.internal.impl.utils.addToStdlib.AddToStdlibKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorUtilsKt {
    @NotNull
    public static final ClassDescriptor getClassObjectReferenceTarget(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassDescriptor classDescriptor = $receiver.getCompanionObjectDescriptor();
        if (classDescriptor == null) {
            classDescriptor = $receiver;
        }
        return classDescriptor;
    }

    @NotNull
    public static final DeclarationDescriptor getImportableDescriptor(@NotNull DeclarationDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof ConstructorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            declarationDescriptor = declarationDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"containingDeclaration");
        } else if ($receiver instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            declarationDescriptor = declarationDescriptor3;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor3, (String)"correspondingProperty");
        } else {
            declarationDescriptor = $receiver;
        }
        return declarationDescriptor;
    }

    @NotNull
    public static final FqNameUnsafe getFqNameUnsafe(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"DescriptorUtils.getFqName(this)");
        return fqNameUnsafe;
    }

    @NotNull
    public static final FqName getFqNameSafe(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FqName fqName2 = DescriptorUtils.getFqNameSafe($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"DescriptorUtils.getFqNameSafe(this)");
        return fqName2;
    }

    public static final boolean isExtension(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof CallableDescriptor && ((CallableDescriptor)$receiver).getExtensionReceiverParameter() != null;
    }

    @NotNull
    public static final ModuleDescriptor getModule(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"DescriptorUtils.getContainingModule(this)");
        return moduleDescriptor;
    }

    @Nullable
    public static final ClassDescriptor resolveTopLevelClass(@NotNull ModuleDescriptor $receiver, @NotNull FqName topLevelClassFqName, @NotNull LookupLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)topLevelClassFqName, (String)"topLevelClassFqName");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        boolean bl = !topLevelClassFqName.isRoot();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FqName fqName2 = topLevelClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"topLevelClassFqName.parent()");
        MemberScope memberScope2 = $receiver.getPackage(fqName2).getMemberScope();
        Name name = topLevelClassFqName.shortName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"topLevelClassFqName.shortName()");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name, location);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    @NotNull
    public static final ClassId getClassId(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor owner = $receiver.getContainingDeclaration();
        if (owner instanceof PackageFragmentDescriptor) {
            return new ClassId(((PackageFragmentDescriptor)owner).getFqName(), $receiver.getName());
        }
        if (owner instanceof ClassDescriptor) {
            ClassId classId = DescriptorUtilsKt.getClassId((ClassDescriptor)owner).createNestedClassId($receiver.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"owner.classId.createNestedClassId(name)");
            return classId;
        }
        throw (Throwable)new IllegalStateException("Illegal container: " + owner);
    }

    public static final boolean getHasCompanionObject(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getCompanionObjectDescriptor() != null;
    }

    public static final boolean getHasClassValueDescriptor(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtilsKt.getClassValueDescriptor($receiver) != null;
    }

    @Nullable
    public static final ClassDescriptor getClassValueDescriptor(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getKind().isSingleton() ? $receiver : $receiver.getCompanionObjectDescriptor();
    }

    @Nullable
    public static final ClassDescriptor getClassValueTypeDescriptor(@NotNull ClassDescriptor $receiver) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        switch (DescriptorUtilsKt$WhenMappings.$EnumSwitchMapping$0[$receiver.getKind().ordinal()]) {
            case 1: {
                classDescriptor = $receiver;
                break;
            }
            case 2: {
                DeclarationDescriptor container = $receiver.getContainingDeclaration();
                boolean bl = container instanceof ClassDescriptor && Intrinsics.areEqual((Object)((Object)((ClassDescriptor)container).getKind()), (Object)((Object)ClassKind.ENUM_CLASS));
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                DeclarationDescriptor declarationDescriptor = container;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                classDescriptor = (ClassDescriptor)declarationDescriptor;
                break;
            }
            default: {
                classDescriptor = $receiver.getCompanionObjectDescriptor();
            }
        }
        return classDescriptor;
    }

    @Nullable
    public static final KotlinType getClassValueType(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getClassValueTypeDescriptor($receiver);
        return classDescriptor != null ? classDescriptor.getDefaultType() : null;
    }

    public static final boolean isEffectivelyPublicApi(@NotNull DeclarationDescriptorWithVisibility $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return EffectiveVisibilityKt.effectiveVisibility$default($receiver, null, 1, null).getPublicApi();
    }

    public static final boolean isEffectivelyPrivateApi(@NotNull DeclarationDescriptorWithVisibility $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return EffectiveVisibilityKt.effectiveVisibility$default($receiver, null, 1, null).getPrivateApi();
    }

    public static final boolean isInsidePrivateClass(@NotNull DeclarationDescriptor $receiver) {
        ClassDescriptor parent;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        return (parent = (ClassDescriptor)declarationDescriptor) != null && Visibilities.isPrivate(parent.getVisibility());
    }

    @Nullable
    public static final ClassDescriptor getSuperClassNotAny(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        for (KotlinType supertype : $receiver.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor superClassifier;
            if (KotlinBuiltIns.isAnyOrNullableAny(supertype) || !DescriptorUtils.isClassOrEnumClass(superClassifier = supertype.getConstructor().getDeclarationDescriptor())) continue;
            ClassifierDescriptor classifierDescriptor = superClassifier;
            if (classifierDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    @NotNull
    public static final ClassDescriptor getSuperClassOrAny(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny($receiver);
        if (classDescriptor == null) {
            ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns($receiver).getAny();
            classDescriptor = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"builtIns.any");
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConstructorDescriptor> getSecondaryConstructors(@NotNull ClassDescriptor $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Iterable $receiver$iv = $receiver.getConstructors();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ConstructorDescriptor it = (ConstructorDescriptor)element$iv$iv;
            if (it.isPrimary()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final KotlinBuiltIns getBuiltIns(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtilsKt.getModule($receiver).getBuiltIns();
    }

    @Nullable
    public static final DeclarationDescriptor getOwnerForEffectiveDispatchReceiverParameter(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)$receiver).getKind()), (Object)((Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE))) {
            return $receiver.getContainingDeclaration();
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getDispatchReceiverParameter();
        return receiverParameterDescriptor != null ? receiverParameterDescriptor.getContainingDeclaration() : null;
    }

    public static final boolean hasDefaultValue(@NotNull ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DFS.ifAny(CollectionsKt.listOf((Object)$receiver), hasDefaultValue.1.INSTANCE, hasDefaultValue.2.INSTANCE);
    }

    public static final boolean isRepeatableAnnotation(@NotNull Annotated $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.repeatable;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.repeatable");
        return annotations2.findAnnotation(fqName2) != null;
    }

    public static final boolean isDocumentedAnnotation(@NotNull Annotated $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.mustBeDocumented;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.mustBeDocumented");
        return annotations2.findAnnotation(fqName2) != null;
    }

    @Nullable
    public static final KotlinRetention getAnnotationRetention(@NotNull Annotated $receiver) {
        Object v3;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Annotations annotations2 = $receiver.getAnnotations();
            FqName fqName2 = KotlinBuiltIns.FQ_NAMES.retention;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.retention");
            AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor annotationEntryDescriptor = annotationDescriptor;
            Iterable $receiver$iv = annotationEntryDescriptor.getAllValueArguments().entrySet();
            for (Object element$iv : $receiver$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                if (!Intrinsics.areEqual((Object)((ValueParameterDescriptor)it.getKey()).getName().asString(), (Object)"value")) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        Map.Entry entry = v3;
        ConstantValue constantValue = entry != null ? (ConstantValue)entry.getValue() : null;
        if (!(constantValue instanceof EnumValue)) {
            constantValue = null;
        }
        EnumValue enumValue = (EnumValue)constantValue;
        if (enumValue == null) {
            return null;
        }
        EnumValue retentionArgumentValue = enumValue;
        String string = ((ClassDescriptor)retentionArgumentValue.getValue()).getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"retentionArgumentValue.value.name.asString()");
        return KotlinRetention.valueOf(string);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParentsWithSelf(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.generateSequence((Object)$receiver, (Function1)parentsWithSelf.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParents(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.drop(DescriptorUtilsKt.getParentsWithSelf($receiver), (int)1);
    }

    @NotNull
    public static final CallableMemberDescriptor getPropertyIfAccessor(@NotNull CallableMemberDescriptor $receiver) {
        CallableMemberDescriptor callableMemberDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof PropertyAccessorDescriptor) {
            CallableMemberDescriptor callableMemberDescriptor2 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            callableMemberDescriptor = callableMemberDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor2, (String)"correspondingProperty");
        } else {
            callableMemberDescriptor = $receiver;
        }
        return callableMemberDescriptor;
    }

    @Nullable
    public static final FqName fqNameOrNull(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FqNameUnsafe fqNameUnsafe = AddToStdlibKt.check(DescriptorUtilsKt.getFqNameUnsafe($receiver), fqNameOrNull.1.INSTANCE);
        return fqNameUnsafe != null ? fqNameUnsafe.toSafe() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CallableMemberDescriptor firstOverridden(@NotNull CallableMemberDescriptor $receiver, boolean useOriginal, @NotNull Function1<? super CallableMemberDescriptor, Boolean> predicate) {
        void result;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        return (CallableMemberDescriptor)DFS.dfs(CollectionsKt.listOf((Object)$receiver), new DFS.Neighbors<N>(useOriginal){
            final /* synthetic */ boolean $useOriginal;

            @NotNull
            public final Iterable<CallableMemberDescriptor> getNeighbors(CallableMemberDescriptor current) {
                CallableMemberDescriptor descriptor2;
                Object object;
                CallableMemberDescriptor callableMemberDescriptor;
                if (this.$useOriginal) {
                    CallableMemberDescriptor callableMemberDescriptor2 = current;
                    callableMemberDescriptor = callableMemberDescriptor2 != null ? callableMemberDescriptor2.getOriginal() : null;
                } else {
                    callableMemberDescriptor = current;
                }
                return (object = (descriptor2 = callableMemberDescriptor)) != null && (object = object.getOverriddenDescriptors()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
            }
            {
                this.$useOriginal = bl;
            }
        }, new DFS.AbstractNodeHandler<CallableMemberDescriptor, CallableMemberDescriptor>((Ref.ObjectRef)result, predicate){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Function1 $predicate;

            public boolean beforeChildren(@NotNull CallableMemberDescriptor current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                return (CallableMemberDescriptor)this.$result.element == null;
            }

            public void afterChildren(@NotNull CallableMemberDescriptor current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                if ((CallableMemberDescriptor)this.$result.element == null && ((Boolean)this.$predicate.invoke((Object)current)).booleanValue()) {
                    this.$result.element = current;
                }
            }

            @Nullable
            public CallableMemberDescriptor result() {
                return (CallableMemberDescriptor)this.$result.element;
            }
            {
                this.$result = $captured_local_variable$0;
                this.$predicate = $captured_local_variable$1;
            }
        });
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CallableMemberDescriptor firstOverridden$default(CallableMemberDescriptor callableMemberDescriptor, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: firstOverridden");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return DescriptorUtilsKt.firstOverridden(callableMemberDescriptor, bl, (Function1<? super CallableMemberDescriptor, Boolean>)function1);
    }

    public static final void setSingleOverridden(@NotNull CallableMemberDescriptor $receiver, @NotNull CallableMemberDescriptor overridden) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)overridden, (String)"overridden");
        $receiver.setOverriddenDescriptors(CollectionsKt.listOf((Object)overridden));
    }

    @NotNull
    public static final Sequence<CallableMemberDescriptor> overriddenTreeAsSequence(@NotNull CallableMemberDescriptor $receiver, boolean useOriginal) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CallableMemberDescriptor callableMemberDescriptor = useOriginal ? $receiver.getOriginal() : $receiver;
        CallableMemberDescriptor $receiver2 = callableMemberDescriptor;
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new CallableMemberDescriptor[]{$receiver2}), (Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)$receiver2.getOverriddenDescriptors()), (Function1)((Function1)new Function1<CallableMemberDescriptor, Sequence<? extends CallableMemberDescriptor>>(useOriginal){
            final /* synthetic */ boolean $useOriginal$inlined;

            public final Sequence<CallableMemberDescriptor> invoke(CallableMemberDescriptor it) {
                return DescriptorUtilsKt.overriddenTreeAsSequence(it, this.$useOriginal$inlined);
            }
            {
                this.$useOriginal$inlined = bl;
                super(1);
            }
        })));
    }

    @NotNull
    public static final Sequence<CallableDescriptor> overriddenTreeUniqueAsSequence(@NotNull CallableDescriptor $receiver, boolean useOriginal) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        HashSet set = SetsKt.hashSetOf((Object[])new CallableDescriptor[0]);
        Function1<CallableDescriptor, Sequence<? extends CallableDescriptor>> doBuildOverriddenTreeAsSequence$ = new Function1<CallableDescriptor, Sequence<? extends CallableDescriptor>>(useOriginal, set){
            final /* synthetic */ boolean $useOriginal;
            final /* synthetic */ HashSet $set;

            @NotNull
            public final Sequence<CallableDescriptor> invoke(@NotNull CallableDescriptor $receiver) {
                Sequence sequence;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                CallableDescriptor callableDescriptor = this.$useOriginal ? $receiver.getOriginal() : $receiver;
                CallableDescriptor $receiver2 = callableDescriptor;
                if (this.$set.contains($receiver2.getOriginal())) {
                    sequence = SequencesKt.emptySequence();
                } else {
                    Collection collection = this.$set;
                    CallableDescriptor callableDescriptor2 = $receiver2.getOriginal();
                    collection.add(callableDescriptor2);
                    sequence = SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new CallableDescriptor[]{$receiver2}), (Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)$receiver2.getOverriddenDescriptors()), (Function1)((Function1)new Function1<CallableDescriptor, Sequence<? extends CallableDescriptor>>(this){
                        final /* synthetic */ overriddenTreeUniqueAsSequence.1 this$0;

                        public final Sequence<CallableDescriptor> invoke(CallableDescriptor it) {
                            return this.this$0.invoke(it);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    })));
                }
                return sequence;
            }
            {
                this.$useOriginal = bl;
                this.$set = hashSet;
                super(1);
            }
        };
        return doBuildOverriddenTreeAsSequence$.invoke($receiver);
    }
}

