/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolverImpl;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmModuleProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.BinaryModuleData;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ModuleMappingKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.PackageParts;
import kotlin.reflect.jvm.internal.impl.protobuf.ProtocolStringList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    @NotNull
    private final BinaryModuleData moduleData;
    private final String debugName;
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, BinaryModuleData moduleData2, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.moduleData = moduleData2;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        EMPTY = new ModuleMapping(MapsKt.emptyMap(), new BinaryModuleData(CollectionsKt.emptyList()), "EMPTY");
        CORRUPTED = new ModuleMapping(MapsKt.emptyMap(), new BinaryModuleData(CollectionsKt.emptyList()), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull BinaryModuleData moduleData2, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, moduleData2, debugName);
    }

    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping loadModuleMapping(@Nullable byte[] bytes, @NotNull String debugName, boolean skipMetadataVersionCheck, boolean isJvmPackageNameSupported, @NotNull Function1<? super JvmMetadataVersion, Unit> reportIncompatibleVersionError) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Object p1;
            Iterable $receiver$iv2;
            Object packageParts;
            int[] size$iv22;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
            Intrinsics.checkParameterIsNotNull(reportIncompatibleVersionError, (String)"reportIncompatibleVersionError");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int size$iv22 = stream.readInt();
                int[] result$iv = new int[size$iv22];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    int n3;
                    void i$iv;
                    void var12_17 = i$iv;
                    void var25_20 = i$iv++;
                    object = result$iv;
                    object[var25_20] = n3 = stream.readInt();
                }
                size$iv22 = result$iv;
            }
            catch (IOException e) {
                return CORRUPTED;
            }
            int[] versionNumber = size$iv22;
            JvmMetadataVersion version = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (!skipMetadataVersionCheck && !version.isCompatible()) {
                reportIncompatibleVersionError.invoke((Object)version);
                return EMPTY;
            }
            JvmModuleProtoBuf.Module module = JvmModuleProtoBuf.Module.parseFrom(stream);
            if (module == null) {
                return EMPTY;
            }
            JvmModuleProtoBuf.Module moduleProto = module;
            LinkedHashMap result = new LinkedHashMap();
            Iterator<JvmModuleProtoBuf.PackageParts> it = moduleProto.getPackagePartsList().iterator();
            while (it.hasNext()) {
                int index;
                Object object2;
                String key$iv;
                void $receiver$iv222;
                JvmModuleProtoBuf.PackageParts proto;
                JvmModuleProtoBuf.PackageParts packageParts2 = proto = it.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)packageParts2, (String)"proto");
                String packageFqName = packageParts2.getPackageFqName();
                Map map2 = result;
                Intrinsics.checkExpressionValueIsNotNull((Object)packageFqName, (String)"packageFqName");
                Object value$iv = $receiver$iv222.get(key$iv);
                if (value$iv == null) {
                    PackageParts answer$iv = new PackageParts(packageFqName);
                    $receiver$iv222.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                packageParts = (PackageParts)object2;
                boolean $receiver$iv222 = false;
                ProtocolStringList protocolStringList = proto.getShortClassNameList();
                Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList, (String)"proto.shortClassNameList");
                for (String partShortName : (Iterable)protocolStringList) {
                    String string;
                    String facadeShortName;
                    String string2;
                    ProtocolStringList protocolStringList2;
                    Integer multifileFacadeId;
                    List<Integer> list = proto.getMultifileFacadeShortNameIdList();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"proto.multifileFacadeShortNameIdList");
                    Integer n = (Integer)CollectionsKt.getOrNull(list, (int)index);
                    Integer n4 = multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
                    if (multifileFacadeId != null) {
                        Integer n5;
                        Intrinsics.checkExpressionValueIsNotNull((Object)proto.getMultifileFacadeShortNameList(), (String)"proto.multifileFacadeShortNameList");
                        int p12 = ((Number)n5).intValue();
                        string2 = (String)CollectionsKt.getOrNull((List)protocolStringList2, (int)p12);
                    } else {
                        string2 = facadeShortName = null;
                    }
                    if (facadeShortName != null) {
                        ProtocolStringList it2 = protocolStringList2;
                        string = ModuleMappingKt.access$internalNameOf(packageFqName, (String)((Object)it2));
                    } else {
                        string = null;
                    }
                    String facadeInternalName = string;
                    String string3 = partShortName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"partShortName");
                    ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(packageFqName, string3), facadeInternalName);
                    ++index;
                }
                if (!isJvmPackageNameSupported) continue;
                index = 0;
                ProtocolStringList protocolStringList3 = proto.getClassWithJvmPackageNameShortNameList();
                Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList3, (String)"proto.classWithJvmPackageNameShortNameList");
                for (String partShortName : (Iterable)protocolStringList3) {
                    List<Integer> list = proto.getClassWithJvmPackageNamePackageIdList();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"proto.classWithJvmPackageNamePackageIdList");
                    Integer n = (Integer)CollectionsKt.getOrNull(list, (int)index);
                    if (n == null) {
                        List<Integer> list2 = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"proto.classWithJvmPackageNamePackageIdList");
                        n = (Integer)CollectionsKt.lastOrNull(list2);
                    }
                    if (n == null) {
                    } else {
                        int packageId = n;
                        ProtocolStringList protocolStringList4 = moduleProto.getJvmPackageNameList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList4, (String)"moduleProto.jvmPackageNameList");
                        if ((String)CollectionsKt.getOrNull((List)protocolStringList4, (int)packageId) == null) {
                        } else {
                            String jvmPackageName;
                            String string = partShortName;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"partShortName");
                            ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(jvmPackageName, string), null);
                        }
                    }
                    ++index;
                }
            }
            for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getMetadataPartsList()) {
                Object object3;
                packageParts = result;
                JvmModuleProtoBuf.PackageParts packageParts3 = proto;
                Intrinsics.checkExpressionValueIsNotNull((Object)packageParts3, (String)"proto");
                String string = packageParts3.getPackageFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"proto.packageFqName");
                Object key$iv = string;
                Object value$iv = $receiver$iv2.get(key$iv);
                if (value$iv == null) {
                    String string4 = proto.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"proto.packageFqName");
                    PackageParts answer$iv = new PackageParts(string4);
                    $receiver$iv2.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                PackageParts packageParts4 = (PackageParts)object3;
                ProtocolStringList protocolStringList = proto.getShortClassNameList();
                Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList, (String)"proto.shortClassNameList");
                $receiver$iv2 = protocolStringList;
                key$iv = packageParts4;
                for (Object element$iv : $receiver$iv2) {
                    p1 = (String)element$iv;
                    ((PackageParts)key$iv).addMetadataPart((String)p1);
                }
            }
            ProtoBuf.StringTable stringTable = moduleProto.getStringTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)stringTable, (String)"moduleProto.stringTable");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = moduleProto.getQualifiedNameTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedNameTable, (String)"moduleProto.qualifiedNameTable");
            NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
            List<ProtoBuf.Annotation> list = moduleProto.getAnnotationList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"moduleProto.annotationList");
            $receiver$iv2 = $receiver$iv = (Iterable)list;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void proto;
                p1 = (ProtoBuf.Annotation)item$iv$iv;
                object = destination$iv$iv;
                void v24 = proto;
                Intrinsics.checkExpressionValueIsNotNull((Object)v24, (String)"proto");
                String string = nameResolver.getQualifiedClassName(v24.getId());
                object.add(string);
            }
            List annotations2 = (List)destination$iv$iv;
            return new ModuleMapping(result, new BinaryModuleData(annotations2), debugName, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

