/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorEquivalenceForOverrides {
    @NotNull
    public static final DescriptorEquivalenceForOverrides INSTANCE = new DescriptorEquivalenceForOverrides();

    private DescriptorEquivalenceForOverrides() {
    }

    public final boolean areEquivalent(@Nullable DeclarationDescriptor a, @Nullable DeclarationDescriptor b, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects) {
        return a instanceof ClassDescriptor && b instanceof ClassDescriptor ? this.areClassesEquivalent((ClassDescriptor)a, (ClassDescriptor)b) : (a instanceof TypeParameterDescriptor && b instanceof TypeParameterDescriptor ? DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)a, (TypeParameterDescriptor)b, allowCopiesFromTheSameDeclaration, null, 8, null) : (a instanceof CallableDescriptor && b instanceof CallableDescriptor ? DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(this, (CallableDescriptor)a, (CallableDescriptor)b, allowCopiesFromTheSameDeclaration, distinguishExpectsAndNonExpects, false, KotlinTypeRefiner.Default.INSTANCE, 16, null) : (a instanceof PackageFragmentDescriptor && b instanceof PackageFragmentDescriptor ? Intrinsics.areEqual((Object)((PackageFragmentDescriptor)a).getFqName(), (Object)((PackageFragmentDescriptor)b).getFqName()) : Intrinsics.areEqual((Object)a, (Object)b))));
    }

    public static /* synthetic */ boolean areEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return descriptorEquivalenceForOverrides.areEquivalent(declarationDescriptor, declarationDescriptor2, bl, bl2);
    }

    private final boolean areClassesEquivalent(ClassDescriptor a, ClassDescriptor b) {
        return Intrinsics.areEqual((Object)a.getTypeConstructor(), (Object)b.getTypeConstructor());
    }

    @JvmOverloads
    public final boolean areTypeParametersEquivalent(@NotNull TypeParameterDescriptor a, @NotNull TypeParameterDescriptor b, boolean allowCopiesFromTheSameDeclaration, @NotNull Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter(equivalentCallables, (String)"equivalentCallables");
        if (Intrinsics.areEqual((Object)a, (Object)b)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)a.getContainingDeclaration(), (Object)b.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(a, b, equivalentCallables, allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        return a.getIndex() == b.getIndex();
    }

    public static /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = areTypeParametersEquivalent.1.INSTANCE;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, bl, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)function2);
    }

    private final SourceElement singleSource(CallableDescriptor $this$singleSource) {
        DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides = this;
        while (true) {
            if (!($this$singleSource instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)$this$singleSource).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return $this$singleSource.getSource();
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)$this$singleSource).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (callableMemberDescriptor == null) break;
            $this$singleSource = callableMemberDescriptor;
        }
        return null;
    }

    public final boolean areCallableDescriptorsEquivalent(@NotNull CallableDescriptor a, @NotNull CallableDescriptor b, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects, boolean ignoreReturnType, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        if (Intrinsics.areEqual((Object)a, (Object)b)) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)a.getName(), (Object)b.getName())) {
            return false;
        }
        if (distinguishExpectsAndNonExpects && a instanceof MemberDescriptor && b instanceof MemberDescriptor && ((MemberDescriptor)((Object)a)).isExpect() != ((MemberDescriptor)((Object)b)).isExpect()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)a.getContainingDeclaration(), (Object)b.getContainingDeclaration())) {
            if (!allowCopiesFromTheSameDeclaration) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.singleSource(a), (Object)this.singleSource(b))) {
                return false;
            }
        }
        if (DescriptorUtils.isLocal(a) || DescriptorUtils.isLocal(b)) {
            return false;
        }
        if (!this.ownersEquivalent(a, b, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)((Function2)areCallableDescriptorsEquivalent.1.INSTANCE), allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        CallableDescriptor callableDescriptor = b;
        CallableDescriptor callableDescriptor2 = a;
        boolean bl = allowCopiesFromTheSameDeclaration;
        OverridingUtil overridingUtil2 = OverridingUtil.create(kotlinTypeRefiner, new DescriptorEquivalenceForOverrides$$Lambda$0(bl, callableDescriptor2, callableDescriptor));
        Intrinsics.checkNotNullExpressionValue((Object)overridingUtil2, (String)"create(...)");
        OverridingUtil overridingUtil3 = overridingUtil2;
        return overridingUtil3.isOverridableBy(a, b, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE && overridingUtil3.isOverridableBy(b, a, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
    }

    public static /* synthetic */ boolean areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl, boolean bl2, boolean bl3, KotlinTypeRefiner kotlinTypeRefiner, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return descriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent(callableDescriptor, callableDescriptor2, bl, bl2, bl3, kotlinTypeRefiner);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor a, DeclarationDescriptor b, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables, boolean allowCopiesFromTheSameDeclaration) {
        DeclarationDescriptor aOwner = a.getContainingDeclaration();
        DeclarationDescriptor bOwner = b.getContainingDeclaration();
        return aOwner instanceof CallableMemberDescriptor || bOwner instanceof CallableMemberDescriptor ? (Boolean)equivalentCallables.invoke((Object)aOwner, (Object)bOwner) : DescriptorEquivalenceForOverrides.areEquivalent$default(this, aOwner, bOwner, allowCopiesFromTheSameDeclaration, false, 8, null);
    }

    @JvmOverloads
    public final boolean areTypeParametersEquivalent(@NotNull TypeParameterDescriptor a, @NotNull TypeParameterDescriptor b, boolean allowCopiesFromTheSameDeclaration) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, a, b, allowCopiesFromTheSameDeclaration, null, 8, null);
    }

    private static final boolean areCallableDescriptorsEquivalent$lambda$0(boolean $allowCopiesFromTheSameDeclaration, CallableDescriptor $a, CallableDescriptor $b, TypeConstructor c1, TypeConstructor c2) {
        Intrinsics.checkNotNullParameter((Object)$a, (String)"$a");
        Intrinsics.checkNotNullParameter((Object)$b, (String)"$b");
        Intrinsics.checkNotNullParameter((Object)c1, (String)"c1");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
        if (Intrinsics.areEqual((Object)c1, (Object)c2)) {
            return true;
        }
        ClassifierDescriptor d1 = c1.getDeclarationDescriptor();
        ClassifierDescriptor d2 = c2.getDeclarationDescriptor();
        if (!(d1 instanceof TypeParameterDescriptor) || !(d2 instanceof TypeParameterDescriptor)) {
            return false;
        }
        return INSTANCE.areTypeParametersEquivalent((TypeParameterDescriptor)d1, (TypeParameterDescriptor)d2, $allowCopiesFromTheSameDeclaration, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)((Function2)new Function2<DeclarationDescriptor, DeclarationDescriptor, Boolean>($a, $b){
            final /* synthetic */ CallableDescriptor $a;
            final /* synthetic */ CallableDescriptor $b;
            {
                this.$a = $a;
                this.$b = $b;
                super(2);
            }

            public final Boolean invoke(DeclarationDescriptor x, DeclarationDescriptor y) {
                return Intrinsics.areEqual((Object)x, (Object)this.$a) && Intrinsics.areEqual((Object)y, (Object)this.$b);
            }
        }));
    }

    static /* synthetic */ boolean accessor$DescriptorEquivalenceForOverrides$lambda0(boolean bl, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, TypeConstructor typeConstructor2, TypeConstructor typeConstructor3) {
        return DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$lambda$0(bl, callableDescriptor, callableDescriptor2, typeConstructor2, typeConstructor3);
    }
}

