/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.InlineClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.MultiFieldValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\ninlineClassesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inlineClassesUtils.kt\norg/jetbrains/kotlin/resolve/InlineClassesUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1586#2:80\n1661#2,3:81\n1586#2:85\n1661#2,3:86\n1807#2,3:89\n1#3:84\n*S KotlinDebug\n*F\n+ 1 inlineClassesUtils.kt\norg/jetbrains/kotlin/resolve/InlineClassesUtilsKt\n*L\n40#1:80\n40#1:81,3\n52#1:85\n52#1:86,3\n63#1:89,3\n*E\n"})
public final class InlineClassesUtilsKt {
    @NotNull
    private static final FqName JVM_INLINE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmInline");
    @NotNull
    private static final ClassId JVM_INLINE_ANNOTATION_CLASS_ID = ClassId.Companion.topLevel(JVM_INLINE_ANNOTATION_FQ_NAME);
    @NotNull
    private static final FqName JVM_NAME_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmName");

    public static final boolean isInlineClass(@NotNull DeclarationDescriptor $this$isInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClass, (String)"<this>");
        return $this$isInlineClass instanceof ClassDescriptor && ((ClassDescriptor)$this$isInlineClass).getValueClassRepresentation() instanceof InlineClassRepresentation;
    }

    public static final boolean isMultiFieldValueClass(@NotNull DeclarationDescriptor $this$isMultiFieldValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiFieldValueClass, (String)"<this>");
        return $this$isMultiFieldValueClass instanceof ClassDescriptor && ((ClassDescriptor)$this$isMultiFieldValueClass).getValueClassRepresentation() instanceof MultiFieldValueClassRepresentation;
    }

    public static final boolean isValueClass(@NotNull DeclarationDescriptor $this$isValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isValueClass, (String)"<this>");
        return InlineClassesUtilsKt.isInlineClass($this$isValueClass) || InlineClassesUtilsKt.isMultiFieldValueClass($this$isValueClass);
    }

    @Nullable
    public static final KotlinType unsubstitutedUnderlyingType(@NotNull KotlinType $this$unsubstitutedUnderlyingType) {
        Intrinsics.checkNotNullParameter((Object)$this$unsubstitutedUnderlyingType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$unsubstitutedUnderlyingType.getConstructor().getDeclarationDescriptor();
        Object object = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        return object != null && (object = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)object)) != null ? (SimpleType)((InlineClassRepresentation)object).getUnderlyingType() : null;
    }

    public static final boolean isInlineClassType(@NotNull KotlinType $this$isInlineClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClassType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isInlineClassType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? InlineClassesUtilsKt.isInlineClass(classifierDescriptor) : false;
    }

    public static final boolean needsMfvcFlattening(@NotNull KotlinType $this$needsMfvcFlattening) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$needsMfvcFlattening, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$needsMfvcFlattening.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor $this$needsMfvcFlattening_u24lambda_u240 = classifierDescriptor;
            boolean bl2 = false;
            bl = InlineClassesUtilsKt.isMultiFieldValueClass($this$needsMfvcFlattening_u24lambda_u240) && !SimpleClassicTypeSystemContext.INSTANCE.isNullableType($this$needsMfvcFlattening);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnderlyingPropertyOfInlineClass(@NotNull VariableDescriptor $this$isUnderlyingPropertyOfInlineClass) {
        DeclarationDescriptor declarationDescriptor;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isUnderlyingPropertyOfInlineClass, (String)"<this>");
        return $this$isUnderlyingPropertyOfInlineClass.getExtensionReceiverParameter() == null && $this$isUnderlyingPropertyOfInlineClass.getContextReceiverParameters().isEmpty() && Intrinsics.areEqual((Object)((object = (declarationDescriptor = $this$isUnderlyingPropertyOfInlineClass.getContainingDeclaration()) instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null) != null && (object = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)object)) != null ? ((InlineClassRepresentation)object).getUnderlyingPropertyName() : null), (Object)$this$isUnderlyingPropertyOfInlineClass.getName());
    }
}

