/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import jet.Function1;
import jet.Function2;
import jet.JetObject;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage$src$ArraysJVM$97b6f809;
import kotlin.KotlinPackage$src$StringsJVM$fd7fcdbf;
import kotlin.io.IoPackage$appendBytes$1;
import kotlin.io.IoPackage$copyTo$1;
import kotlin.io.IoPackage$readBytes$1;
import kotlin.io.IoPackage$readLines$1;
import kotlin.io.IoPackage$src$JIO$62618497;
import kotlin.io.IoPackage$writeBytes$1;

public final class IoPackage$src$Files$81dbafd0 {
    @JetMethod(returnType="V")
    public static final void recurse(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="block", type="Ljet/Function1<Ljava/io/File;Ljet/Unit;>;") Function1<? super File, ? extends Unit> block) {
        block.invoke((Object)$receiver);
        File[] children = $receiver.listFiles();
        boolean bl = true;
        if (children == null) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                IoPackage$src$Files$81dbafd0.recurse(child, block);
            }
        }
    }

    @JetMethod(flags=17, propertyType="Ljava/io/File;")
    public static final File getDirectory(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver) {
        File file;
        if ($receiver.isDirectory()) {
            file = $receiver;
        } else {
            file = $receiver.getParentFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
        }
        return file;
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public static final String getCanonicalPath(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver) {
        return $receiver.getCanonicalPath();
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public static final String getName(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver) {
        return $receiver.getName();
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public static final String getPath(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver) {
        return $receiver.getPath();
    }

    @JetMethod(flags=17, propertyType="Ljava/lang/String;")
    public static final String getExtension(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver) {
        String text = IoPackage$src$Files$81dbafd0.getName($receiver);
        int idx = KotlinPackage$src$StringsJVM$fd7fcdbf.lastIndexOf(text, '.');
        return idx >= 0 ? KotlinPackage$src$StringsJVM$fd7fcdbf.substring(text, idx + 1) : "";
    }

    @JetMethod(returnType="Z")
    public static final boolean isDescendant(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="file", type="Ljava/io/File;") File file) {
        return KotlinPackage$src$StringsJVM$fd7fcdbf.startsWith(IoPackage$src$Files$81dbafd0.getCanonicalPath(IoPackage$src$Files$81dbafd0.getDirectory(file)), IoPackage$src$Files$81dbafd0.getCanonicalPath(IoPackage$src$Files$81dbafd0.getDirectory($receiver)));
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String relativePath(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="descendant", type="Ljava/io/File;") File descendant) {
        String string;
        String prefix = IoPackage$src$Files$81dbafd0.getCanonicalPath(IoPackage$src$Files$81dbafd0.getDirectory($receiver));
        String answer = IoPackage$src$Files$81dbafd0.getCanonicalPath(descendant);
        if (KotlinPackage$src$StringsJVM$fd7fcdbf.startsWith(answer, prefix)) {
            int prefixSize = KotlinPackage$src$StringsJVM$fd7fcdbf.getSize(prefix);
            string = KotlinPackage$src$StringsJVM$fd7fcdbf.getSize(answer) > prefixSize ? KotlinPackage$src$StringsJVM$fd7fcdbf.substring(answer, prefixSize + 1) : "";
        } else {
            string = answer;
        }
        return string;
    }

    @JetMethod(returnType="Ljava/io/FileReader;")
    public static final FileReader reader(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver) {
        return new FileReader($receiver);
    }

    @JetMethod(returnType="[B")
    public static final byte[] readBytes(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver) {
        return (byte[])IoPackage$src$JIO$62618497.use((Closeable)new FileInputStream($receiver), (Function1)new IoPackage$readBytes$1($receiver));
    }

    @JetMethod(returnType="V")
    public static final void writeBytes(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="data", type="[B") byte[] data2) {
        IoPackage$src$JIO$62618497.use((Closeable)new FileOutputStream($receiver), (Function1)new IoPackage$writeBytes$1(data2));
    }

    @JetMethod(returnType="V")
    public static final void appendBytes(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="data", type="[B") byte[] data2) {
        IoPackage$src$JIO$62618497.use((Closeable)new FileOutputStream($receiver, true), (Function1)new IoPackage$appendBytes$1(data2));
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String readText(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="encoding", hasDefaultValue=true, type="Ljava/lang/String;") String encoding) {
        return KotlinPackage$src$ArraysJVM$97b6f809.toString(IoPackage$src$Files$81dbafd0.readBytes($receiver), encoding);
    }

    public static /* synthetic */ String readText$default(File file, String string, int n) {
        if ((n & 1) != 0) {
            string = Charset.defaultCharset().name();
        }
        return IoPackage$src$Files$81dbafd0.readText(file, string);
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String readText(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="encoding", type="Ljava/nio/charset/Charset;") Charset encoding) {
        return KotlinPackage$src$ArraysJVM$97b6f809.toString(IoPackage$src$Files$81dbafd0.readBytes($receiver), encoding);
    }

    @JetMethod(returnType="V")
    public static final void writeText(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="text", type="Ljava/lang/String;") String text, @JetValueParameter(name="encoding", hasDefaultValue=true, type="Ljava/lang/String;") String encoding) {
        IoPackage$src$Files$81dbafd0.writeBytes($receiver, KotlinPackage$src$StringsJVM$fd7fcdbf.toByteArray(text, encoding));
    }

    public static /* synthetic */ void writeText$default(File file, String string, String string2, int n) {
        if ((n & 2) != 0) {
            string2 = Charset.defaultCharset().name();
        }
        IoPackage$src$Files$81dbafd0.writeText(file, string, string2);
    }

    @JetMethod(returnType="V")
    public static final void writeText(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="text", type="Ljava/lang/String;") String text, @JetValueParameter(name="encoding", type="Ljava/nio/charset/Charset;") Charset encoding) {
        IoPackage$src$Files$81dbafd0.writeBytes($receiver, KotlinPackage$src$StringsJVM$fd7fcdbf.toByteArray(text, encoding));
    }

    @JetMethod(returnType="V")
    public static final void appendText(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="text", type="Ljava/lang/String;") String text, @JetValueParameter(name="encoding", type="Ljava/nio/charset/Charset;") Charset encoding) {
        IoPackage$src$Files$81dbafd0.appendBytes($receiver, KotlinPackage$src$StringsJVM$fd7fcdbf.toByteArray(text, encoding));
    }

    @JetMethod(returnType="V")
    public static final void appendText(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="text", type="Ljava/lang/String;") String text, @JetValueParameter(name="encoding", hasDefaultValue=true, type="Ljava/lang/String;") String encoding) {
        IoPackage$src$Files$81dbafd0.appendBytes($receiver, KotlinPackage$src$StringsJVM$fd7fcdbf.toByteArray(text, encoding));
    }

    public static /* synthetic */ void appendText$default(File file, String string, String string2, int n) {
        if ((n & 2) != 0) {
            string2 = Charset.defaultCharset().name();
        }
        IoPackage$src$Files$81dbafd0.appendText(file, string, string2);
    }

    @JetMethod(returnType="J")
    public static final long copyTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="file", type="Ljava/io/File;") File file, @JetValueParameter(name="bufferSize", hasDefaultValue=true, type="I") int bufferSize) {
        IoPackage$src$Files$81dbafd0.getDirectory(file).mkdirs();
        FileInputStream input = new FileInputStream($receiver);
        return ((Number)IoPackage$src$JIO$62618497.use((Closeable)input, (Function1)new IoPackage$copyTo$1(input, file, bufferSize))).longValue();
    }

    public static /* synthetic */ long copyTo$default(File file, File file2, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = IoPackage$src$JIO$62618497.defaultBufferSize;
        }
        return IoPackage$src$Files$81dbafd0.copyTo(file, file2, n);
    }

    @JetMethod(flags=16, returnType="V")
    public static final void forEachBlock(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="closure", type="Ljet/Function2<[BLjava/lang/Integer;Ljet/Unit;>;") Function2<? super byte[], ? super Integer, ? extends Unit> closure) {
        byte[] arr = new byte[4096];
        FileInputStream fis = new FileInputStream($receiver);
        try {
            int size;
            while ((size = fis.read(arr)) != -1) {
                Unit unit;
                if (size > 0) {
                    closure.invoke((Object)arr, (Object)size);
                    unit = Unit.VALUE;
                    continue;
                }
                unit = Unit.VALUE;
            }
        }
        finally {
            fis.close();
        }
    }

    @JetMethod(flags=16, returnType="V")
    public static final void forEachLine(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="charset", hasDefaultValue=true, type="Ljava/lang/String;") String charset, @JetValueParameter(name="closure", type="Ljet/Function1<Ljava/lang/String;Ljet/Unit;>;") Function1<? super String, ? extends Unit> closure) {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream($receiver), charset));
        try {
            IoPackage$src$JIO$62618497.forEachLine(reader, closure);
        }
        finally {
            reader.close();
        }
    }

    public static /* synthetic */ void forEachLine$default(File file, String string, Function1 function1, int n) {
        if ((n & 1) != 0) {
            string = "UTF-8";
        }
        IoPackage$src$Files$81dbafd0.forEachLine(file, string, (Function1<? super String, ? extends Unit>)function1);
    }

    @JetMethod(flags=16, returnType="Ljet/List<Ljava/lang/String;>;")
    public static final List<String> readLines(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="charset", hasDefaultValue=true, type="Ljava/lang/String;") String charset) {
        ArrayList rs = new ArrayList();
        IoPackage$src$Files$81dbafd0.forEachLine($receiver, charset, (Function1<? super String, ? extends Unit>)((Function1)new IoPackage$readLines$1(rs)));
        return rs;
    }

    public static /* synthetic */ List readLines$default(File file, String string, int n) {
        if ((n & 1) != 0) {
            string = "UTF-8";
        }
        return IoPackage$src$Files$81dbafd0.readLines(file, string);
    }

    @JetMethod(flags=16, returnType="?[Ljava/io/File;")
    public static final File[] listFiles(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/File;") File $receiver, @JetValueParameter(name="filter", type="Ljet/Function1<Ljava/io/File;Ljava/lang/Boolean;>;") Function1<? super File, ? extends Boolean> filter) {
        return $receiver.listFiles((FileFilter)new JetObject(filter){
            final /* synthetic */ Function1 $filter;

            @JetMethod(returnType="Z")
            public boolean accept(@JetValueParameter(name="file", type="Ljava/io/File;") File file) {
                return (Boolean)this.$filter.invoke((Object)file);
            }
            {
                this.$filter = $shared_var$0;
            }
        });
    }
}

