package kotlin

//
// NOTE THIS FILE IS AUTO-GENERATED by the GenerateStandardLib.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import java.util.*

import java.util.Collections // TODO: it's temporary while we have java.util.Collections in js

/**
 * Returns an original collection containing all the non-*null* elements, throwing an [[IllegalArgumentException]] if there are any null elements
 */
public fun <T : Any> Array<out T?>.requireNoNulls(): Array<out T> {
    for (element in this) {
        if (element == null) {
            throw IllegalArgumentException("null element found in $this")
        }
    }
    return this as Array<out T>
}

/**
 * Returns an original collection containing all the non-*null* elements, throwing an [[IllegalArgumentException]] if there are any null elements
 */
public fun <T : Any> Iterable<T?>.requireNoNulls(): Iterable<T> {
    for (element in this) {
        if (element == null) {
            throw IllegalArgumentException("null element found in $this")
        }
    }
    return this as Iterable<T>
}

/**
 * Returns an original collection containing all the non-*null* elements, throwing an [[IllegalArgumentException]] if there are any null elements
 */
public fun <T : Any> List<T?>.requireNoNulls(): List<T> {
    for (element in this) {
        if (element == null) {
            throw IllegalArgumentException("null element found in $this")
        }
    }
    return this as List<T>
}

/**
 * Returns an original collection containing all the non-*null* elements, throwing an [[IllegalArgumentException]] if there are any null elements
 */
public fun <T : Any> Stream<T?>.requireNoNulls(): Stream<T> {
    return FilteringStream(this) {
        if (it == null) {
            throw IllegalArgumentException("null element found in $this")
        }
        true
    } as Stream<T>
}

