package kotlin

//
// NOTE THIS FILE IS AUTO-GENERATED by the GenerateStandardLib.kt
// See: https://github.com/JetBrains/kotlin/tree/master/libraries/stdlib
//

import kotlin.platform.*
import java.util.*

import java.util.Collections // TODO: it's temporary while we have java.util.Collections in js

/**
 * Returns a list containing all elements except first [n] elements.
 */
public fun <T> Array<out T>.drop(n: Int): List<T> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0)
        return toList()
    if (n >= size())
        return emptyList()
    val list = ArrayList<T>(size() - n)
    for (index in n..size() - 1) {
        list.add(this[index])
    }
    return list
}

/**
 * Returns a list containing all elements except first [n] elements.
 */
public fun BooleanArray.drop(n: Int): List<Boolean> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0)
        return toList()
    if (n >= size())
        return emptyList()
    val list = ArrayList<Boolean>(size() - n)
    for (index in n..size() - 1) {
        list.add(this[index])
    }
    return list
}

/**
 * Returns a list containing all elements except first [n] elements.
 */
public fun ByteArray.drop(n: Int): List<Byte> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0)
        return toList()
    if (n >= size())
        return emptyList()
    val list = ArrayList<Byte>(size() - n)
    for (index in n..size() - 1) {
        list.add(this[index])
    }
    return list
}

/**
 * Returns a list containing all elements except first [n] elements.
 */
public fun CharArray.drop(n: Int): List<Char> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0)
        return toList()
    if (n >= size())
        return emptyList()
    val list = ArrayList<Char>(size() - n)
    for (index in n..size() - 1) {
        list.add(this[index])
    }
    return list
}

/**
 * Returns a list containing all elements except first [n] elements.
 */
public fun DoubleArray.drop(n: Int): List<Double> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0)
        return toList()
    if (n >= size())
        return emptyList()
    val list = ArrayList<Double>(size() - n)
    for (index in n..size() - 1) {
        list.add(this[index])
    }
    return list
}

/**
 * Returns a list containing all elements except first [n] elements.
 */
public fun FloatArray.drop(n: Int): List<Float> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0)
        return toList()
    if (n >= size())
        return emptyList()
    val list = ArrayList<Float>(size() - n)
    for (index in n..size() - 1) {
        list.add(this[index])
    }
    return list
}

/**
 * Returns a list containing all elements except first [n] elements.
 */
public fun IntArray.drop(n: Int): List<Int> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0)
        return toList()
    if (n >= size())
        return emptyList()
    val list = ArrayList<Int>(size() - n)
    for (index in n..size() - 1) {
        list.add(this[index])
    }
    return list
}

/**
 * Returns a list containing all elements except first [n] elements.
 */
public fun LongArray.drop(n: Int): List<Long> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0)
        return toList()
    if (n >= size())
        return emptyList()
    val list = ArrayList<Long>(size() - n)
    for (index in n..size() - 1) {
        list.add(this[index])
    }
    return list
}

/**
 * Returns a list containing all elements except first [n] elements.
 */
public fun ShortArray.drop(n: Int): List<Short> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0)
        return toList()
    if (n >= size())
        return emptyList()
    val list = ArrayList<Short>(size() - n)
    for (index in n..size() - 1) {
        list.add(this[index])
    }
    return list
}

/**
 * Returns a list containing all elements except first [n] elements.
 */
public fun <T> Iterable<T>.drop(n: Int): List<T> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return toList()
    val list: ArrayList<T>
    if (this is Collection<*>) {
        val resultSize = size() - n
        if (resultSize <= 0)
            return emptyList()
        list = ArrayList<T>(resultSize)
        if (this is List<T>) {
            for (index in n..size() - 1) {
                list.add(this[index])
            }
            return list
        }
    }
    else {
        list = ArrayList<T>()
    }
    var count = 0
    for (item in this) {
        if (count++ >= n) list.add(item)
    }
    return list
}

/**
 * Returns a sequence containing all elements except first [n] elements.
 */
public fun <T> Sequence<T>.drop(n: Int): Sequence<T> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return if (n == 0) this else DropSequence(this, n)
}

/**
 * Returns a string with the first [n] characters removed.
 */
public fun String.drop(n: Int): String {
    return substring(Math.min(n, length()))
}

/**
 * Returns a list containing all elements except last [n] elements.
 */
public fun <T> Array<out T>.dropLast(n: Int): List<T> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return take((size() - n).coerceAtLeast(0))
}

/**
 * Returns a list containing all elements except last [n] elements.
 */
public fun BooleanArray.dropLast(n: Int): List<Boolean> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return take((size() - n).coerceAtLeast(0))
}

/**
 * Returns a list containing all elements except last [n] elements.
 */
public fun ByteArray.dropLast(n: Int): List<Byte> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return take((size() - n).coerceAtLeast(0))
}

/**
 * Returns a list containing all elements except last [n] elements.
 */
public fun CharArray.dropLast(n: Int): List<Char> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return take((size() - n).coerceAtLeast(0))
}

/**
 * Returns a list containing all elements except last [n] elements.
 */
public fun DoubleArray.dropLast(n: Int): List<Double> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return take((size() - n).coerceAtLeast(0))
}

/**
 * Returns a list containing all elements except last [n] elements.
 */
public fun FloatArray.dropLast(n: Int): List<Float> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return take((size() - n).coerceAtLeast(0))
}

/**
 * Returns a list containing all elements except last [n] elements.
 */
public fun IntArray.dropLast(n: Int): List<Int> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return take((size() - n).coerceAtLeast(0))
}

/**
 * Returns a list containing all elements except last [n] elements.
 */
public fun LongArray.dropLast(n: Int): List<Long> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return take((size() - n).coerceAtLeast(0))
}

/**
 * Returns a list containing all elements except last [n] elements.
 */
public fun ShortArray.dropLast(n: Int): List<Short> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return take((size() - n).coerceAtLeast(0))
}

/**
 * Returns a list containing all elements except last [n] elements.
 */
public fun <T> List<T>.dropLast(n: Int): List<T> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return take((size() - n).coerceAtLeast(0))
}

/**
 * Returns a string with the last [n] characters removed.
 */
public fun String.dropLast(n: Int): String {
    require(n >= 0, { "Requested character count $n is less than zero." })
    return take((length() - n).coerceAtLeast(0))
}

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public inline fun <T> Array<out T>.dropLastWhile(predicate: (T) -> Boolean): List<T> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return take(index + 1)
        }
    }
    return emptyList()
}

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public inline fun BooleanArray.dropLastWhile(predicate: (Boolean) -> Boolean): List<Boolean> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return take(index + 1)
        }
    }
    return emptyList()
}

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public inline fun ByteArray.dropLastWhile(predicate: (Byte) -> Boolean): List<Byte> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return take(index + 1)
        }
    }
    return emptyList()
}

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public inline fun CharArray.dropLastWhile(predicate: (Char) -> Boolean): List<Char> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return take(index + 1)
        }
    }
    return emptyList()
}

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public inline fun DoubleArray.dropLastWhile(predicate: (Double) -> Boolean): List<Double> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return take(index + 1)
        }
    }
    return emptyList()
}

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public inline fun FloatArray.dropLastWhile(predicate: (Float) -> Boolean): List<Float> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return take(index + 1)
        }
    }
    return emptyList()
}

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public inline fun IntArray.dropLastWhile(predicate: (Int) -> Boolean): List<Int> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return take(index + 1)
        }
    }
    return emptyList()
}

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public inline fun LongArray.dropLastWhile(predicate: (Long) -> Boolean): List<Long> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return take(index + 1)
        }
    }
    return emptyList()
}

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public inline fun ShortArray.dropLastWhile(predicate: (Short) -> Boolean): List<Short> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return take(index + 1)
        }
    }
    return emptyList()
}

/**
 * Returns a list containing all elements except last elements that satisfy the given [predicate].
 */
public inline fun <T> List<T>.dropLastWhile(predicate: (T) -> Boolean): List<T> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return take(index + 1)
        }
    }
    return emptyList()
}

/**
 * Returns a string containing all characters except last characters that satisfy the given [predicate].
 */
public inline fun String.dropLastWhile(predicate: (Char) -> Boolean): String {
    return trimEnd(predicate)
}

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public inline fun <T> Array<out T>.dropWhile(predicate: (T) -> Boolean): List<T> {
    var yielding = false
    val list = ArrayList<T>()
    for (item in this)
        if (yielding)
            list.add(item)
        else if (!predicate(item)) {
            list.add(item)
            yielding = true
        }
    return list
}

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public inline fun BooleanArray.dropWhile(predicate: (Boolean) -> Boolean): List<Boolean> {
    var yielding = false
    val list = ArrayList<Boolean>()
    for (item in this)
        if (yielding)
            list.add(item)
        else if (!predicate(item)) {
            list.add(item)
            yielding = true
        }
    return list
}

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public inline fun ByteArray.dropWhile(predicate: (Byte) -> Boolean): List<Byte> {
    var yielding = false
    val list = ArrayList<Byte>()
    for (item in this)
        if (yielding)
            list.add(item)
        else if (!predicate(item)) {
            list.add(item)
            yielding = true
        }
    return list
}

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public inline fun CharArray.dropWhile(predicate: (Char) -> Boolean): List<Char> {
    var yielding = false
    val list = ArrayList<Char>()
    for (item in this)
        if (yielding)
            list.add(item)
        else if (!predicate(item)) {
            list.add(item)
            yielding = true
        }
    return list
}

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public inline fun DoubleArray.dropWhile(predicate: (Double) -> Boolean): List<Double> {
    var yielding = false
    val list = ArrayList<Double>()
    for (item in this)
        if (yielding)
            list.add(item)
        else if (!predicate(item)) {
            list.add(item)
            yielding = true
        }
    return list
}

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public inline fun FloatArray.dropWhile(predicate: (Float) -> Boolean): List<Float> {
    var yielding = false
    val list = ArrayList<Float>()
    for (item in this)
        if (yielding)
            list.add(item)
        else if (!predicate(item)) {
            list.add(item)
            yielding = true
        }
    return list
}

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public inline fun IntArray.dropWhile(predicate: (Int) -> Boolean): List<Int> {
    var yielding = false
    val list = ArrayList<Int>()
    for (item in this)
        if (yielding)
            list.add(item)
        else if (!predicate(item)) {
            list.add(item)
            yielding = true
        }
    return list
}

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public inline fun LongArray.dropWhile(predicate: (Long) -> Boolean): List<Long> {
    var yielding = false
    val list = ArrayList<Long>()
    for (item in this)
        if (yielding)
            list.add(item)
        else if (!predicate(item)) {
            list.add(item)
            yielding = true
        }
    return list
}

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public inline fun ShortArray.dropWhile(predicate: (Short) -> Boolean): List<Short> {
    var yielding = false
    val list = ArrayList<Short>()
    for (item in this)
        if (yielding)
            list.add(item)
        else if (!predicate(item)) {
            list.add(item)
            yielding = true
        }
    return list
}

/**
 * Returns a list containing all elements except first elements that satisfy the given [predicate].
 */
public inline fun <T> Iterable<T>.dropWhile(predicate: (T) -> Boolean): List<T> {
    var yielding = false
    val list = ArrayList<T>()
    for (item in this)
        if (yielding)
            list.add(item)
        else if (!predicate(item)) {
            list.add(item)
            yielding = true
        }
    return list
}

/**
 * Returns a sequence containing all elements except first elements that satisfy the given [predicate].
 */
public fun <T> Sequence<T>.dropWhile(predicate: (T) -> Boolean): Sequence<T> {
    return DropWhileSequence(this, predicate)
}

/**
 * Returns a string containing all characters except first characters that satisfy the given [predicate].
 */
public inline fun String.dropWhile(predicate: (Char) -> Boolean): String {
    return trimStart(predicate)
}

/**
 * Returns a list containing all elements matching the given [predicate].
 */
public inline fun <T> Array<out T>.filter(predicate: (T) -> Boolean): List<T> {
    return filterTo(ArrayList<T>(), predicate)
}

/**
 * Returns a list containing all elements matching the given [predicate].
 */
public inline fun BooleanArray.filter(predicate: (Boolean) -> Boolean): List<Boolean> {
    return filterTo(ArrayList<Boolean>(), predicate)
}

/**
 * Returns a list containing all elements matching the given [predicate].
 */
public inline fun ByteArray.filter(predicate: (Byte) -> Boolean): List<Byte> {
    return filterTo(ArrayList<Byte>(), predicate)
}

/**
 * Returns a list containing all elements matching the given [predicate].
 */
public inline fun CharArray.filter(predicate: (Char) -> Boolean): List<Char> {
    return filterTo(ArrayList<Char>(), predicate)
}

/**
 * Returns a list containing all elements matching the given [predicate].
 */
public inline fun DoubleArray.filter(predicate: (Double) -> Boolean): List<Double> {
    return filterTo(ArrayList<Double>(), predicate)
}

/**
 * Returns a list containing all elements matching the given [predicate].
 */
public inline fun FloatArray.filter(predicate: (Float) -> Boolean): List<Float> {
    return filterTo(ArrayList<Float>(), predicate)
}

/**
 * Returns a list containing all elements matching the given [predicate].
 */
public inline fun IntArray.filter(predicate: (Int) -> Boolean): List<Int> {
    return filterTo(ArrayList<Int>(), predicate)
}

/**
 * Returns a list containing all elements matching the given [predicate].
 */
public inline fun LongArray.filter(predicate: (Long) -> Boolean): List<Long> {
    return filterTo(ArrayList<Long>(), predicate)
}

/**
 * Returns a list containing all elements matching the given [predicate].
 */
public inline fun ShortArray.filter(predicate: (Short) -> Boolean): List<Short> {
    return filterTo(ArrayList<Short>(), predicate)
}

/**
 * Returns a list containing all elements matching the given [predicate].
 */
public inline fun <T> Iterable<T>.filter(predicate: (T) -> Boolean): List<T> {
    return filterTo(ArrayList<T>(), predicate)
}

/**
 * Returns a sequence containing all elements matching the given [predicate].
 */
public fun <T> Sequence<T>.filter(predicate: (T) -> Boolean): Sequence<T> {
    return FilteringSequence(this, true, predicate)
}

/**
 * Returns a string containing only those characters from the original string that match the given [predicate].
 */
public inline fun String.filter(predicate: (Char) -> Boolean): String {
    return filterTo(StringBuilder(), predicate).toString()
}

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public inline fun <T> Array<out T>.filterNot(predicate: (T) -> Boolean): List<T> {
    return filterNotTo(ArrayList<T>(), predicate)
}

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public inline fun BooleanArray.filterNot(predicate: (Boolean) -> Boolean): List<Boolean> {
    return filterNotTo(ArrayList<Boolean>(), predicate)
}

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public inline fun ByteArray.filterNot(predicate: (Byte) -> Boolean): List<Byte> {
    return filterNotTo(ArrayList<Byte>(), predicate)
}

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public inline fun CharArray.filterNot(predicate: (Char) -> Boolean): List<Char> {
    return filterNotTo(ArrayList<Char>(), predicate)
}

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public inline fun DoubleArray.filterNot(predicate: (Double) -> Boolean): List<Double> {
    return filterNotTo(ArrayList<Double>(), predicate)
}

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public inline fun FloatArray.filterNot(predicate: (Float) -> Boolean): List<Float> {
    return filterNotTo(ArrayList<Float>(), predicate)
}

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public inline fun IntArray.filterNot(predicate: (Int) -> Boolean): List<Int> {
    return filterNotTo(ArrayList<Int>(), predicate)
}

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public inline fun LongArray.filterNot(predicate: (Long) -> Boolean): List<Long> {
    return filterNotTo(ArrayList<Long>(), predicate)
}

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public inline fun ShortArray.filterNot(predicate: (Short) -> Boolean): List<Short> {
    return filterNotTo(ArrayList<Short>(), predicate)
}

/**
 * Returns a list containing all elements not matching the given [predicate].
 */
public inline fun <T> Iterable<T>.filterNot(predicate: (T) -> Boolean): List<T> {
    return filterNotTo(ArrayList<T>(), predicate)
}

/**
 * Returns a sequence containing all elements not matching the given [predicate].
 */
public fun <T> Sequence<T>.filterNot(predicate: (T) -> Boolean): Sequence<T> {
    return FilteringSequence(this, false, predicate)
}

/**
 * Returns a string containing only those characters from the original string that do not match the given [predicate].
 */
public inline fun String.filterNot(predicate: (Char) -> Boolean): String {
    return filterNotTo(StringBuilder(), predicate).toString()
}

/**
 * Returns a list containing all elements that are not `null`.
 */
public fun <T : Any> Array<out T?>.filterNotNull(): List<T> {
    return filterNotNullTo(ArrayList<T>())
}

/**
 * Returns a list containing all elements that are not `null`.
 */
public fun <T : Any> Iterable<T?>.filterNotNull(): List<T> {
    return filterNotNullTo(ArrayList<T>())
}

/**
 * Returns a sequence containing all elements that are not `null`.
 */
public fun <T : Any> Sequence<T?>.filterNotNull(): Sequence<T> {
    return filterNot { it == null } as Sequence<T>
}

/**
 * Appends all elements that are not `null` to the given [destination].
 */
public fun <C : MutableCollection<in T>, T : Any> Array<out T?>.filterNotNullTo(destination: C): C {
    for (element in this) if (element != null) destination.add(element)
    return destination
}

/**
 * Appends all elements that are not `null` to the given [destination].
 */
public fun <C : MutableCollection<in T>, T : Any> Iterable<T?>.filterNotNullTo(destination: C): C {
    for (element in this) if (element != null) destination.add(element)
    return destination
}

/**
 * Appends all elements that are not `null` to the given [destination].
 */
public fun <C : MutableCollection<in T>, T : Any> Sequence<T?>.filterNotNullTo(destination: C): C {
    for (element in this) if (element != null) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <T, C : MutableCollection<in T>> Array<out T>.filterNotTo(destination: C, predicate: (T) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <C : MutableCollection<in Boolean>> BooleanArray.filterNotTo(destination: C, predicate: (Boolean) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <C : MutableCollection<in Byte>> ByteArray.filterNotTo(destination: C, predicate: (Byte) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <C : MutableCollection<in Char>> CharArray.filterNotTo(destination: C, predicate: (Char) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <C : MutableCollection<in Double>> DoubleArray.filterNotTo(destination: C, predicate: (Double) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <C : MutableCollection<in Float>> FloatArray.filterNotTo(destination: C, predicate: (Float) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <C : MutableCollection<in Int>> IntArray.filterNotTo(destination: C, predicate: (Int) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <C : MutableCollection<in Long>> LongArray.filterNotTo(destination: C, predicate: (Long) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <C : MutableCollection<in Short>> ShortArray.filterNotTo(destination: C, predicate: (Short) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <T, C : MutableCollection<in T>> Iterable<T>.filterNotTo(destination: C, predicate: (T) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements not matching the given [predicate] to the given [destination].
 */
public inline fun <T, C : MutableCollection<in T>> Sequence<T>.filterNotTo(destination: C, predicate: (T) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all characters not matching the given [predicate] to the given [destination].
 */
public inline fun <C : Appendable> String.filterNotTo(destination: C, predicate: (Char) -> Boolean): C {
    for (element in this) if (!predicate(element)) destination.append(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <T, C : MutableCollection<in T>> Array<out T>.filterTo(destination: C, predicate: (T) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <C : MutableCollection<in Boolean>> BooleanArray.filterTo(destination: C, predicate: (Boolean) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <C : MutableCollection<in Byte>> ByteArray.filterTo(destination: C, predicate: (Byte) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <C : MutableCollection<in Char>> CharArray.filterTo(destination: C, predicate: (Char) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <C : MutableCollection<in Double>> DoubleArray.filterTo(destination: C, predicate: (Double) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <C : MutableCollection<in Float>> FloatArray.filterTo(destination: C, predicate: (Float) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <C : MutableCollection<in Int>> IntArray.filterTo(destination: C, predicate: (Int) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <C : MutableCollection<in Long>> LongArray.filterTo(destination: C, predicate: (Long) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <C : MutableCollection<in Short>> ShortArray.filterTo(destination: C, predicate: (Short) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <T, C : MutableCollection<in T>> Iterable<T>.filterTo(destination: C, predicate: (T) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all elements matching the given [predicate] into the given [destination].
 */
public inline fun <T, C : MutableCollection<in T>> Sequence<T>.filterTo(destination: C, predicate: (T) -> Boolean): C {
    for (element in this) if (predicate(element)) destination.add(element)
    return destination
}

/**
 * Appends all characters matching the given [predicate] to the given [destination].
 */
public inline fun <C : Appendable> String.filterTo(destination: C, predicate: (Char) -> Boolean): C {
    for (index in 0..length() - 1) {
        val element = get(index)
        if (predicate(element)) destination.append(element)
    }
    return destination
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun <T> Array<out T>.slice(indices: IntRange): List<T> {
    if (indices.isEmpty()) return listOf()
    return copyOfRange(indices.start, indices.end + 1).asList()
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun BooleanArray.slice(indices: IntRange): List<Boolean> {
    if (indices.isEmpty()) return listOf()
    return copyOfRange(indices.start, indices.end + 1).asList()
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun ByteArray.slice(indices: IntRange): List<Byte> {
    if (indices.isEmpty()) return listOf()
    return copyOfRange(indices.start, indices.end + 1).asList()
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun CharArray.slice(indices: IntRange): List<Char> {
    if (indices.isEmpty()) return listOf()
    return copyOfRange(indices.start, indices.end + 1).asList()
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun DoubleArray.slice(indices: IntRange): List<Double> {
    if (indices.isEmpty()) return listOf()
    return copyOfRange(indices.start, indices.end + 1).asList()
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun FloatArray.slice(indices: IntRange): List<Float> {
    if (indices.isEmpty()) return listOf()
    return copyOfRange(indices.start, indices.end + 1).asList()
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun IntArray.slice(indices: IntRange): List<Int> {
    if (indices.isEmpty()) return listOf()
    return copyOfRange(indices.start, indices.end + 1).asList()
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun LongArray.slice(indices: IntRange): List<Long> {
    if (indices.isEmpty()) return listOf()
    return copyOfRange(indices.start, indices.end + 1).asList()
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun ShortArray.slice(indices: IntRange): List<Short> {
    if (indices.isEmpty()) return listOf()
    return copyOfRange(indices.start, indices.end + 1).asList()
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun <T> List<T>.slice(indices: IntRange): List<T> {
    if (indices.isEmpty()) return listOf()
    return this.subList(indices.start, indices.end + 1).toList()
}

/**
 * Returns a string containing characters at indices at the specified [indices].
 */
public fun String.slice(indices: IntRange): String {
    if (indices.isEmpty()) return ""
    return substring(indices)
}

/**
 * Returns a list containing elements at specified [indices].
 */
public fun <T> Array<out T>.slice(indices: Iterable<Int>): List<T> {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return listOf()
    val list = ArrayList<T>(size)
    for (index in indices) {
        list.add(get(index))
    }
    return list
}

/**
 * Returns a list containing elements at specified [indices].
 */
public fun BooleanArray.slice(indices: Iterable<Int>): List<Boolean> {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return listOf()
    val list = ArrayList<Boolean>(size)
    for (index in indices) {
        list.add(get(index))
    }
    return list
}

/**
 * Returns a list containing elements at specified [indices].
 */
public fun ByteArray.slice(indices: Iterable<Int>): List<Byte> {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return listOf()
    val list = ArrayList<Byte>(size)
    for (index in indices) {
        list.add(get(index))
    }
    return list
}

/**
 * Returns a list containing elements at specified [indices].
 */
public fun CharArray.slice(indices: Iterable<Int>): List<Char> {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return listOf()
    val list = ArrayList<Char>(size)
    for (index in indices) {
        list.add(get(index))
    }
    return list
}

/**
 * Returns a list containing elements at specified [indices].
 */
public fun DoubleArray.slice(indices: Iterable<Int>): List<Double> {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return listOf()
    val list = ArrayList<Double>(size)
    for (index in indices) {
        list.add(get(index))
    }
    return list
}

/**
 * Returns a list containing elements at specified [indices].
 */
public fun FloatArray.slice(indices: Iterable<Int>): List<Float> {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return listOf()
    val list = ArrayList<Float>(size)
    for (index in indices) {
        list.add(get(index))
    }
    return list
}

/**
 * Returns a list containing elements at specified [indices].
 */
public fun IntArray.slice(indices: Iterable<Int>): List<Int> {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return listOf()
    val list = ArrayList<Int>(size)
    for (index in indices) {
        list.add(get(index))
    }
    return list
}

/**
 * Returns a list containing elements at specified [indices].
 */
public fun LongArray.slice(indices: Iterable<Int>): List<Long> {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return listOf()
    val list = ArrayList<Long>(size)
    for (index in indices) {
        list.add(get(index))
    }
    return list
}

/**
 * Returns a list containing elements at specified [indices].
 */
public fun ShortArray.slice(indices: Iterable<Int>): List<Short> {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return listOf()
    val list = ArrayList<Short>(size)
    for (index in indices) {
        list.add(get(index))
    }
    return list
}

/**
 * Returns a list containing elements at specified [indices].
 */
public fun <T> List<T>.slice(indices: Iterable<Int>): List<T> {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return listOf()
    val list = ArrayList<T>(size)
    for (index in indices) {
        list.add(get(index))
    }
    return list
}

/**
 * Returns a string containing characters at specified [indices].
 */
public fun String.slice(indices: Iterable<Int>): String {
    val size = indices.collectionSizeOrDefault(10)
    if (size == 0) return ""
    val result = StringBuilder(size)
    for (i in indices) {
        result.append(get(i))
    }
    return result.toString()
}

/**
 * Returns an array containing elements of this array at specified [indices].
 */
public fun <T> Array<out T>.sliceArray(indices: Collection<Int>): Array<out T> {
    val result = arrayOfNulls(this, indices.size()) as Array<T>
    var targetIndex = 0
    for (sourceIndex in indices) {
        result[targetIndex++] = this[sourceIndex]
    }
    return result
}

/**
 * Returns an array containing elements of this array at specified [indices].
 */
public fun BooleanArray.sliceArray(indices: Collection<Int>): BooleanArray {
    val result = BooleanArray(indices.size())
    var targetIndex = 0
    for (sourceIndex in indices) {
        result[targetIndex++] = this[sourceIndex]
    }
    return result
}

/**
 * Returns an array containing elements of this array at specified [indices].
 */
public fun ByteArray.sliceArray(indices: Collection<Int>): ByteArray {
    val result = ByteArray(indices.size())
    var targetIndex = 0
    for (sourceIndex in indices) {
        result[targetIndex++] = this[sourceIndex]
    }
    return result
}

/**
 * Returns an array containing elements of this array at specified [indices].
 */
public fun CharArray.sliceArray(indices: Collection<Int>): CharArray {
    val result = CharArray(indices.size())
    var targetIndex = 0
    for (sourceIndex in indices) {
        result[targetIndex++] = this[sourceIndex]
    }
    return result
}

/**
 * Returns an array containing elements of this array at specified [indices].
 */
public fun DoubleArray.sliceArray(indices: Collection<Int>): DoubleArray {
    val result = DoubleArray(indices.size())
    var targetIndex = 0
    for (sourceIndex in indices) {
        result[targetIndex++] = this[sourceIndex]
    }
    return result
}

/**
 * Returns an array containing elements of this array at specified [indices].
 */
public fun FloatArray.sliceArray(indices: Collection<Int>): FloatArray {
    val result = FloatArray(indices.size())
    var targetIndex = 0
    for (sourceIndex in indices) {
        result[targetIndex++] = this[sourceIndex]
    }
    return result
}

/**
 * Returns an array containing elements of this array at specified [indices].
 */
public fun IntArray.sliceArray(indices: Collection<Int>): IntArray {
    val result = IntArray(indices.size())
    var targetIndex = 0
    for (sourceIndex in indices) {
        result[targetIndex++] = this[sourceIndex]
    }
    return result
}

/**
 * Returns an array containing elements of this array at specified [indices].
 */
public fun LongArray.sliceArray(indices: Collection<Int>): LongArray {
    val result = LongArray(indices.size())
    var targetIndex = 0
    for (sourceIndex in indices) {
        result[targetIndex++] = this[sourceIndex]
    }
    return result
}

/**
 * Returns an array containing elements of this array at specified [indices].
 */
public fun ShortArray.sliceArray(indices: Collection<Int>): ShortArray {
    val result = ShortArray(indices.size())
    var targetIndex = 0
    for (sourceIndex in indices) {
        result[targetIndex++] = this[sourceIndex]
    }
    return result
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun <T> Array<out T>.sliceArray(indices: IntRange): Array<out T> {
    if (indices.isEmpty()) return copyOfRange(0, 0)
    return copyOfRange(indices.start, indices.end + 1)
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun BooleanArray.sliceArray(indices: IntRange): BooleanArray {
    if (indices.isEmpty()) return BooleanArray(0)
    return copyOfRange(indices.start, indices.end + 1)
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun ByteArray.sliceArray(indices: IntRange): ByteArray {
    if (indices.isEmpty()) return ByteArray(0)
    return copyOfRange(indices.start, indices.end + 1)
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun CharArray.sliceArray(indices: IntRange): CharArray {
    if (indices.isEmpty()) return CharArray(0)
    return copyOfRange(indices.start, indices.end + 1)
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun DoubleArray.sliceArray(indices: IntRange): DoubleArray {
    if (indices.isEmpty()) return DoubleArray(0)
    return copyOfRange(indices.start, indices.end + 1)
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun FloatArray.sliceArray(indices: IntRange): FloatArray {
    if (indices.isEmpty()) return FloatArray(0)
    return copyOfRange(indices.start, indices.end + 1)
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun IntArray.sliceArray(indices: IntRange): IntArray {
    if (indices.isEmpty()) return IntArray(0)
    return copyOfRange(indices.start, indices.end + 1)
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun LongArray.sliceArray(indices: IntRange): LongArray {
    if (indices.isEmpty()) return LongArray(0)
    return copyOfRange(indices.start, indices.end + 1)
}

/**
 * Returns a list containing elements at indices in the specified [indices] range.
 */
public fun ShortArray.sliceArray(indices: IntRange): ShortArray {
    if (indices.isEmpty()) return ShortArray(0)
    return copyOfRange(indices.start, indices.end + 1)
}

/**
 * Returns a list containing first [n] elements.
 */
public fun <T> Array<out T>.take(n: Int): List<T> {
    require(n >= 0) { "Requested element count $n is less than zero." }
    if (n == 0) return emptyList()
    if (n >= size()) return toList()
    var count = 0
    val list = ArrayList<T>(n)
    for (item in this) {
        if (count++ == n)
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first [n] elements.
 */
public fun BooleanArray.take(n: Int): List<Boolean> {
    require(n >= 0) { "Requested element count $n is less than zero." }
    if (n == 0) return emptyList()
    if (n >= size()) return toList()
    var count = 0
    val list = ArrayList<Boolean>(n)
    for (item in this) {
        if (count++ == n)
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first [n] elements.
 */
public fun ByteArray.take(n: Int): List<Byte> {
    require(n >= 0) { "Requested element count $n is less than zero." }
    if (n == 0) return emptyList()
    if (n >= size()) return toList()
    var count = 0
    val list = ArrayList<Byte>(n)
    for (item in this) {
        if (count++ == n)
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first [n] elements.
 */
public fun CharArray.take(n: Int): List<Char> {
    require(n >= 0) { "Requested element count $n is less than zero." }
    if (n == 0) return emptyList()
    if (n >= size()) return toList()
    var count = 0
    val list = ArrayList<Char>(n)
    for (item in this) {
        if (count++ == n)
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first [n] elements.
 */
public fun DoubleArray.take(n: Int): List<Double> {
    require(n >= 0) { "Requested element count $n is less than zero." }
    if (n == 0) return emptyList()
    if (n >= size()) return toList()
    var count = 0
    val list = ArrayList<Double>(n)
    for (item in this) {
        if (count++ == n)
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first [n] elements.
 */
public fun FloatArray.take(n: Int): List<Float> {
    require(n >= 0) { "Requested element count $n is less than zero." }
    if (n == 0) return emptyList()
    if (n >= size()) return toList()
    var count = 0
    val list = ArrayList<Float>(n)
    for (item in this) {
        if (count++ == n)
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first [n] elements.
 */
public fun IntArray.take(n: Int): List<Int> {
    require(n >= 0) { "Requested element count $n is less than zero." }
    if (n == 0) return emptyList()
    if (n >= size()) return toList()
    var count = 0
    val list = ArrayList<Int>(n)
    for (item in this) {
        if (count++ == n)
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first [n] elements.
 */
public fun LongArray.take(n: Int): List<Long> {
    require(n >= 0) { "Requested element count $n is less than zero." }
    if (n == 0) return emptyList()
    if (n >= size()) return toList()
    var count = 0
    val list = ArrayList<Long>(n)
    for (item in this) {
        if (count++ == n)
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first [n] elements.
 */
public fun ShortArray.take(n: Int): List<Short> {
    require(n >= 0) { "Requested element count $n is less than zero." }
    if (n == 0) return emptyList()
    if (n >= size()) return toList()
    var count = 0
    val list = ArrayList<Short>(n)
    for (item in this) {
        if (count++ == n)
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first [n] elements.
 */
public fun <T> Iterable<T>.take(n: Int): List<T> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    if (this is Collection<T> && n >= size()) return toList()
    var count = 0
    val list = ArrayList<T>(n)
    for (item in this) {
        if (count++ == n)
            break
        list.add(item)
    }
    return list
}

/**
 * Returns a sequence containing first [n] elements.
 */
public fun <T> Sequence<T>.take(n: Int): Sequence<T> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    return if (n == 0) emptySequence() else TakeSequence(this, n)
}

/**
 * Returns a string containing the first [n] characters from this string, or the entire string if this string is shorter.
 */
public fun String.take(n: Int): String {
    require(n >= 0, { "Requested character count $n is less than zero." })
    return substring(0, Math.min(n, length()))
}

/**
 * Returns a list containing last [n] elements.
 */
public fun <T> Array<out T>.takeLast(n: Int): List<T> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    val size = size()
    if (n >= size) return toList()
    val list = ArrayList<T>(n)
    for (index in size - n .. size - 1)
        list.add(this[index])
    return list
}

/**
 * Returns a list containing last [n] elements.
 */
public fun BooleanArray.takeLast(n: Int): List<Boolean> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    val size = size()
    if (n >= size) return toList()
    val list = ArrayList<Boolean>(n)
    for (index in size - n .. size - 1)
        list.add(this[index])
    return list
}

/**
 * Returns a list containing last [n] elements.
 */
public fun ByteArray.takeLast(n: Int): List<Byte> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    val size = size()
    if (n >= size) return toList()
    val list = ArrayList<Byte>(n)
    for (index in size - n .. size - 1)
        list.add(this[index])
    return list
}

/**
 * Returns a list containing last [n] elements.
 */
public fun CharArray.takeLast(n: Int): List<Char> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    val size = size()
    if (n >= size) return toList()
    val list = ArrayList<Char>(n)
    for (index in size - n .. size - 1)
        list.add(this[index])
    return list
}

/**
 * Returns a list containing last [n] elements.
 */
public fun DoubleArray.takeLast(n: Int): List<Double> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    val size = size()
    if (n >= size) return toList()
    val list = ArrayList<Double>(n)
    for (index in size - n .. size - 1)
        list.add(this[index])
    return list
}

/**
 * Returns a list containing last [n] elements.
 */
public fun FloatArray.takeLast(n: Int): List<Float> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    val size = size()
    if (n >= size) return toList()
    val list = ArrayList<Float>(n)
    for (index in size - n .. size - 1)
        list.add(this[index])
    return list
}

/**
 * Returns a list containing last [n] elements.
 */
public fun IntArray.takeLast(n: Int): List<Int> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    val size = size()
    if (n >= size) return toList()
    val list = ArrayList<Int>(n)
    for (index in size - n .. size - 1)
        list.add(this[index])
    return list
}

/**
 * Returns a list containing last [n] elements.
 */
public fun LongArray.takeLast(n: Int): List<Long> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    val size = size()
    if (n >= size) return toList()
    val list = ArrayList<Long>(n)
    for (index in size - n .. size - 1)
        list.add(this[index])
    return list
}

/**
 * Returns a list containing last [n] elements.
 */
public fun ShortArray.takeLast(n: Int): List<Short> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    val size = size()
    if (n >= size) return toList()
    val list = ArrayList<Short>(n)
    for (index in size - n .. size - 1)
        list.add(this[index])
    return list
}

/**
 * Returns a list containing last [n] elements.
 */
public fun <T> List<T>.takeLast(n: Int): List<T> {
    require(n >= 0, { "Requested element count $n is less than zero." })
    if (n == 0) return emptyList()
    val size = size()
    if (n >= size) return toList()
    val list = ArrayList<T>(n)
    for (index in size - n .. size - 1)
        list.add(this[index])
    return list
}

/**
 * Returns a string containing the last [n] characters from this string, or the entire string if this string is shorter.
 */
public fun String.takeLast(n: Int): String {
    require(n >= 0, { "Requested character count $n is less than zero." })
    val length = length()
    return substring(length - Math.min(n, length), length)
}

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public inline fun <T> Array<out T>.takeLastWhile(predicate: (T) -> Boolean): List<T> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return drop(index + 1)
        }
    }
    return toList()
}

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public inline fun BooleanArray.takeLastWhile(predicate: (Boolean) -> Boolean): List<Boolean> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return drop(index + 1)
        }
    }
    return toList()
}

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public inline fun ByteArray.takeLastWhile(predicate: (Byte) -> Boolean): List<Byte> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return drop(index + 1)
        }
    }
    return toList()
}

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public inline fun CharArray.takeLastWhile(predicate: (Char) -> Boolean): List<Char> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return drop(index + 1)
        }
    }
    return toList()
}

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public inline fun DoubleArray.takeLastWhile(predicate: (Double) -> Boolean): List<Double> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return drop(index + 1)
        }
    }
    return toList()
}

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public inline fun FloatArray.takeLastWhile(predicate: (Float) -> Boolean): List<Float> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return drop(index + 1)
        }
    }
    return toList()
}

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public inline fun IntArray.takeLastWhile(predicate: (Int) -> Boolean): List<Int> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return drop(index + 1)
        }
    }
    return toList()
}

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public inline fun LongArray.takeLastWhile(predicate: (Long) -> Boolean): List<Long> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return drop(index + 1)
        }
    }
    return toList()
}

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public inline fun ShortArray.takeLastWhile(predicate: (Short) -> Boolean): List<Short> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return drop(index + 1)
        }
    }
    return toList()
}

/**
 * Returns a list containing last elements satisfying the given [predicate].
 */
public inline fun <T> List<T>.takeLastWhile(predicate: (T) -> Boolean): List<T> {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return drop(index + 1)
        }
    }
    return toList()
}

/**
 * Returns a string containing last characters that satisfy the given [predicate].
 */
public inline fun String.takeLastWhile(predicate: (Char) -> Boolean): String {
    for (index in lastIndex downTo 0) {
        if (!predicate(this[index])) {
            return substring(index + 1)
        }
    }
    return this
}

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public inline fun <T> Array<out T>.takeWhile(predicate: (T) -> Boolean): List<T> {
    val list = ArrayList<T>()
    for (item in this) {
        if (!predicate(item))
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public inline fun BooleanArray.takeWhile(predicate: (Boolean) -> Boolean): List<Boolean> {
    val list = ArrayList<Boolean>()
    for (item in this) {
        if (!predicate(item))
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public inline fun ByteArray.takeWhile(predicate: (Byte) -> Boolean): List<Byte> {
    val list = ArrayList<Byte>()
    for (item in this) {
        if (!predicate(item))
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public inline fun CharArray.takeWhile(predicate: (Char) -> Boolean): List<Char> {
    val list = ArrayList<Char>()
    for (item in this) {
        if (!predicate(item))
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public inline fun DoubleArray.takeWhile(predicate: (Double) -> Boolean): List<Double> {
    val list = ArrayList<Double>()
    for (item in this) {
        if (!predicate(item))
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public inline fun FloatArray.takeWhile(predicate: (Float) -> Boolean): List<Float> {
    val list = ArrayList<Float>()
    for (item in this) {
        if (!predicate(item))
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public inline fun IntArray.takeWhile(predicate: (Int) -> Boolean): List<Int> {
    val list = ArrayList<Int>()
    for (item in this) {
        if (!predicate(item))
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public inline fun LongArray.takeWhile(predicate: (Long) -> Boolean): List<Long> {
    val list = ArrayList<Long>()
    for (item in this) {
        if (!predicate(item))
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public inline fun ShortArray.takeWhile(predicate: (Short) -> Boolean): List<Short> {
    val list = ArrayList<Short>()
    for (item in this) {
        if (!predicate(item))
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a list containing first elements satisfying the given [predicate].
 */
public inline fun <T> Iterable<T>.takeWhile(predicate: (T) -> Boolean): List<T> {
    val list = ArrayList<T>()
    for (item in this) {
        if (!predicate(item))
            break;
        list.add(item)
    }
    return list
}

/**
 * Returns a sequence containing first elements satisfying the given [predicate].
 */
public fun <T> Sequence<T>.takeWhile(predicate: (T) -> Boolean): Sequence<T> {
    return TakeWhileSequence(this, predicate)
}

/**
 * Returns a string containing the first characters that satisfy the given [predicate].
 */
public inline fun String.takeWhile(predicate: (Char) -> Boolean): String {
    for (index in 0..length() - 1)
        if (!predicate(get(index))) {
            return substring(0, index)
        }
    return this
}

