/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.AbstractList;
import java.util.List;
import jet.TypeCastException;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage$src$ImmutableArrayList$32627b6a;

@JetClass(signature="<erased T:?Ljava/lang/Object;>Ljava/util/AbstractList<TT;>;", flags=8, abiVersion=6)
public final class ImmutableArrayList<T>
extends AbstractList<T> {
    private final T[] array;
    private final int offset;
    private final int length;

    @JetMethod(flags=32, returnType="I")
    protected final int indexInArray(@JetValueParameter(name="index", type="I") int index) {
        if (index < 0) {
            throw (Throwable)new IndexOutOfBoundsException("Negative index (" + index + ")");
        }
        if (index >= this.length) {
            throw (Throwable)new IndexOutOfBoundsException("index (" + index + ") >= length (" + this.length + ")");
        }
        return index + this.offset;
    }

    @Override
    @JetMethod(returnType="TT;")
    public T get(@JetValueParameter(name="index", type="I") int index) {
        return this.array[this.indexInArray(index)];
    }

    @Override
    @JetMethod(returnType="I")
    public int size() {
        return this.length;
    }

    @Override
    @JetMethod(returnType="Ljet/MutableList<TT;>;")
    public List<T> subList(@JetValueParameter(name="fromIndex", type="I") int fromIndex, @JetValueParameter(name="toIndex", type="I") int toIndex) {
        if (fromIndex < 0) {
            throw (Throwable)new IndexOutOfBoundsException("Negative from index (" + fromIndex + ")");
        }
        if (toIndex < fromIndex) {
            throw (Throwable)new IndexOutOfBoundsException("toIndex (" + toIndex + ") < fromIndex (" + fromIndex + ")");
        }
        if (toIndex > this.length) {
            throw (Throwable)new IndexOutOfBoundsException("fromIndex (" + fromIndex + ") + toIndex (" + toIndex + ") > length (" + this.length + ")");
        }
        if (fromIndex == toIndex) {
            ImmutableArrayList<Object> immutableArrayList = KotlinPackage$src$ImmutableArrayList$32627b6a.getEmptyImmutableArrayList();
            if (immutableArrayList == null) {
                throw new TypeCastException("kotlin.ImmutableArrayList<jet.Any?> cannot be cast to jet.MutableList<T>");
            }
            return immutableArrayList;
        }
        boolean bl = true;
        if (fromIndex != 0) {
            bl = false;
        }
        boolean bl2 = bl ? toIndex == this.length : false;
        if (bl2) {
            return this;
        }
        return new ImmutableArrayList<T>(this.array, this.offset + fromIndex, toIndex - fromIndex);
    }

    @JetMethod(flags=9, propertyType="[TT;")
    private final T[] getArray() {
        return this.array;
    }

    @JetMethod(flags=9, propertyType="I")
    private final int getOffset() {
        return this.offset;
    }

    @JetMethod(flags=9, propertyType="I")
    private final int getLength() {
        return this.length;
    }

    @JetConstructor
    public ImmutableArrayList(@JetValueParameter(name="array", type="[TT;") T[] array, @JetValueParameter(name="offset", type="I") int offset, @JetValueParameter(name="length", type="I") int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
        if (this.offset < 0) {
            throw (Throwable)new IllegalArgumentException("Negative offset (" + this.offset + ")");
        }
        if (this.length < 0) {
            throw (Throwable)new IllegalArgumentException("Negative length (" + this.length + ")");
        }
        if (this.offset + this.length > this.array.length) {
            throw (Throwable)new IllegalArgumentException("offset (" + this.offset + ") + length (" + this.length + ") > array.length (" + this.array.length + ")");
        }
    }
}

