/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import jet.ByteIterator;
import jet.Function1;
import jet.JetObject;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage$src$ArraysJVM$562c8208;
import kotlin.io.IoPackage$forEachLine$1;
import kotlin.io.IoPackage$readBytes$2;
import kotlin.io.IoPackage$stdin$1;
import kotlin.io.IoPackage$useLines$1;
import kotlin.io.LineIterator;

public final class IoPackage$src$JIO$4bdd52f8 {
    static final int defaultBufferSize = 64 * 1024;
    static final Charset defaultCharset;
    static final BufferedReader stdin;

    @JetMethod(flags=1, propertyType="I")
    public static final int getDefaultBufferSize() {
        return defaultBufferSize;
    }

    @JetMethod(flags=1, propertyType="Ljava/nio/charset/Charset;")
    public static final Charset getDefaultCharset() {
        return defaultCharset;
    }

    @JetMethod(returnType="V")
    public static final void print(@JetValueParameter(name="message", type="?Ljava/lang/Object;") Object message) {
        System.out.print(message);
    }

    @JetMethod(returnType="V")
    public static final void print(@JetValueParameter(name="message", type="I") int message) {
        System.out.print(message);
    }

    @JetMethod(returnType="V")
    public static final void print(@JetValueParameter(name="message", type="J") long message) {
        System.out.print(message);
    }

    @JetMethod(returnType="V")
    public static final void print(@JetValueParameter(name="message", type="B") byte message) {
        System.out.print((Object)message);
    }

    @JetMethod(returnType="V")
    public static final void print(@JetValueParameter(name="message", type="S") short message) {
        System.out.print((Object)message);
    }

    @JetMethod(returnType="V")
    public static final void print(@JetValueParameter(name="message", type="C") char message) {
        System.out.print(message);
    }

    @JetMethod(returnType="V")
    public static final void print(@JetValueParameter(name="message", type="Z") boolean message) {
        System.out.print(message);
    }

    @JetMethod(returnType="V")
    public static final void print(@JetValueParameter(name="message", type="F") float message) {
        System.out.print(message);
    }

    @JetMethod(returnType="V")
    public static final void print(@JetValueParameter(name="message", type="D") double message) {
        System.out.print(message);
    }

    @JetMethod(returnType="V")
    public static final void print(@JetValueParameter(name="message", type="[C") char[] message) {
        System.out.print(message);
    }

    @JetMethod(returnType="V")
    public static final void println(@JetValueParameter(name="message", type="?Ljava/lang/Object;") Object message) {
        System.out.println(message);
    }

    @JetMethod(returnType="V")
    public static final void println(@JetValueParameter(name="message", type="I") int message) {
        System.out.println(message);
    }

    @JetMethod(returnType="V")
    public static final void println(@JetValueParameter(name="message", type="J") long message) {
        System.out.println(message);
    }

    @JetMethod(returnType="V")
    public static final void println(@JetValueParameter(name="message", type="B") byte message) {
        System.out.println((Object)message);
    }

    @JetMethod(returnType="V")
    public static final void println(@JetValueParameter(name="message", type="S") short message) {
        System.out.println((Object)message);
    }

    @JetMethod(returnType="V")
    public static final void println(@JetValueParameter(name="message", type="C") char message) {
        System.out.println(message);
    }

    @JetMethod(returnType="V")
    public static final void println(@JetValueParameter(name="message", type="Z") boolean message) {
        System.out.println(message);
    }

    @JetMethod(returnType="V")
    public static final void println(@JetValueParameter(name="message", type="F") float message) {
        System.out.println(message);
    }

    @JetMethod(returnType="V")
    public static final void println(@JetValueParameter(name="message", type="D") double message) {
        System.out.println(message);
    }

    @JetMethod(returnType="V")
    public static final void println(@JetValueParameter(name="message", type="[C") char[] message) {
        System.out.println(message);
    }

    @JetMethod(returnType="V")
    public static final void println() {
        System.out.println();
    }

    @JetMethod(flags=9, propertyType="Ljava/io/BufferedReader;")
    public static final BufferedReader getStdin() {
        return stdin;
    }

    @JetMethod(returnType="?Ljava/lang/String;")
    public static final String readLine() {
        return stdin.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JetMethod(typeParameters="<erased T::Ljava/io/Closeable;erased R:?Ljava/lang/Object;>", returnType="TR;")
    public static final <T extends Closeable, R> R use(@JetValueParameter(name="$receiver", receiver=true, type="TT;") T $receiver, @JetValueParameter(name="block", type="Ljet/Function1<TT;TR;>;") Function1<? super T, ? extends R> block) {
        int closed = 0;
        try {
            return (R)block.invoke($receiver);
        }
        catch (Exception exception) {
            closed = 1;
            try {
                $receiver.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (closed == 0) {
                $receiver.close();
            }
        }
    }

    @JetMethod(returnType="Ljet/ByteIterator;")
    public static final ByteIterator iterator(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/InputStream;") InputStream $receiver) {
        return (ByteIterator)new JetObject($receiver){
            final /* synthetic */ InputStream receiver$0;

            @JetMethod(returnType="Z")
            public boolean hasNext() {
                return this.receiver$0.available() > 0;
            }

            @JetMethod(returnType="B")
            public byte nextByte() {
                return (byte)this.receiver$0.read();
            }
            {
                this.receiver$0 = $receiver;
            }

            public void remove() {
                throw new UnsupportedOperationException("Mutating method called on a Kotlin Iterator");
            }
        };
    }

    @JetMethod(returnType="Ljava/io/InputStream;")
    public static final InputStream buffered(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/InputStream;") InputStream $receiver, @JetValueParameter(name="bufferSize", hasDefaultValue=true, type="I") int bufferSize) {
        return $receiver instanceof BufferedInputStream ? $receiver : (InputStream)new BufferedInputStream($receiver, bufferSize);
    }

    public static /* synthetic */ InputStream buffered$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage$src$JIO$4bdd52f8.buffered(inputStream, n);
    }

    @JetMethod(returnType="Ljava/io/InputStreamReader;")
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/InputStream;") InputStream $receiver, @JetValueParameter(name="encoding", hasDefaultValue=true, type="Ljava/nio/charset/Charset;") Charset encoding) {
        return new InputStreamReader($receiver, encoding);
    }

    public static /* synthetic */ InputStreamReader reader$default(InputStream inputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = defaultCharset;
        }
        return IoPackage$src$JIO$4bdd52f8.reader(inputStream, charset);
    }

    @JetMethod(returnType="Ljava/io/InputStreamReader;")
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/InputStream;") InputStream $receiver, @JetValueParameter(name="encoding", type="Ljava/lang/String;") String encoding) {
        return new InputStreamReader($receiver, encoding);
    }

    @JetMethod(returnType="Ljava/io/InputStreamReader;")
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/InputStream;") InputStream $receiver, @JetValueParameter(name="encoding", type="Ljava/nio/charset/CharsetDecoder;") CharsetDecoder encoding) {
        return new InputStreamReader($receiver, encoding);
    }

    @JetMethod(returnType="Ljava/io/BufferedOutputStream;")
    public static final BufferedOutputStream buffered(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/OutputStream;") OutputStream $receiver, @JetValueParameter(name="bufferSize", hasDefaultValue=true, type="I") int bufferSize) {
        return $receiver instanceof BufferedOutputStream ? (BufferedOutputStream)$receiver : new BufferedOutputStream($receiver, bufferSize);
    }

    public static /* synthetic */ BufferedOutputStream buffered$default(OutputStream outputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage$src$JIO$4bdd52f8.buffered(outputStream, n);
    }

    @JetMethod(returnType="Ljava/io/OutputStreamWriter;")
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/OutputStream;") OutputStream $receiver, @JetValueParameter(name="encoding", hasDefaultValue=true, type="Ljava/nio/charset/Charset;") Charset encoding) {
        return new OutputStreamWriter($receiver, encoding);
    }

    public static /* synthetic */ OutputStreamWriter writer$default(OutputStream outputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = defaultCharset;
        }
        return IoPackage$src$JIO$4bdd52f8.writer(outputStream, charset);
    }

    @JetMethod(returnType="Ljava/io/OutputStreamWriter;")
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/OutputStream;") OutputStream $receiver, @JetValueParameter(name="encoding", type="Ljava/lang/String;") String encoding) {
        return new OutputStreamWriter($receiver, encoding);
    }

    @JetMethod(returnType="Ljava/io/OutputStreamWriter;")
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/OutputStream;") OutputStream $receiver, @JetValueParameter(name="encoding", type="Ljava/nio/charset/CharsetEncoder;") CharsetEncoder encoding) {
        return new OutputStreamWriter($receiver, encoding);
    }

    @JetMethod(returnType="Ljava/io/BufferedReader;")
    public static final BufferedReader buffered(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/Reader;") Reader $receiver, @JetValueParameter(name="bufferSize", hasDefaultValue=true, type="I") int bufferSize) {
        return $receiver instanceof BufferedReader ? (BufferedReader)$receiver : new BufferedReader($receiver, bufferSize);
    }

    public static /* synthetic */ BufferedReader buffered$default(Reader reader, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage$src$JIO$4bdd52f8.buffered(reader, n);
    }

    @JetMethod(returnType="Ljava/io/BufferedWriter;")
    public static final BufferedWriter buffered(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/Writer;") Writer $receiver, @JetValueParameter(name="bufferSize", hasDefaultValue=true, type="I") int bufferSize) {
        return $receiver instanceof BufferedWriter ? (BufferedWriter)$receiver : new BufferedWriter($receiver, bufferSize);
    }

    public static /* synthetic */ BufferedWriter buffered$default(Writer writer, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage$src$JIO$4bdd52f8.buffered(writer, n);
    }

    @JetMethod(returnType="V")
    public static final void forEachLine(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/Reader;") Reader $receiver, @JetValueParameter(name="block", type="Ljet/Function1<Ljava/lang/String;Ljava/lang/Object;>;") Function1<? super String, ? extends Object> block) {
        IoPackage$src$JIO$4bdd52f8.use((Closeable)$receiver, (Function1)new IoPackage$forEachLine$1($receiver, block));
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="TT;")
    public static final <T> T useLines(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/Reader;") Reader $receiver, @JetValueParameter(name="block", type="Ljet/Function1<Ljet/Iterator<Ljava/lang/String;>;TT;>;") Function1<? super Iterator<? extends String>, ? extends T> block) {
        return (T)IoPackage$src$JIO$4bdd52f8.use((Closeable)IoPackage$src$JIO$4bdd52f8.buffered$default($receiver, 0, 1), (Function1)new IoPackage$useLines$1(block));
    }

    @JetMethod(returnType="Ljet/Iterator<Ljava/lang/String;>;")
    public static final Iterator<String> lineIterator(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/BufferedReader;") BufferedReader $receiver) {
        return new LineIterator($receiver);
    }

    @JetMethod(returnType="[B")
    public static final byte[] readBytes(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/InputStream;") InputStream $receiver, @JetValueParameter(name="estimatedSize", hasDefaultValue=true, type="I") int estimatedSize) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(estimatedSize);
        IoPackage$src$JIO$4bdd52f8.copyTo$default($receiver, buffer, 0, 2);
        return buffer.toByteArray();
    }

    public static /* synthetic */ byte[] readBytes$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage$src$JIO$4bdd52f8.readBytes(inputStream, n);
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String readText(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/Reader;") Reader $receiver) {
        StringWriter buffer = new StringWriter();
        IoPackage$src$JIO$4bdd52f8.copyTo$default($receiver, buffer, 0, 2);
        return buffer.toString();
    }

    @JetMethod(returnType="J")
    public static final long copyTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/InputStream;") InputStream $receiver, @JetValueParameter(name="out", type="Ljava/io/OutputStream;") OutputStream out, @JetValueParameter(name="bufferSize", hasDefaultValue=true, type="I") int bufferSize) {
        long bytesCopied = 0L;
        byte[] buffer = new byte[bufferSize];
        int bytes = $receiver.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = $receiver.read(buffer);
        }
        return bytesCopied;
    }

    public static /* synthetic */ long copyTo$default(InputStream inputStream, OutputStream outputStream, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage$src$JIO$4bdd52f8.copyTo(inputStream, outputStream, n);
    }

    @JetMethod(returnType="J")
    public static final long copyTo(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/io/Reader;") Reader $receiver, @JetValueParameter(name="out", type="Ljava/io/Writer;") Writer out, @JetValueParameter(name="bufferSize", hasDefaultValue=true, type="I") int bufferSize) {
        long charsCopied = 0L;
        char[] buffer = new char[bufferSize];
        int chars = $receiver.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = $receiver.read(buffer);
        }
        return charsCopied;
    }

    public static /* synthetic */ long copyTo$default(Reader reader, Writer writer, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage$src$JIO$4bdd52f8.copyTo(reader, writer, n);
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String readText(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/net/URL;") URL $receiver, @JetValueParameter(name="encoding", hasDefaultValue=true, type="Ljava/lang/String;") String encoding) {
        return KotlinPackage$src$ArraysJVM$562c8208.toString(IoPackage$src$JIO$4bdd52f8.readBytes($receiver), encoding);
    }

    public static /* synthetic */ String readText$default(URL uRL, String string, int n) {
        if ((n & 1) != 0) {
            string = Charset.defaultCharset().name();
        }
        return IoPackage$src$JIO$4bdd52f8.readText(uRL, string);
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String readText(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/net/URL;") URL $receiver, @JetValueParameter(name="encoding", type="Ljava/nio/charset/Charset;") Charset encoding) {
        return KotlinPackage$src$ArraysJVM$562c8208.toString(IoPackage$src$JIO$4bdd52f8.readBytes($receiver), encoding);
    }

    @JetMethod(returnType="[B")
    public static final byte[] readBytes(@JetValueParameter(name="$receiver", receiver=true, type="Ljava/net/URL;") URL $receiver) {
        InputStream inputStream = $receiver.openStream();
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        return (byte[])IoPackage$src$JIO$4bdd52f8.use((Closeable)inputStream, (Function1)IoPackage$readBytes$2.instance$);
    }

    static {
        Charset charset = Charset.forName("UTF-8");
        if (charset == null) {
            Intrinsics.throwNpe();
        }
        defaultCharset = charset;
        stdin = new BufferedReader(new InputStreamReader(new IoPackage$stdin$1()));
    }
}

