/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Sequence;
import kotlin.Unit;
import kotlin.io.AccessDeniedException;
import kotlin.io.FileTreeWalk;
import kotlin.io.FileTreeWalk$WhenMappings;
import kotlin.io.FileWalkDirection;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"V\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003!\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\rQ!\u0001\u0003\u0003\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011Q)\u0011\u0001\u0002\u0003\u0016\u0002)a\u0001!\u0007\u0003\n\u0005%\t\u0001$\u0001M\u0001;\u0007\r\"SEQ@\u0013\rA\u0019!D\u0001\u0019\u0003%!A!\u0001\u0005\u0003\u001b\u0005A*!\u0003\u0006\u0005\u0003!\u0019QbB\u0005\u0003\u0013\u0005A\u0012!\u0003\u0002\n\u0003a!\u0001tA\u0005\u000b\t\u0005AI!D\u0004\n\u0005%\t\u0001$A\u0005\u0003\u0013\u0005AB\u0001g\u0002\n\u001b\u0011\t\u0001\"B\u0007\u000b\u0013\tI\u0011\u0001G\u0001\n\u0005%\t\u0001DB\u0005\u0003\u0013\u0005AB\u0001g\u0003\n\u0015\u0011\t\u0001RB\u0007\b\u0013\tI\u0011\u0001G\u0001\n\u0005%\t\u0001d\u0002M\u0004\u0013\u0011!\u0011\u0001c\u0004\u000e\u0003aA\u0011kA\u0001\t\u0012\u0015j\u0001bA\u0007\u00021\u0001I\u0012\u0002C\u0007\u000e\u000f%\u0011\u0011\"\u0001\r\u0002\u0013\tI\u0011\u0001\u0007\u0003\u0019\b\u0015\u0002\u0002\"B\u0007\u00021\u0001IB\u0002C\u0007\u000e\u0015%\u0011\u0011\"\u0001\r\u0002\u0013\tI\u0011\u0001\u0007\u0004\n\u0005%\t\u0001\u0004\u0002M\u0006K\u0017!\u0011\t\tE\u000e\u001b\ta\t\u0001G\u0001&\u0010\u0011YE\u0001\u0003\b\u000e\t%\u0011\u0011\"\u0001\r\u00021;)S\u0002#\u0003\u000e\u0003a\u0001\u0011$\u0003\u0005\u000e\u001b\u001dI!!C\u0001\u0019\u0003%\u0011\u0011\"\u0001\r\u00051\u000f)s\u0001c\u0004\u000e\u0003a\u0001\u0011d\u0001\u0005\u0010\u001b\u0005A\u0002\"\n\u0005\u0005\u0003!}Q\"\u0001\r\u00053\rA\u0001#D\u0001\u0019\u0003\u0015j\u0001\u0012E\u0007\u00021\u0001I\u0012\u0002C\t\u000e\u000f%\u0011\u0011\"\u0001\r\u0002\u0013\tI\u0011\u0001G\u0004\u0019\b%:A!\u0011\u0005\t\u00055\t\u0001TA)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B9!IQ\"\u0001\r\b#\u000e\tQ\u0001A\u0015\u000e\t\u0005C\u0001bA\u0007\b\u0013\tI\u0011\u0001G\u0001\n\u0005%\t\u0001\u0004\u0002M\u0004#\u000e\tQ\u0001A\u0015\u0011\t\u0005C\u0001\"B\u0007\u000b\u0013\tI\u0011\u0001G\u0001\n\u0005%\t\u0001DB\u0005\u0003\u0013\u0005AB\u0001g\u0003R\u0007\u0005)\u0001!K\u0007\u0005\u0003\"Ai!D\u0004\n\u0005%\t\u0001$A\u0005\u0003\u0013\u0005Ar\u0001g\u0002R\u0007\u0005)\u0001!\u000b\u0005\u0005\u0003\"A\u0019\"D\u0001\u0019\u0015E\u001b!!B\u0001\t\u0016%jA!\u0011\u0005\t\n59\u0011BA\u0005\u00021\u0005I!!C\u0001\u0019\ta\u001d\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00105\t\u0001\u0004C)\u0004\u0003\u0015\u0001\u0011\u0006\u0003\u0003B9!YQB\u0001G\u00011\u0005\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\u0002\u001b\u0005A\u0012!U\u0002\u0002\u000b\u0001I#\u0002B!\t\u0011/iA!\u0003\u0002\n\u0003ae\u0001\u0004D)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lkotlin/io/FileTreeWalk;", "Lkotlin/Sequence;", "Ljava/io/File;", "start", "direction", "Lkotlin/io/FileWalkDirection;", "enter", "Lkotlin/Function1;", "", "leave", "fail", "Lkotlin/Function2;", "Ljava/io/IOException;", "filter", "", "maxDepth", "", "(Ljava/io/File;Lkotlin/io/FileWalkDirection;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;I)V", "end", "it", "kotlin/io/FileTreeWalk$it$1", "Lkotlin/io/FileTreeWalk$it$1;", "nextFile", "state", "Ljava/util/Stack;", "Lkotlin/io/FileTreeWalk$DirectoryState;", "function", "gotoNext", "iterator", "", "depth", "pushState", "root", "treeFilter", "predicate", "BottomUpDirectoryState", "DirectoryState", "TopDownDirectoryState"}, moduleName="kotlin-stdlib")
public final class FileTreeWalk
implements Sequence<File> {
    private final Stack<DirectoryState> state;
    private boolean end;
    private File nextFile;
    private final it.1 it;
    private final File start;
    private final FileWalkDirection direction;
    private final Function1<? super File, ? extends Unit> enter;
    private final Function1<? super File, ? extends Unit> leave;
    private final Function2<? super File, ? super IOException, ? extends Unit> fail;
    private final Function1<? super File, ? extends Boolean> filter;
    private final int maxDepth;

    private final void pushState(File root) {
        DirectoryState directoryState;
        switch (FileTreeWalk$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
            case 1: {
                directoryState = new TopDownDirectoryState(root);
                break;
            }
            case 2: {
                directoryState = new BottomUpDirectoryState(root);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.state.push(directoryState);
    }

    private final File gotoNext() {
        while (!this.end) {
            if (this.state.empty()) {
                this.end = true;
                return this.start.exists() && !this.start.isDirectory() && (Boolean)this.filter.invoke((Object)this.start) != false ? this.start : (File)null;
            }
            DirectoryState topState = this.state.peek();
            File file = topState.step();
            if (file == null) {
                this.state.pop();
                continue;
            }
            if (!((Boolean)this.filter.invoke((Object)file)).booleanValue()) {
                continue;
            }
            if (Intrinsics.areEqual((Object)file, (Object)topState.getRootDir()) || !file.isDirectory() || this.state.size() >= this.maxDepth) {
                return file;
            }
            this.pushState(file);
        }
        return null;
    }

    @NotNull
    public final FileTreeWalk enter(@NotNull Function1<? super File, ? extends Unit> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        return new FileTreeWalk(this.start, this.direction, function, this.leave, this.fail, this.filter, this.maxDepth);
    }

    @NotNull
    public final FileTreeWalk leave(@NotNull Function1<? super File, ? extends Unit> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        return new FileTreeWalk(this.start, this.direction, this.enter, function, this.fail, this.filter, this.maxDepth);
    }

    @NotNull
    public final FileTreeWalk fail(@NotNull Function2<? super File, ? super IOException, ? extends Unit> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        return new FileTreeWalk(this.start, this.direction, this.enter, this.leave, function, this.filter, this.maxDepth);
    }

    @NotNull
    public final FileTreeWalk treeFilter(@NotNull Function1<? super File, ? extends Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        return new FileTreeWalk(this.start, this.direction, this.enter, this.leave, this.fail, predicate, this.maxDepth);
    }

    @NotNull
    public final FileTreeWalk maxDepth(int depth) {
        if (depth <= 0) {
            throw (Throwable)new IllegalArgumentException("Use positive depth value");
        }
        return new FileTreeWalk(this.start, this.direction, this.enter, this.leave, this.fail, this.filter, depth);
    }

    @Override
    @NotNull
    public Iterator<File> iterator() {
        return this.it;
    }

    public FileTreeWalk(@NotNull File start, @NotNull FileWalkDirection direction, @NotNull Function1<? super File, ? extends Unit> enter, @NotNull Function1<? super File, ? extends Unit> leave, @NotNull Function2<? super File, ? super IOException, ? extends Unit> fail, @NotNull Function1<? super File, ? extends Boolean> filter, int maxDepth) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        Intrinsics.checkParameterIsNotNull(enter, (String)"enter");
        Intrinsics.checkParameterIsNotNull(leave, (String)"leave");
        Intrinsics.checkParameterIsNotNull(fail, (String)"fail");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        this.start = start;
        this.direction = direction;
        this.enter = enter;
        this.leave = leave;
        this.fail = fail;
        this.filter = filter;
        this.maxDepth = maxDepth;
        this.state = new Stack();
        if (!this.start.exists()) {
            this.end = true;
        } else if (this.start.isDirectory() && ((Boolean)this.filter.invoke((Object)this.start)).booleanValue()) {
            this.pushState(this.start);
        }
        this.it = new Iterator<File>(this){
            final /* synthetic */ FileTreeWalk this$0;

            public boolean hasNext() {
                if (FileTreeWalk.access$getNextFile$p(this.this$0) == null) {
                    FileTreeWalk.access$setNextFile$p(this.this$0, FileTreeWalk.access$gotoNext(this.this$0));
                }
                return FileTreeWalk.access$getNextFile$p(this.this$0) != null;
            }

            @NotNull
            public File next() {
                File res;
                if (FileTreeWalk.access$getNextFile$p(this.this$0) == null) {
                    FileTreeWalk.access$setNextFile$p(this.this$0, FileTreeWalk.access$gotoNext(this.this$0));
                }
                if ((res = FileTreeWalk.access$getNextFile$p(this.this$0)) == null) {
                    throw (Throwable)new NoSuchElementException();
                }
                FileTreeWalk.access$setNextFile$p(this.this$0, null);
                return res;
            }
            {
                this.this$0 = $outer;
            }

            public void remove() {
                throw new UnsupportedOperationException("Mutating immutable collection");
            }
        };
    }

    public /* synthetic */ FileTreeWalk(File file, FileWalkDirection fileWalkDirection, Function1 function1, Function1 function12, Function2 function2, Function1 function13, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            fileWalkDirection = FileWalkDirection.TOP_DOWN;
        }
        if ((n2 & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n2 & 8) != 0) {
            function12 = 2.INSTANCE;
        }
        if ((n2 & 0x10) != 0) {
            function2 = 3.INSTANCE;
        }
        if ((n2 & 0x20) != 0) {
            function13 = 4.INSTANCE;
        }
        if ((n2 & 0x40) != 0) {
            n = ((Number)IntCompanionObject.INSTANCE.getMAX_VALUE()).intValue();
        }
        this(file, fileWalkDirection, (Function1<? super File, ? extends Unit>)function1, (Function1<? super File, ? extends Unit>)function12, (Function2<? super File, ? super IOException, ? extends Unit>)function2, (Function1<? super File, ? extends Boolean>)function13, n);
    }

    @Nullable
    public static final /* synthetic */ File access$getNextFile$p(FileTreeWalk $this) {
        return $this.nextFile;
    }

    public static final /* synthetic */ void access$setNextFile$p(FileTreeWalk $this, @Nullable File file) {
        $this.nextFile = file;
    }

    @Nullable
    public static final /* synthetic */ File access$gotoNext(FileTreeWalk $this) {
        return $this.gotoNext();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tAA\u0001\u0003\u0012\u0019\u0001I\u0012\u0001'\u0001\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003K\u0015!1\u0003c\u0002\u000e\u00051\u0005\u00014A\u0015\u000b\t\rC\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!)\u0001C\u0002"}, strings={"Lkotlin/io/FileTreeWalk$DirectoryState;", "", "rootDir", "Ljava/io/File;", "(Ljava/io/File;)V", "getRootDir", "()Ljava/io/File;", "step"}, moduleName="kotlin-stdlib")
    private static abstract class DirectoryState {
        @NotNull
        private final File rootDir;

        @Nullable
        public abstract File step();

        @NotNull
        public final File getRootDir() {
            return this.rootDir;
        }

        public DirectoryState(@NotNull File rootDir) {
            Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
            this.rootDir = rootDir;
            if (!this.rootDir.isDirectory()) {
                throw (Throwable)new IllegalArgumentException("Directory is needed");
            }
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0017)\u0001!B\u0001\t\t\u0015\u0001Q!\u0001E\t\u000b\u0005!\u0019\u0001B!\u0003\u0019\u0001I\u0012\u0001'\u0001\"\u0011%%\u0001\"A\u0007\u00021\u0007\u00016\u0011A)\u0004\u0003!\u0011Q%\u0002\u0003\f\u0011\u001bi!\u0001$\u0001\u0019\u0004%:A!\u0011\u000f\t\u00065\t\u0001dA)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B9!\u001dQ\"\u0001\r\u0005#\u000e\tQ\u0001A\u0015\r\t\u0005c\u0002\u0012B\u0007\u0006\u0013\tI\u0011\u0001g\u0001\r\u0002a)\u0011k\u0001\u0002\u0006\u0003!-\u0011f\u0002\u0003B9!1Q\"\u0001\r\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lkotlin/io/FileTreeWalk$BottomUpDirectoryState;", "Lkotlin/io/FileTreeWalk$DirectoryState;", "rootDir", "Ljava/io/File;", "(Lkotlin/io/FileTreeWalk;Ljava/io/File;)V", "failed", "", "fileIndex", "", "fileList", "", "[Ljava/io/File;", "rootVisited", "step"}, moduleName="kotlin-stdlib")
    private final class BottomUpDirectoryState
    extends DirectoryState {
        private boolean rootVisited;
        private File[] fileList;
        private int fileIndex;
        private boolean failed;

        @Override
        @Nullable
        public File step() {
            if (!this.failed && this.fileList == null) {
                FileTreeWalk.this.enter.invoke((Object)this.getRootDir());
                this.fileList = this.getRootDir().listFiles();
                if (this.fileList == null) {
                    FileTreeWalk.this.fail.invoke((Object)this.getRootDir(), (Object)new AccessDeniedException(this.getRootDir(), null, "Cannot list files in a directory", 2, null));
                    this.failed = true;
                }
            }
            if (this.fileList != null) {
                if (this.fileList == null) {
                    Intrinsics.throwNpe();
                }
                if (this.fileIndex < ((Object[])this.fileList).length) {
                    if (this.fileList == null) {
                        Intrinsics.throwNpe();
                    }
                    return this.fileList[this.fileIndex++];
                }
            }
            if (!this.rootVisited) {
                this.rootVisited = true;
                return this.getRootDir();
            }
            FileTreeWalk.this.leave.invoke((Object)this.getRootDir());
            return null;
        }

        public BottomUpDirectoryState(File rootDir) {
            Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
            super(rootDir);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0011)\u0001!B\u0001\t\u0012\u0015\tA!A\u0003\u0002\u0011\u0017)\u0001\u0001B!\u0003\u0019\u0001I\u0012\u0001'\u0001\"\u0011%%\u0001\"A\u0007\u00021\u0007\u00016\u0011A)\u0004\u0003!\u0011Q%\u0002\u0003\f\u0011\u0019i!\u0001$\u0001\u0019\u0004%:A!\u0011\u000f\t\u00065\t\u0001dA)\u0004\u0003\u0015\u0001\u0011\u0006\u0004\u0003B9!\u001dQ\"B\u0005\u0003\u0013\u0005A\u001a\u0001$\u0001\u0019\tE\u001b!!B\u0001\t\n%:A!\u0011\u000f\t\u000b5\t\u00014B)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lkotlin/io/FileTreeWalk$TopDownDirectoryState;", "Lkotlin/io/FileTreeWalk$DirectoryState;", "rootDir", "Ljava/io/File;", "(Lkotlin/io/FileTreeWalk;Ljava/io/File;)V", "fileIndex", "", "fileList", "", "[Ljava/io/File;", "rootVisited", "", "step"}, moduleName="kotlin-stdlib")
    private final class TopDownDirectoryState
    extends DirectoryState {
        private boolean rootVisited;
        private File[] fileList;
        private int fileIndex;

        @Override
        @Nullable
        public File step() {
            block9: {
                block10: {
                    block11: {
                        block8: {
                            if (!this.rootVisited) {
                                FileTreeWalk.this.enter.invoke((Object)this.getRootDir());
                                this.rootVisited = true;
                                return this.getRootDir();
                            }
                            if (this.fileList == null) break block8;
                            if (this.fileList == null) {
                                Intrinsics.throwNpe();
                            }
                            if (this.fileIndex >= ((Object[])this.fileList).length) break block9;
                        }
                        if (this.fileList != null) break block10;
                        this.fileList = this.getRootDir().listFiles();
                        if (this.fileList == null) {
                            FileTreeWalk.this.fail.invoke((Object)this.getRootDir(), (Object)new AccessDeniedException(this.getRootDir(), null, "Cannot list files in a directory", 2, null));
                        }
                        if (this.fileList == null) break block11;
                        if (this.fileList == null) {
                            Intrinsics.throwNpe();
                        }
                        if (((Object[])this.fileList).length != 0) break block10;
                    }
                    FileTreeWalk.this.leave.invoke((Object)this.getRootDir());
                    return null;
                }
                if (this.fileList == null) {
                    Intrinsics.throwNpe();
                }
                return this.fileList[this.fileIndex++];
            }
            FileTreeWalk.this.leave.invoke((Object)this.getRootDir());
            return null;
        }

        public TopDownDirectoryState(File rootDir) {
            Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
            super(rootDir);
        }
    }
}

